/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.oobn.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import unbbayes.gui.oobn.node.OOBNNodeGraphicalWrapper;
import unbbayes.io.NetIO;
import unbbayes.io.builder.IProbabilisticNetworkBuilder;
import unbbayes.io.exception.LoadException;
import unbbayes.io.oobn.IObjectOrientedBayesianNetworkIO;
import unbbayes.io.oobn.builder.DefaultOOBNClassBuilder;
import unbbayes.io.oobn.builder.DefaultPrivateOOBNNodeGraphicalWrapperBuilder;
import unbbayes.io.oobn.builder.IOOBNClassBuilder;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IObjectOrientedBayesianNetwork;
import unbbayes.prs.oobn.exception.OOBNException;
import unbbayes.prs.oobn.impl.DefaultOOBNClass;
import unbbayes.prs.oobn.impl.ObjectOrientedBayesianNetwork;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOOBNIO
extends NetIO
implements IObjectOrientedBayesianNetworkIO {
    public static final String FILE_EXTENSION = ".oobn";
    private IObjectOrientedBayesianNetwork oobn = ObjectOrientedBayesianNetwork.newInstance("");
    private Map<String, IOOBNClass> classNameToClassMap = null;

    protected DefaultOOBNIO() {
        this.setClassNameToClassMap(new HashMap<String, IOOBNClass>());
    }

    public static DefaultOOBNIO newInstance() {
        return new DefaultOOBNIO();
    }

    public static DefaultOOBNIO newInstance(IObjectOrientedBayesianNetwork oobn) {
        DefaultOOBNIO ret = new DefaultOOBNIO();
        ret.setOobn(oobn);
        return ret;
    }

    @Override
    public SingleAgentMSBN loadMSBN(File input) throws LoadException, IOException {
        Debug.println(this.getClass(), "An extremely horrible anti-pattern is forced by superclass or interface." + this.getClass() + " refuses to realize such bizarre implementation.");
        throw new IllegalArgumentException(new NoSuchMethodException("No implementation of SingleAgentMSBN loadMSBN(File input) by " + this.getClass()));
    }

    @Override
    public void saveMSBN(File output, SingleAgentMSBN net) throws FileNotFoundException {
        Debug.println(this.getClass(), "An extremely horrible anti-pattern is forced by superclass or interface." + this.getClass() + " refuses to realize such bizarre implementation.");
        throw new IllegalArgumentException(new NoSuchMethodException("No implementation of saveMSBN(File output, SingleAgentMSBN net) by " + this.getClass()));
    }

    @Override
    public DefaultOOBNClass load(File input, IProbabilisticNetworkBuilder networkBuilder) throws LoadException, IOException {
        DefaultOOBNClass ret = null;
        Debug.println(this.getClass(), "Loading multiple class is not implemented yet. Using default behavior...");
        int index = input.getName().lastIndexOf(46);
        String id = input.getName().substring(0, index);
        ret = (DefaultOOBNClass)networkBuilder.buildNetwork(id);
        this.load(input, ret, networkBuilder);
        return ret;
    }

    @Override
    public ProbabilisticNetwork load(File input) throws LoadException, IOException {
        DefaultOOBNClassBuilder builder = DefaultOOBNClassBuilder.newInstance();
        builder.setProbabilisticNodeBuilder(DefaultPrivateOOBNNodeGraphicalWrapperBuilder.newInstance());
        return this.load(input, builder);
    }

    @Override
    public void save(File output, SingleEntityNetwork net) throws FileNotFoundException {
        Debug.println(this.getClass(), "Saving multiple classes is not implemented yet. Using default behavior...");
        ArrayList<OOBNNodeGraphicalWrapper> ordinalNodes = new ArrayList<OOBNNodeGraphicalWrapper>();
        ArrayList<OOBNNodeGraphicalWrapper> instanceNodes = new ArrayList<OOBNNodeGraphicalWrapper>();
        PrintStream stream = new PrintStream(new FileOutputStream(output));
        stream.print("class ");
        stream.println(net.getName());
        stream.println("{");
        this.saveClassHeaderBody(stream, net);
        for (Node node : net.getNodes()) {
            if (node instanceof OOBNNodeGraphicalWrapper) {
                OOBNNodeGraphicalWrapper wrapper = (OOBNNodeGraphicalWrapper)node;
                if ((wrapper.getWrappedNode().getType() & 8) == 0) {
                    ordinalNodes.add(wrapper);
                    continue;
                }
                if (wrapper.getWrappedNode().getType() != 8) continue;
                instanceNodes.add(wrapper);
                continue;
            }
            Debug.println(this.getClass(), String.valueOf(node.getName()) + " is not a OOBNNodeGraphicalWrapper");
        }
        for (OOBNNodeGraphicalWrapper oOBNNodeGraphicalWrapper : ordinalNodes) {
            this.saveNodeDeclaration(stream, oOBNNodeGraphicalWrapper, net);
        }
        for (OOBNNodeGraphicalWrapper oOBNNodeGraphicalWrapper : instanceNodes) {
            this.saveInstanceDeclaration(stream, oOBNNodeGraphicalWrapper, net);
        }
        for (Node node : net.getNodes()) {
            if (node instanceof OOBNNodeGraphicalWrapper) {
                if ((((OOBNNodeGraphicalWrapper)node).getWrappedNode().getType() & 8) != 0) continue;
                this.savePotentialDeclaration(stream, node, net);
                continue;
            }
            Debug.println(this.getClass(), String.valueOf(node.getName()) + " is not a OOBNNodeGraphicalWrapper");
        }
        stream.print("} ");
        stream.println("% class " + net.getName());
        stream.close();
    }

    public IObjectOrientedBayesianNetwork getOobn() {
        return this.oobn;
    }

    public void setOobn(IObjectOrientedBayesianNetwork oobn) {
        this.oobn = oobn;
    }

    @Override
    public IObjectOrientedBayesianNetwork loadOOBN(File classFile) throws IOException {
        Debug.println(this.getClass(), "Dependency treatment is not implemented yet, that means you cannot load a class containing instances yet.");
        this.getOobn().setTitle(classFile.getName());
        try {
            this.load(classFile);
        }
        catch (LoadException le) {
            throw new IOException(le);
        }
        return this.getOobn();
    }

    public Map<String, IOOBNClass> getClassNameToClassMap() {
        return this.classNameToClassMap;
    }

    public void setClassNameToClassMap(Map<String, IOOBNClass> classNameToClassMap) {
        this.classNameToClassMap = classNameToClassMap;
    }

    @Override
    public void saveOOBNClass(File classFile, IOOBNClass oobnClass) throws IOException {
        String newClassName = classFile.getName().substring(0, classFile.getName().lastIndexOf("."));
        try {
            oobnClass.setClassName(newClassName);
        }
        catch (OOBNException oobne) {
            throw new IOException(oobne);
        }
        this.save(classFile, (SingleEntityNetwork)oobnClass.getNetwork());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void load(File input, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException, LoadException {
        OOBNNodeGraphicalWrapper node;
        ArrayList<String> inputNodesNames = new ArrayList<String>();
        ArrayList<String> outputNodesNames = new ArrayList<String>();
        HashMap<OOBNNodeGraphicalWrapper, String> instanceInputParentMap = new HashMap<OOBNNodeGraphicalWrapper, String>();
        BufferedReader r = new BufferedReader(new FileReader(input));
        StreamTokenizer st = new StreamTokenizer(r);
        this.setUpStreamTokenizer(st);
        this.getNext(st);
        if (!st.sval.equals("class")) {
            super.load(input, net, DefaultOOBNClassBuilder.newInstance());
            this.getOobn().getOOBNClassList().add((IOOBNClass)((Object)net));
            return;
        }
        this.getNext(st);
        if (st.ttype != -3) {
            throw new LoadException("NoClassNameDefinition");
        }
        net.setName(st.sval);
        this.loadClassHeader(st, net, inputNodesNames, outputNodesNames);
        while (this.getNext(st) != -1) {
            this.treatInstanceNodeDeclaration(input, st, net, (IOOBNClassBuilder)networkBuilder, networkBuilder, this.classNameToClassMap, instanceInputParentMap);
            this.loadContinuousNodeDeclaration(st, net, networkBuilder);
            this.loadNodeDeclaration(st, net, networkBuilder);
            this.loadPotentialDeclaration(st, net);
        }
        r.close();
        for (String outputName : outputNodesNames) {
            try {
                node = (OOBNNodeGraphicalWrapper)net.getNode(outputName);
                node.getWrappedNode().setType(1);
            }
            catch (ClassCastException cce) {
                Debug.println(this.getClass(), "Could not change " + outputName + "'s oobn node type to output.", cce);
            }
        }
        for (String inputName : inputNodesNames) {
            try {
                node = (OOBNNodeGraphicalWrapper)net.getNode(inputName);
                node.getWrappedNode().setType(4);
            }
            catch (ClassCastException cce) {
                Debug.println(this.getClass(), "Could not change " + inputName + "'s oobn node type to input.", cce);
            }
        }
        for (OOBNNodeGraphicalWrapper key : instanceInputParentMap.keySet()) {
            String parentName = (String)instanceInputParentMap.get(key);
            try {
                net.addEdge(new Edge(net.getNode(parentName), key));
            }
            catch (InvalidParentException ipe) {
                Debug.println(this.getClass(), "Error insertng instance input's parent: " + key.getName() + " <- " + parentName, ipe);
            }
        }
        this.setUpHierarchicTree(net);
        this.getOobn().getOOBNClassList().add((IOOBNClass)((Object)net));
    }

    protected void loadClassHeader(StreamTokenizer st, SingleEntityNetwork net, List<String> inputNodesNames, List<String> outputNodesNames) throws IOException {
        this.getNext(st);
        if (st.sval.equals("{")) {
            this.getNext(st);
            while (!st.sval.equals("node") && !st.sval.equals("instance")) {
                if (st.sval.equals("inputs")) {
                    while (this.getNextWithoutIgnoringChars(st, ';') == -3) {
                        inputNodesNames.add(st.sval);
                    }
                } else if (st.sval.equals("outputs")) {
                    while (this.getNextWithoutIgnoringChars(st, ';') == -3) {
                        outputNodesNames.add(st.sval);
                    }
                } else if (!st.sval.equals("name")) {
                    this.loadNetHeaderBody(st, net);
                }
                this.getNext(st);
            }
            st.pushBack();
        }
    }

    protected int getNextWithoutIgnoringChars(StreamTokenizer st, char ... notToIgnore) throws IOException {
        do {
            st.nextToken();
            if (st.ttype == 10) {
                ++this.lineno;
            }
            char[] cArray = notToIgnore;
            int n = notToIgnore.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (st.ttype == c) {
                    return st.ttype;
                }
                ++n2;
            }
        } while (st.ttype != -3 && st.ttype != 34 && st.ttype != -1);
        return st.ttype;
    }

    protected void treatInstanceNodeDeclaration(File originalClassFile, StreamTokenizer st, SingleEntityNetwork net, IOOBNClassBuilder classBuilder, IProbabilisticNetworkBuilder networkBuilder, Map<String, IOOBNClass> classNameToClassMap, Map<OOBNNodeGraphicalWrapper, String> instanceInputParentMap) throws IOException, LoadException {
        if (st.sval.equals("instance")) {
            if (this.getNext(st) != -3) {
                throw new LoadException("-> [" + (this.lineno > (long)st.lineno() ? this.lineno : (long)st.lineno()) + "] instance [???]");
            }
            String instanceName = st.sval;
            if (this.getNext(st) != -3) {
                throw new LoadException("-> [" + (this.lineno > (long)st.lineno() ? this.lineno : (long)st.lineno()) + "] instance " + instanceName + " : [???] ");
            }
            String className = st.sval;
            Debug.println(this.getClass(), "Loading instance " + instanceName + " instanceof " + className);
            IOOBNClass oobnClass = null;
            for (IOOBNClass currentClass : this.getOobn().getOOBNClassList()) {
                if (!currentClass.getClassName().equals(className)) continue;
                oobnClass = currentClass;
                break;
            }
            if (oobnClass == null) {
                File input = new File(originalClassFile.getParent(), String.valueOf(className) + FILE_EXTENSION);
                oobnClass = (IOOBNClass)((Object)classBuilder.buildNetwork(className));
                this.load(input, (SingleEntityNetwork)oobnClass.getNetwork(), networkBuilder);
            }
            OOBNNodeGraphicalWrapper instance = classBuilder.getInstanceNodeBuilder().buildInstanceNode(oobnClass);
            instance.setName(instanceName);
            while (this.getNextWithoutIgnoringChars(st, ';') != 59) {
                String nodeName = st.sval;
                OOBNNodeGraphicalWrapper instanceInputNode = null;
                for (OOBNNodeGraphicalWrapper inner : instance.getInnerNodes()) {
                    if (!inner.getWrappedNode().getOriginalClassNode().getName().equals(nodeName)) continue;
                    instanceInputNode = inner;
                    break;
                }
                if (this.getNext(st) != -3) {
                    throw new LoadException(String.valueOf(nodeName) + " <- " + (char)st.ttype);
                }
                if (instanceInputNode != null) {
                    instanceInputParentMap.put(instanceInputNode, st.sval);
                    continue;
                }
                Debug.println(this.getClass(), "An inconsistent instance input mapping was found: " + nodeName + " <- " + st.sval);
            }
            this.getNext(st);
            while (!st.sval.equals("{")) {
                Debug.println(this.getClass(), "Ignoring instance output declaration: [TTYPE = " + st.ttype + "] " + st.sval);
                this.getNext(st);
            }
            this.getNext(st);
            while (!st.sval.equals("}")) {
                this.loadNodeDeclarationBody(st, instance);
            }
            net.addNode(instance);
        }
    }

    protected void saveClassHeaderBody(PrintStream stream, SingleEntityNetwork net) {
        ArrayList<OOBNNodeGraphicalWrapper> inputNodes = new ArrayList<OOBNNodeGraphicalWrapper>();
        ArrayList<OOBNNodeGraphicalWrapper> outputNodes = new ArrayList<OOBNNodeGraphicalWrapper>();
        for (Node node : net.getNodes()) {
            if (!(node instanceof OOBNNodeGraphicalWrapper)) continue;
            OOBNNodeGraphicalWrapper wrapper = (OOBNNodeGraphicalWrapper)node;
            if (wrapper.getWrappedNode().getType() == 4) {
                inputNodes.add(wrapper);
                continue;
            }
            if (wrapper.getWrappedNode().getType() != 1) continue;
            outputNodes.add(wrapper);
        }
        stream.print("\t inputs =  (");
        for (OOBNNodeGraphicalWrapper input : inputNodes) {
            stream.print(" ");
            stream.print(input.getName());
        }
        stream.println(" );");
        stream.print("\t outputs =  (");
        for (OOBNNodeGraphicalWrapper output : outputNodes) {
            stream.print(" ");
            stream.print(output.getName());
        }
        stream.println(" );");
        this.saveNetHeaderBody(stream, net);
        stream.println();
    }

    protected void saveInstanceDeclaration(PrintStream stream, OOBNNodeGraphicalWrapper instance, SingleEntityNetwork net) {
        stream.print("\t instance ");
        stream.print(instance.getName());
        stream.print(" : ");
        stream.print(instance.getWrappedNode().getParentClass());
        stream.print(" (");
        this.saveInnerNodeMapping(stream, instance);
        stream.println(")");
        stream.println("\t {");
        this.saveNodeLabelAndPosition(stream, instance);
        stream.println("\t }");
        stream.println();
    }

    protected void saveInnerNodeMapping(PrintStream stream, OOBNNodeGraphicalWrapper instance) {
        ArrayList<OOBNNodeGraphicalWrapper> instanceInputs = new ArrayList<OOBNNodeGraphicalWrapper>();
        ArrayList<OOBNNodeGraphicalWrapper> instanceOutputs = new ArrayList<OOBNNodeGraphicalWrapper>();
        for (OOBNNodeGraphicalWrapper inner : instance.getInnerNodes()) {
            if (inner.getWrappedNode().getType() == 12) {
                instanceInputs.add(inner);
                continue;
            }
            if (inner.getWrappedNode().getType() != 9) continue;
            instanceOutputs.add(inner);
        }
        Iterator iter = instanceInputs.iterator();
        while (iter.hasNext()) {
            OOBNNodeGraphicalWrapper input = (OOBNNodeGraphicalWrapper)iter.next();
            if (input.getParents() == null || input.getParents().isEmpty()) continue;
            stream.print(input.getWrappedNode().getOriginalClassNode().getName());
            stream.print(" = ");
            stream.print(input.getParents().get(0));
            if (!iter.hasNext()) continue;
            stream.print(", ");
        }
        stream.print("; ");
        iter = instanceOutputs.iterator();
        while (iter.hasNext()) {
            OOBNNodeGraphicalWrapper output = (OOBNNodeGraphicalWrapper)iter.next();
            stream.print(output.getName());
            stream.print(" = ");
            stream.print(output.getWrappedNode().getOriginalClassNode().getName());
            if (!iter.hasNext()) continue;
            stream.print(", ");
        }
    }
}

