/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;
import unbbayes.io.BaseIO;
import unbbayes.io.exception.LoadException;
import unbbayes.io.exception.SaveException;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.msbn.SubNetwork;

public class XMLBIFIO
implements BaseIO {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.io.resources.IoResources");

    public ProbabilisticNetwork load(File input) throws LoadException, IOException, JAXBException {
        int index = input.getName().lastIndexOf(46);
        String id = input.getName().substring(0, index);
        ProbabilisticNetwork pn = new ProbabilisticNetwork(id);
        try {
            unbbayes.io.xmlbif.version5.XMLBIFIO.loadXML(input, pn);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                unbbayes.io.xmlbif.version4.XMLBIFIO.loadXML(input, pn);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new LoadException(resource.getString("UnsupportedError"));
            }
        }
        return pn;
    }

    public SingleAgentMSBN loadMSBN(File input) throws IOException, LoadException, JAXBException {
        if (!input.isDirectory()) {
            throw new LoadException(resource.getString("IsNotDirectoryException"));
        }
        SingleAgentMSBN msbn = new SingleAgentMSBN(input.getName());
        File[] files = input.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String fileName = files[i].getName();
                int index = fileName.lastIndexOf(46);
                if (index < 0) {
                    throw new RuntimeException();
                }
                if (fileName.substring(index + 1).equalsIgnoreCase("xml")) {
                    SubNetwork net = new SubNetwork(fileName.substring(0, index));
                    try {
                        unbbayes.io.xmlbif.version5.XMLBIFIO.loadXML(files[i], net);
                    }
                    catch (Exception e) {
                        try {
                            unbbayes.io.xmlbif.version4.XMLBIFIO.loadXML(files[i], net);
                        }
                        catch (Exception e2) {
                            throw new LoadException(resource.getString("UnsupportedError"));
                        }
                    }
                    msbn.addNetwork(net);
                }
            }
            ++i;
        }
        return msbn;
    }

    public void save(File output, SingleEntityNetwork net) throws IOException, JAXBException {
        FileWriter outputxml = new FileWriter(output);
        unbbayes.io.xmlbif.version5.XMLBIFIO.saveXML(outputxml, net);
        outputxml.flush();
        outputxml.close();
    }

    public void saveMSBN(File output, SingleAgentMSBN msbn) throws FileNotFoundException, IOException, JAXBException, SaveException {
        if (!output.isDirectory()) {
            throw new SaveException(resource.getString("IsNotDirectoryException"));
        }
        int i = msbn.getNetCount() - 1;
        while (i >= 0) {
            SubNetwork net = msbn.getNetAt(i);
            File out = new File(output, String.valueOf(net.getId()) + ".xml");
            this.save(out, net);
            --i;
        }
    }
}

