/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.util.Debug;

public class LogManager
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_BUFFER_SIZE = 10240;
    public static final String DEFAULT_FILENAME = "aj.txt";
    private StringBuffer log;
    protected static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.io.resources.IoResources");

    public LogManager(int bufferSize) {
        this.log = new StringBuffer(bufferSize);
        this.reset();
    }

    public LogManager() {
        this(10240);
    }

    public void clear() {
        this.log.setLength(0);
    }

    public void reset() {
        this.clear();
    }

    public void append(String text) {
        this.log.append(text);
        Debug.print(text);
    }

    public void appendIfTrue(boolean debug, String text) {
        if (debug) {
            this.append(text);
        }
    }

    public void appendln(String text) {
        this.log.append(text);
        this.log.append("\n");
        Debug.println(text);
    }

    public void appendlnIfTrue(boolean debug, String text) {
        if (debug) {
            this.appendln(text);
        }
    }

    public String getLog() {
        return this.log.toString();
    }

    public void writeToDisk(String fileName, boolean append) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(fileName, append));
        out.write(this.getLog());
        out.flush();
        out.close();
    }
}

