/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.oobn.node;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import unbbayes.draw.DrawElement;
import unbbayes.draw.DrawEllipse;
import unbbayes.draw.DrawRectangle;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.oobn.IOOBNNode;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOBNNodeGraphicalWrapper
extends ProbabilisticNode {
    private int width = Node.getWidth();
    private int height = Node.getHeight();
    public static final float INSTANCE_SIZE_MULTIPLIER = 1.5f;
    private static final int RAWS_NUM = 3;
    private DrawElement nodeDrawer = null;
    private IOOBNNode wrappedNode = null;
    private boolean isImmutableNode = false;
    private Set<OOBNNodeGraphicalWrapper> innerNodes = null;
    private Color inputColor = Color.LIGHT_GRAY;
    private Color privateColor;
    private Color instanceColor = this.privateColor = Color.WHITE;
    private Color instanceInputColor = new Color(200, 200, 200);
    private Color instanceOutputColor = this.instanceColor;

    protected OOBNNodeGraphicalWrapper(IOOBNNode wrappedNode) {
        this.setWrappedNode(wrappedNode);
    }

    public static OOBNNodeGraphicalWrapper newInstance(IOOBNNode wrappedNode) {
        OOBNNodeGraphicalWrapper ret = new OOBNNodeGraphicalWrapper(wrappedNode);
        ret.initDrawer();
        ret.setOutputColor(OOBNNodeGraphicalWrapper.getDescriptionColor());
        ret.setInnerNodes(new HashSet<OOBNNodeGraphicalWrapper>());
        ret.initMarginalList();
        ret.setUpInnerNodesGraphically();
        return ret;
    }

    protected void initDrawer() {
        this.nodeDrawer = new DrawEllipse(this.position, size);
        DrawElement.setSelectionColor(DrawElement.getSelectionColor());
        Color transparent = new Color(255, 255, 255, 0);
        DrawElement.setOutlineColor(transparent);
        this.drawElement.setFillColor(transparent);
        DrawElement.setOutlineColor(Color.BLACK);
        this.nodeDrawer.setFillColor(this.getOutputColor());
        DrawElement.setSelectionColor(Color.RED);
        this.drawElement.add(this.nodeDrawer);
    }

    @Override
    public void paint(Graphics2D graphics) {
        if (!this.isImmutableNode()) {
            switch (this.getWrappedNode().getType()) {
                case 4: {
                    this.getNodeDrawer().setFillColor(this.getInputColor());
                    break;
                }
                case 2: {
                    this.getNodeDrawer().setFillColor(this.getPrivateColor());
                    break;
                }
                case 8: {
                    this.setUpInstanceDrawer();
                    this.setImmutableNode(true);
                    break;
                }
                case 12: {
                    this.getNodeDrawer().setFillColor(this.getInstanceInputColor());
                    break;
                }
                case 9: {
                    this.getNodeDrawer().setFillColor(this.getInstanceOutputColor());
                    break;
                }
                default: {
                    this.getNodeDrawer().setFillColor(this.getOutputColor());
                }
            }
        }
        this.getNodeDrawer().setSelected(this.isSelected());
        super.paint(graphics);
    }

    protected void setUpInstanceDrawer() {
        if ((this.getWrappedNode().getType() & 8) == 0) {
            return;
        }
        int horizontalNodeNumber = Math.max(this.getWrappedNode().getParentClass().getInputNodes().size(), this.getWrappedNode().getParentClass().getOutputNodes().size());
        if (horizontalNodeNumber <= 0) {
            horizontalNodeNumber = 1;
        }
        Point2D.Double size = new Point2D.Double(Node.getSize().getX() * (double)horizontalNodeNumber * 1.5, Node.getSize().getY() * 3.0 * 1.5);
        this.setNodeDrawer(new DrawRectangle(this.getPosition(), size));
        this.getNodeDrawer().setFillColor(this.getInstanceColor());
        this.getNodeDrawer();
        DrawElement.setOutlineColor(Color.black);
        try {
            this.setSizeVariable(size.getX(), size.getY());
            this.setWidth((int)size.getX());
            this.setHeight((int)size.getY());
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Could not set width and height", e);
        }
    }

    public IOOBNNode getWrappedNode() {
        return this.wrappedNode;
    }

    public void setWrappedNode(IOOBNNode wrappedNode) {
        this.wrappedNode = wrappedNode;
    }

    public DrawElement getNodeDrawer() {
        return this.nodeDrawer;
    }

    public void setNodeDrawer(DrawElement nodeDrawer) {
        this.drawElement.remove(this.getNodeDrawer());
        this.nodeDrawer = nodeDrawer;
        this.drawElement.add(this.nodeDrawer);
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public Color getOutputColor() {
        return ProbabilisticNode.getDescriptionColor();
    }

    public void setOutputColor(Color outputColor) {
        ProbabilisticNode.setDescriptionColor(outputColor.getRGB());
    }

    public Color getPrivateColor() {
        return this.privateColor;
    }

    public void setPrivateColor(Color privateColor) {
        this.privateColor = privateColor;
    }

    public Color getInstanceColor() {
        return this.instanceColor;
    }

    public void setInstanceColor(Color instanceColor) {
        this.instanceColor = instanceColor;
    }

    public boolean isImmutableNode() {
        return this.isImmutableNode;
    }

    public void setImmutableNode(boolean isImmutableNode) {
        this.isImmutableNode = isImmutableNode;
    }

    @Override
    public String getName() {
        try {
            return this.getWrappedNode().getName();
        }
        catch (Exception e) {
            return super.getName();
        }
    }

    @Override
    public void setName(String name) {
        try {
            this.getWrappedNode().setName(name);
            super.setName(this.getWrappedNode().getName());
            this.setLabel(this.getName());
        }
        catch (Exception e) {
            super.setName(name);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void appendState(String state) {
        super.appendState(state);
        try {
            this.getWrappedNode().getStateNames().add(state);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Failure on append state", e);
        }
    }

    @Override
    public void removeStateAt(int index) {
        super.removeStateAt(index);
        try {
            this.getWrappedNode().getStateNames().remove(index);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Failure removeStateAt", e);
        }
    }

    @Override
    public void setStateAt(String state, int index) {
        super.setStateAt(state, index);
        try {
            this.getWrappedNode().getStateNames().set(index, state);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Failure setStateAt", e);
        }
    }

    @Override
    public void setStates(List<String> states) {
        super.setStates(states);
        try {
            this.getWrappedNode().setStateNames(states);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Failure setStates", e);
        }
    }

    public Color getInstanceInputColor() {
        return this.instanceInputColor;
    }

    public void setInstanceInputColor(Color instanceInputColor) {
        this.instanceInputColor = instanceInputColor;
    }

    public Color getInstanceOutputColor() {
        return this.instanceOutputColor;
    }

    public void setInstanceOutputColor(Color instanceOutputColor) {
        this.instanceOutputColor = instanceOutputColor;
    }

    public int getThisWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getThisHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    protected void setUpInnerNodesGraphically() {
        int n = this.getWrappedNode().getType();
        this.getWrappedNode();
        if ((n & 8) == 0) {
            return;
        }
        this.setDescription(this.getName());
        if (this.getPosition() == null) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": position == null");
        }
        double inputNodeY = this.getPosition().getY() - Node.getSize().getY();
        double outputNodeY = this.getPosition().getY() + Node.getSize().getY();
        Set<IOOBNNode> inputNodes = null;
        try {
            inputNodes = this.getWrappedNode().getParentClass().getInputNodes();
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Could not retrieve input nodes of " + this.getWrappedNode().getParentClass(), e);
        }
        double nodeX = this.getPosition().getX() + (double)(inputNodes.size() % 2 == 0 ? (float)Node.getWidth() * 1.5f / 2.0f : 0.0f) - (double)((float)(inputNodes.size() / 2 * Node.getWidth()) * 1.5f);
        try {
            for (IOOBNNode input : inputNodes) {
                this.getInnerNodes().add(this.insertInnerNode(this.getWrappedNode(), input, 12, nodeX, inputNodeY));
                nodeX += (double)((float)Node.getWidth() * 1.5f);
            }
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Error filling Input nodes", e);
        }
        Set<IOOBNNode> outputNodes = null;
        try {
            outputNodes = this.getWrappedNode().getParentClass().getOutputNodes();
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Could not retrieve output nodes of " + this.getWrappedNode().getParentClass(), e);
        }
        nodeX = this.getPosition().getX() + (double)(outputNodes.size() % 2 == 0 ? (float)Node.getWidth() * 1.5f / 2.0f : 0.0f) - (double)((float)(outputNodes.size() / 2 * Node.getWidth()) * 1.5f);
        for (IOOBNNode output : outputNodes) {
            this.getInnerNodes().add(this.insertInnerNode(this.getWrappedNode(), output, 9, nodeX, outputNodeY));
            nodeX += (double)((float)Node.getWidth() * 1.5f);
        }
        Debug.println(this.getClass(), "Instance node " + this.getName() + "'s inner nodes are fully populated now.");
    }

    private OOBNNodeGraphicalWrapper insertInnerNode(IOOBNNode upperNode, IOOBNNode oobnNode, int type, double x, double y) {
        OOBNNodeGraphicalWrapper node = null;
        try {
            node = OOBNNodeGraphicalWrapper.newInstance(oobnNode.clone());
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Could not obtain new instance of OOBNNodeGraphicalWrapper", e);
        }
        node.getWrappedNode().setOriginalClassNode(oobnNode);
        node.setPosition(x, y);
        node.setStates(oobnNode.getStateNames());
        node.setName(oobnNode.getName());
        node.setDescription(node.getName());
        node.getWrappedNode().setType(type);
        node.getWrappedNode().setUpperInstanceNode(upperNode);
        node.getWrappedNode().setParentClass(upperNode.getParentClass());
        upperNode.addInnerNode(node.getWrappedNode());
        PotentialTable auxTabProb = node.getPotentialTable();
        auxTabProb.addVariable(node);
        float linearValue = 1.0f / (float)node.getStatesSize();
        int i = 0;
        while (i < auxTabProb.tableSize()) {
            auxTabProb.setValue(i, linearValue);
            ++i;
        }
        return node;
    }

    public Set<OOBNNodeGraphicalWrapper> getInnerNodes() {
        return this.innerNodes;
    }

    public void setInnerNodes(Set<OOBNNodeGraphicalWrapper> innerNodes) {
        this.innerNodes = innerNodes;
    }

    @Override
    public void setPosition(double x, double y) {
        double deltaX = x - this.getPosition().getX();
        double deltaY = y - this.getPosition().getY();
        super.setPosition(x, y);
        int n = this.getWrappedNode().getType();
        this.getWrappedNode();
        if (n == 8) {
            try {
                for (OOBNNodeGraphicalWrapper inner : this.getInnerNodes()) {
                    inner.setPosition(inner.getPosition().getX() + deltaX, inner.getPosition().getY() + deltaY);
                }
            }
            catch (RuntimeException e) {
                Debug.println(this.getClass(), "It was not possible to move inner node of " + this.getName());
                throw e;
            }
        }
    }

    @Override
    public void addParent(Node parent) throws InvalidParentException {
        try {
            this.getWrappedNode().addParent(((OOBNNodeGraphicalWrapper)parent).getWrappedNode());
            super.addParent(parent);
            parent.addChild(this);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Could not add a parent to wrapped OOBN node", e);
            throw new InvalidParentException(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IOOBNNode) {
            return this.getWrappedNode().equals(obj);
        }
        if (obj instanceof OOBNNodeGraphicalWrapper) {
            return this == obj || this.getName().equals(((OOBNNodeGraphicalWrapper)obj).getName());
        }
        return super.equals(obj);
    }
}

