/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.formula;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import unbbayes.controller.IconController;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;

public class FormulaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 0L;
    protected IconController iconController = IconController.getInstance();
    protected ImageIcon folderSmallIcon = this.iconController.getOpenIcon();
    protected ImageIcon andIcon = this.iconController.getAndIcon();
    protected ImageIcon orIcon = this.iconController.getOrIcon();
    protected ImageIcon notIcon = this.iconController.getNotIcon();
    protected ImageIcon equalIcon = this.iconController.getEqualIcon();
    protected ImageIcon impliesIcon = this.iconController.getImpliesIcon();
    protected ImageIcon forallIcon = this.iconController.getForallIcon();
    protected ImageIcon existsIcon = this.iconController.getExistsIcon();
    protected ImageIcon iffIcon = this.iconController.getIffIcon();
    protected ImageIcon entityNodeIcon = this.iconController.getEntityInstanceIcon();
    protected ImageIcon stateIcon = this.iconController.getStateIcon();
    protected ImageIcon ovariableNodeIcon = this.iconController.getOVariableNodeIcon();
    protected ImageIcon nodeNodeIcon = this.iconController.getNodeNodeIcon();
    protected ImageIcon skolenNodeIcon = this.iconController.getSkolenNodeIcon();
    protected ImageIcon emptyNodeIcon = this.iconController.getEmptyNodeIcon();
    protected ImageIcon yellowBallIcon = this.iconController.getYellowBallIcon();
    protected ImageIcon orangeBallIcon = this.iconController.getOrangeNodeIcon();
    protected ImageIcon hierarchyBallIcon = this.iconController.getHierarchyIcon();
    protected ImageIcon boxVariablesIcon = this.iconController.getBoxVariablesIcon();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value == null) {
            return this;
        }
        NodeFormulaTree nodeFormula = (NodeFormulaTree)((DefaultMutableTreeNode)value).getUserObject();
        EnumType type = nodeFormula.getTypeNode();
        EnumSubType subType = nodeFormula.getSubTypeNode();
        switch (type) {
            case EMPTY: {
                this.setIcon(this.emptyNodeIcon);
                return this;
            }
            case FORMULA: {
                this.setIcon(this.hierarchyBallIcon);
                return this;
            }
            case SIMPLE_OPERATOR: {
                switch (subType) {
                    case AND: {
                        this.setIcon(this.andIcon);
                        return this;
                    }
                    case OR: {
                        this.setIcon(this.orIcon);
                        return this;
                    }
                    case NOT: {
                        this.setIcon(this.notIcon);
                        return this;
                    }
                    case EQUALTO: {
                        this.setIcon(this.equalIcon);
                        return this;
                    }
                    case IMPLIES: {
                        this.setIcon(this.impliesIcon);
                        return this;
                    }
                    case IFF: {
                        this.setIcon(this.iffIcon);
                        return this;
                    }
                }
                return this;
            }
            case QUANTIFIER_OPERATOR: {
                switch (subType) {
                    case FORALL: {
                        this.setIcon(this.forallIcon);
                        return this;
                    }
                    case EXISTS: {
                        this.setIcon(this.existsIcon);
                        return this;
                    }
                }
                return this;
            }
            case VARIABLE_SEQUENCE: {
                this.setIcon(this.boxVariablesIcon);
                return this;
            }
            case OPERAND: {
                switch (subType) {
                    case OVARIABLE: {
                        this.setIcon(this.ovariableNodeIcon);
                        return this;
                    }
                    case NODE: {
                        this.setIcon(this.nodeNodeIcon);
                        return this;
                    }
                    case ENTITY: {
                        this.setIcon(this.stateIcon);
                        return this;
                    }
                    case VARIABLE: {
                        this.setIcon(this.orangeBallIcon);
                        return this;
                    }
                }
                return this;
            }
            case VARIABLE: {
                this.setIcon(this.orangeBallIcon);
                return this;
            }
        }
        this.setIcon(this.folderSmallIcon);
        return this;
    }
}

