/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.formula;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import unbbayes.controller.FormulaTreeController;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;

public class BuilderMenuNode {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private JMenuItem itemDelete = new JMenuItem("delete");
    private JMenuItem itemNode = new JMenuItem("addNode");
    private JMenuItem itemEntity = new JMenuItem("addEntity");
    private JMenuItem itemOVariable = new JMenuItem("addOVariable");
    private JMenuItem itemVariable = new JMenuItem("addVariable");
    private JMenuItem itemExemplar = new JMenuItem("addExemplar");
    private JMenuItem itemSkolen = new JMenuItem("addSkolen");
    private JMenuItem itemAnd = new JMenuItem("and");
    private JMenuItem itemOr = new JMenuItem("or");
    private JMenuItem itemNot = new JMenuItem("not");
    private JMenuItem itemEqual = new JMenuItem("equal");
    private JMenuItem itemIff = new JMenuItem("iff");
    private JMenuItem itemImplies = new JMenuItem("Implies");
    private JMenuItem itemForall = new JMenuItem("For All");
    private JMenuItem itemExists = new JMenuItem("Exists");
    private JMenuItem itemAddExemplar = new JMenuItem("addExemplar");
    private JPopupMenu popupFormula;
    private JPopupMenu popupOperando;
    private JPopupMenu popupExemplarList;
    private JPopupMenu popupExemplar;
    private JPopupMenu popupOperator;
    private FormulaTreeController formulaTreeController;

    public BuilderMenuNode(FormulaTreeController _formulaTreeController) {
        this.formulaTreeController = _formulaTreeController;
        this.addListener();
    }

    private void addListener() {
        this.itemAnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorAnd();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemOr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorOr();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemNot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorNot();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemEqual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorEqualTo();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemIff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorIf();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemImplies.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorImplies();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemForall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorForAll();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemExists.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    BuilderMenuNode.this.formulaTreeController.addOperatorExists();
                }
                catch (Exception e) {
                    BuilderMenuNode.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.itemNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BuilderMenuNode.this.formulaTreeController.setNodeChoiceActive();
            }
        });
        this.itemEntity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
            }
        });
        this.itemOVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BuilderMenuNode.this.formulaTreeController.setOVariableChoiveActive();
            }
        });
        this.itemVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BuilderMenuNode.this.formulaTreeController.setVariableChoiceActive();
            }
        });
        this.itemExemplar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BuilderMenuNode.this.formulaTreeController.setVariableChoiceActive();
            }
        });
        this.itemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DefaultMutableTreeNode parent = null;
                NodeFormulaTree nodeFormulaParent = null;
                NodeFormulaTree nodeFormula = null;
                parent = (DefaultMutableTreeNode)BuilderMenuNode.this.formulaTreeController.getFormulaTree().getNodeActive().getParent();
                if (parent != null) {
                    nodeFormulaParent = (NodeFormulaTree)parent.getUserObject();
                }
                nodeFormula = BuilderMenuNode.this.formulaTreeController.getFormulaTree().getNodeFormulaActive();
                if (parent == null) {
                    BuilderMenuNode.this.formulaTreeController.getFormulaTree().recriateTree();
                    BuilderMenuNode.this.formulaTreeController.updateFormulaText();
                    return;
                }
                if (nodeFormula.getTypeNode() == EnumType.OPERAND) {
                    nodeFormula.setSubTypeNode(EnumSubType.NOTHING);
                    nodeFormula.setName("op");
                    nodeFormula.setNodeVariable(null);
                    nodeFormula.setMnemonic("");
                    BuilderMenuNode.this.formulaTreeController.updateFormulaText();
                    BuilderMenuNode.this.formulaTreeController.getFormulaTree().updateTree();
                    return;
                }
                if (nodeFormula.getTypeNode() == EnumType.SIMPLE_OPERATOR || nodeFormula.getTypeNode() == EnumType.QUANTIFIER_OPERATOR) {
                    nodeFormula.setSubTypeNode(EnumSubType.NOTHING);
                    nodeFormula.setName("op");
                    nodeFormula.setNodeVariable(null);
                    nodeFormula.setMnemonic("");
                    nodeFormula.removeAllChildren();
                    DefaultMutableTreeNode nodeTree = BuilderMenuNode.this.formulaTreeController.getFormulaTree().getNodeActive();
                    nodeTree.removeAllChildren();
                    BuilderMenuNode.this.formulaTreeController.updateFormulaText();
                    BuilderMenuNode.this.formulaTreeController.getFormulaTree().updateTree();
                    return;
                }
                if (nodeFormula.getTypeNode() == EnumType.VARIABLE) {
                    nodeFormulaParent.removeChild(nodeFormula);
                    parent.remove(BuilderMenuNode.this.formulaTreeController.getFormulaTree().getNodeActive());
                    BuilderMenuNode.this.formulaTreeController.updateFormulaText();
                    BuilderMenuNode.this.formulaTreeController.getFormulaTree().updateTree();
                    return;
                }
            }
        });
        this.itemSkolen.setEnabled(false);
    }

    public JPopupMenu buildPopupFormula() {
        if (this.popupFormula == null) {
            this.popupFormula = new JPopupMenu();
            this.popupFormula.add(this.itemAnd);
            this.popupFormula.add(this.itemOr);
            this.popupFormula.add(this.itemNot);
            this.popupFormula.add(this.itemEqual);
            this.popupFormula.add(this.itemImplies);
            this.popupFormula.add(this.itemIff);
            this.popupFormula.add(this.itemForall);
            this.popupFormula.add(this.itemExists);
        }
        return this.popupFormula;
    }

    public JPopupMenu buildPopupOperando() {
        if (this.popupOperando == null) {
            this.popupOperando = new JPopupMenu();
            this.popupOperando.add(this.itemDelete);
            this.popupOperando.addSeparator();
            this.popupOperando.add(this.itemNode);
            this.popupOperando.add(this.itemEntity);
            this.popupOperando.add(this.itemVariable);
            this.popupOperando.addSeparator();
            this.popupOperando.add(this.itemAnd);
            this.popupOperando.add(this.itemOr);
            this.popupOperando.add(this.itemNot);
            this.popupOperando.add(this.itemEqual);
            this.popupOperando.add(this.itemImplies);
            this.popupOperando.add(this.itemIff);
            this.popupOperando.add(this.itemForall);
            this.popupOperando.add(this.itemExists);
        }
        return this.popupOperando;
    }

    public JPopupMenu buildPopupExemplarList() {
        if (this.popupExemplarList == null) {
            this.popupExemplarList = new JPopupMenu();
        }
        this.popupExemplarList.add(this.itemExemplar);
        return this.popupExemplarList;
    }

    public JPopupMenu buildPopupExemplar() {
        if (this.popupExemplar == null) {
            this.popupExemplar = new JPopupMenu();
            this.popupExemplar.add(this.itemDelete);
        }
        return this.popupExemplar;
    }

    public JPopupMenu buildPopupOperator() {
        if (this.popupOperator == null) {
            this.popupOperator = new JPopupMenu();
            this.popupOperator.add(this.itemDelete);
            this.popupOperator.addSeparator();
            this.popupOperator.add(this.itemAnd);
            this.popupOperator.add(this.itemOr);
            this.popupOperator.add(this.itemNot);
            this.popupOperator.add(this.itemEqual);
            this.popupOperator.add(this.itemImplies);
            this.popupOperator.add(this.itemIff);
            this.popupOperator.add(this.itemForall);
            this.popupOperator.add(this.itemExists);
        }
        return this.popupOperator;
    }

    public void showErrorMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, resource.getString("error"), 0);
    }
}

