/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.finding;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.controller.exception.InvalidOperationException;
import unbbayes.gui.mebn.auxiliary.FocusListenerTextField;
import unbbayes.gui.mebn.auxiliary.ListCellRenderer;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.ObjectEntityInstanceOrdereable;
import unbbayes.prs.mebn.entity.exception.EntityInstanceAlreadyExistsException;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.ReservedWordException;

public class EntityFindingEditionPane
extends JPanel {
    private MEBNController mebnController;
    private Object selected;
    private ObjectEntityInstanceOrdereable last;
    private boolean isAdding = true;
    private ObjectEntityListPane objectEntityListPane;
    private ObjectEntityInstancePane objectEntityInstancePane;
    private ObjectEntityInstanceListPane objectEntityInstanceListPane;
    private JPanel upperPanel;
    private JPanel downPanel;
    private IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public EntityFindingEditionPane() {
    }

    public EntityFindingEditionPane(MEBNController mebnController) {
        super(new BorderLayout());
        this.mebnController = mebnController;
        this.objectEntityListPane = new ObjectEntityListPane();
        this.objectEntityInstancePane = new ObjectEntityInstancePane();
        this.objectEntityInstanceListPane = new ObjectEntityInstanceListPane();
        this.upperPanel = new JPanel(new BorderLayout());
        this.upperPanel.add((Component)this.objectEntityListPane, "Center");
        this.upperPanel.add((Component)this.objectEntityInstancePane, "South");
        this.downPanel = new JPanel(new BorderLayout());
        this.downPanel.add((Component)this.objectEntityInstanceListPane, "Center");
        this.add((Component)this.upperPanel, "Center");
        this.add((Component)this.downPanel, "Last");
    }

    public void showEntityInstanceListPane(ObjectEntity entity) {
        this.downPanel.removeAll();
        this.objectEntityInstanceListPane = new ObjectEntityInstanceListPane(entity);
        this.downPanel.add((Component)this.objectEntityInstanceListPane, "Center");
        this.downPanel.validate();
    }

    public GridBagConstraints getConstraints(int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int fill, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.fill = fill;
        constraints.anchor = anchor;
        return constraints;
    }

    private class ObjectEntityInstanceListPane
    extends JPanel {
        private JList jlistEntity;
        private JScrollPane scrollListObjectEntity;
        private ObjectEntity objectEntity;
        private DefaultListModel listModel;

        public ObjectEntityInstanceListPane() {
            super(new GridLayout(1, 1));
            this.listModel = new DefaultListModel();
            this.jlistEntity = new JList();
            this.jlistEntity.setModel(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistEntity);
            this.add(this.scrollListObjectEntity);
        }

        public ObjectEntityInstanceListPane(ObjectEntity objectEntity) {
            super(new GridLayout(1, 1));
            this.objectEntity = objectEntity;
            this.listModel = new DefaultListModel();
            this.jlistEntity = new JList();
            if (objectEntity.isOrdereable()) {
                ArrayList<ObjectEntityInstanceOrdereable> originalList = new ArrayList<ObjectEntityInstanceOrdereable>();
                for (ObjectEntityInstance objectEntityInstance : objectEntity.getInstanceList()) {
                    originalList.add((ObjectEntityInstanceOrdereable)objectEntityInstance);
                }
                for (ObjectEntityInstanceOrdereable objectEntityInstanceOrdereable : ObjectEntityInstanceOrdereable.ordererList(originalList)) {
                    this.listModel.addElement(objectEntityInstanceOrdereable);
                }
                if (this.listModel.size() > 0) {
                    EntityFindingEditionPane.this.last = (ObjectEntityInstanceOrdereable)this.listModel.get(this.listModel.size() - 1);
                } else {
                    EntityFindingEditionPane.this.last = null;
                }
            } else {
                for (ObjectEntityInstance instance : objectEntity.getInstanceList()) {
                    this.listModel.addElement(instance);
                }
                EntityFindingEditionPane.this.last = null;
            }
            this.jlistEntity.setModel(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistEntity);
            this.add(this.scrollListObjectEntity);
            this.jlistEntity.setCellRenderer(new ListCellRenderer(EntityFindingEditionPane.this.iconController.getEntityInstanceIcon()));
            this.jlistEntity.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    EntityFindingEditionPane.this.selected = ObjectEntityInstanceListPane.this.jlistEntity.getSelectedValue();
                    EntityFindingEditionPane.this.isAdding = false;
                    if (EntityFindingEditionPane.this.selected != null) {
                        EntityFindingEditionPane.this.objectEntityInstancePane.updateReference();
                    }
                }
            });
        }

        public void update() {
            this.listModel.clear();
            this.listModel = new DefaultListModel();
            if (this.objectEntity.isOrdereable()) {
                ArrayList<ObjectEntityInstanceOrdereable> originalList = new ArrayList<ObjectEntityInstanceOrdereable>();
                for (ObjectEntityInstance objectEntityInstance : this.objectEntity.getInstanceList()) {
                    originalList.add((ObjectEntityInstanceOrdereable)objectEntityInstance);
                }
                for (ObjectEntityInstanceOrdereable objectEntityInstanceOrdereable : ObjectEntityInstanceOrdereable.ordererList(originalList)) {
                    this.listModel.addElement(objectEntityInstanceOrdereable);
                }
                if (this.listModel.size() > 0) {
                    EntityFindingEditionPane.this.last = (ObjectEntityInstanceOrdereable)this.listModel.get(this.listModel.size() - 1);
                } else {
                    EntityFindingEditionPane.this.last = null;
                }
            } else {
                for (ObjectEntityInstance instance : this.objectEntity.getInstanceList()) {
                    this.listModel.addElement(instance);
                }
                EntityFindingEditionPane.this.last = null;
            }
            this.jlistEntity.setModel(this.listModel);
        }
    }

    private class ObjectEntityInstancePane
    extends JPanel {
        private JTextField typeObjectEntity;
        private JTextField nameObjectEntity;
        private JButton btnAddInstance;
        private JButton btnRemoveInstance;
        private JButton btnUpInstance;
        private JButton btnDownInstance;
        private JToolBar barButtons;
        private final JLabel labelType = new JLabel(EntityFindingEditionPane.access$0().getString("typeLabel"));
        private final JLabel labelName = new JLabel(EntityFindingEditionPane.access$0().getString("nameLabel"));
        private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
        private Matcher matcher;

        public ObjectEntityInstancePane() {
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            this.typeObjectEntity = new JTextField(10);
            this.typeObjectEntity.setEditable(false);
            this.nameObjectEntity = new JTextField(10);
            this.nameObjectEntity.addFocusListener(new FocusListenerTextField());
            this.nameObjectEntity.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && ObjectEntityInstancePane.this.nameObjectEntity.getText().length() > 0) {
                        try {
                            String nameValue = ObjectEntityInstancePane.this.nameObjectEntity.getText(0, ObjectEntityInstancePane.this.nameObjectEntity.getText().length());
                            ObjectEntityInstancePane.this.matcher = ObjectEntityInstancePane.this.wordPattern.matcher(nameValue);
                            if (ObjectEntityInstancePane.this.matcher.matches()) {
                                ObjectEntityInstancePane.this.addOrEditInstance();
                            } else {
                                ObjectEntityInstancePane.this.nameObjectEntity.setBackground(MebnToolkit.getColorTextFieldError());
                                ObjectEntityInstancePane.this.nameObjectEntity.setForeground(Color.WHITE);
                                JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("nameError"), resource.getString("nameException"), 0);
                                ObjectEntityInstancePane.this.nameObjectEntity.selectAll();
                            }
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        String name = ObjectEntityInstancePane.this.nameObjectEntity.getText(0, ObjectEntityInstancePane.this.nameObjectEntity.getText().length());
                        ObjectEntityInstancePane.this.matcher = ObjectEntityInstancePane.this.wordPattern.matcher(name);
                        if (!ObjectEntityInstancePane.this.matcher.matches()) {
                            ObjectEntityInstancePane.this.nameObjectEntity.setBackground(MebnToolkit.getColorTextFieldError());
                            ObjectEntityInstancePane.this.nameObjectEntity.setForeground(Color.WHITE);
                        } else {
                            ObjectEntityInstancePane.this.nameObjectEntity.setBackground(MebnToolkit.getColorTextFieldSelected());
                            ObjectEntityInstancePane.this.nameObjectEntity.setForeground(Color.BLACK);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.btnAddInstance = new JButton(EntityFindingEditionPane.this.iconController.getMoreIcon());
            this.btnAddInstance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectEntityInstancePane.this.addOrEditInstance();
                }
            });
            this.btnRemoveInstance = new JButton(EntityFindingEditionPane.this.iconController.getLessIcon());
            this.btnRemoveInstance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectEntityInstancePane.this.removeInstance();
                }
            });
            this.btnUpInstance = new JButton(EntityFindingEditionPane.this.iconController.getUpIcon());
            this.btnUpInstance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectEntityInstancePane.this.upInstance();
                }
            });
            this.btnDownInstance = new JButton(EntityFindingEditionPane.this.iconController.getDownIcon());
            this.btnDownInstance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectEntityInstancePane.this.downInstance();
                }
            });
            this.barButtons = new JToolBar();
            this.barButtons.setLayout(new GridLayout(1, 4));
            this.barButtons.add(this.btnAddInstance);
            this.barButtons.add(this.btnRemoveInstance);
            this.barButtons.add(this.btnUpInstance);
            this.barButtons.add(this.btnDownInstance);
            this.barButtons.setFloatable(false);
            gridbag.setConstraints(this.labelType, EntityFindingEditionPane.this.getConstraints(0, 0, 1, 1, 40, 35, 1, 10));
            this.add(this.labelType);
            gridbag.setConstraints(this.typeObjectEntity, EntityFindingEditionPane.this.getConstraints(1, 0, 1, 1, 60, 0, 1, 10));
            this.add(this.typeObjectEntity);
            gridbag.setConstraints(this.labelName, EntityFindingEditionPane.this.getConstraints(0, 1, 1, 1, 0, 35, 1, 10));
            this.add(this.labelName);
            gridbag.setConstraints(this.nameObjectEntity, EntityFindingEditionPane.this.getConstraints(1, 1, 1, 1, 0, 0, 1, 10));
            this.add(this.nameObjectEntity);
            gridbag.setConstraints(this.barButtons, EntityFindingEditionPane.this.getConstraints(0, 2, 2, 1, 0, 30, 1, 10));
            this.add(this.barButtons);
        }

        private void addOrEditInstance() {
            if (!this.validName(this.nameObjectEntity.getText())) {
                JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("nameException"), resource.getString("error"), 0);
                return;
            }
            if (this.nameObjectEntity.getText() == null || this.nameObjectEntity.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("nameEmpty"), resource.getString("error"), 0);
                return;
            }
            if (EntityFindingEditionPane.this.selected != null) {
                if (EntityFindingEditionPane.this.isAdding) {
                    try {
                        ObjectEntity objectEntity = (ObjectEntity)EntityFindingEditionPane.this.selected;
                        if (!objectEntity.isOrdereable()) {
                            try {
                                try {
                                    EntityFindingEditionPane.this.mebnController.createEntityIntance(objectEntity, this.nameObjectEntity.getText());
                                }
                                catch (DuplicatedNameException e) {
                                    JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                }
                                catch (ReservedWordException e2) {
                                    JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                                }
                            }
                            catch (InvalidOperationException e) {
                                e.printStackTrace();
                            }
                        } else {
                            try {
                                try {
                                    EntityFindingEditionPane.this.mebnController.createEntityIntanceOrdereable(objectEntity, this.nameObjectEntity.getText(), EntityFindingEditionPane.this.last);
                                }
                                catch (DuplicatedNameException e) {
                                    JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                }
                                catch (ReservedWordException e2) {
                                    JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                                }
                            }
                            catch (InvalidOperationException e) {
                                e.printStackTrace();
                            }
                        }
                        EntityFindingEditionPane.this.objectEntityInstanceListPane.update();
                        this.nameObjectEntity.setText("");
                    }
                    catch (EntityInstanceAlreadyExistsException ex) {
                        JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                    }
                } else {
                    try {
                        try {
                            EntityFindingEditionPane.this.mebnController.renameEntityIntance((ObjectEntityInstance)EntityFindingEditionPane.this.selected, this.nameObjectEntity.getText());
                            EntityFindingEditionPane.this.objectEntityInstanceListPane.update();
                        }
                        catch (DuplicatedNameException e) {
                            JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getScreen(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                        }
                        catch (ReservedWordException e2) {
                            JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                        }
                    }
                    catch (EntityInstanceAlreadyExistsException ex) {
                        JOptionPane.showMessageDialog(EntityFindingEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                    }
                }
            }
        }

        private void removeInstance() {
            if (EntityFindingEditionPane.this.selected != null && !EntityFindingEditionPane.this.isAdding) {
                if (EntityFindingEditionPane.this.selected instanceof ObjectEntityInstanceOrdereable) {
                    EntityFindingEditionPane.this.mebnController.removeEntityInstanceOrdereable((ObjectEntityInstanceOrdereable)EntityFindingEditionPane.this.selected);
                } else {
                    EntityFindingEditionPane.this.mebnController.removeEntityInstance((ObjectEntityInstance)EntityFindingEditionPane.this.selected);
                }
                EntityFindingEditionPane.this.objectEntityInstanceListPane.update();
            }
        }

        private void upInstance() {
            if (EntityFindingEditionPane.this.selected != null && !EntityFindingEditionPane.this.isAdding) {
                EntityFindingEditionPane.this.mebnController.upEntityInstance((ObjectEntityInstanceOrdereable)EntityFindingEditionPane.this.selected);
                EntityFindingEditionPane.this.objectEntityInstanceListPane.update();
            }
        }

        private void downInstance() {
            if (EntityFindingEditionPane.this.selected != null && !EntityFindingEditionPane.this.isAdding) {
                EntityFindingEditionPane.this.mebnController.downEntityInstance((ObjectEntityInstanceOrdereable)EntityFindingEditionPane.this.selected);
                EntityFindingEditionPane.this.objectEntityInstanceListPane.update();
            }
        }

        public void disableUpDownButtons() {
            this.btnUpInstance.setEnabled(false);
            this.btnDownInstance.setEnabled(false);
        }

        public void enableUpDownButtons() {
            this.btnUpInstance.setEnabled(true);
            this.btnDownInstance.setEnabled(true);
        }

        public void updateReference() {
            if (EntityFindingEditionPane.this.selected != null) {
                if (EntityFindingEditionPane.this.isAdding) {
                    this.typeObjectEntity.setText(((ObjectEntity)EntityFindingEditionPane.this.selected).getName());
                    this.nameObjectEntity.setText("");
                    this.btnRemoveInstance.setEnabled(false);
                } else {
                    this.typeObjectEntity.setText(((ObjectEntityInstance)EntityFindingEditionPane.this.selected).getInstanceOf().getName());
                    this.nameObjectEntity.setText(((ObjectEntityInstance)EntityFindingEditionPane.this.selected).getName());
                    this.btnRemoveInstance.setEnabled(true);
                }
            }
        }

        public boolean validName(String name) {
            this.matcher = this.wordPattern.matcher(name);
            return this.matcher.matches();
        }
    }

    private class ObjectEntityListPane
    extends JPanel {
        private JList jlistEntity;
        private JScrollPane scrollListObjectEntity;
        private List<ObjectEntity> listEntity;
        private DefaultListModel listModel;

        public ObjectEntityListPane() {
            super(new GridLayout(1, 1));
            this.listEntity = EntityFindingEditionPane.this.mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getListEntity();
            this.listModel = new DefaultListModel();
            for (Entity entity : this.listEntity) {
                this.listModel.addElement(entity);
            }
            this.jlistEntity = new JList();
            this.jlistEntity.setModel(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistEntity);
            this.add(this.scrollListObjectEntity);
            this.jlistEntity.setCellRenderer(new ListCellRenderer(EntityFindingEditionPane.this.iconController.getObjectEntityIcon()));
            this.jlistEntity.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    EntityFindingEditionPane.this.selected = (ObjectEntity)ObjectEntityListPane.this.jlistEntity.getSelectedValue();
                    EntityFindingEditionPane.this.isAdding = true;
                    if (EntityFindingEditionPane.this.selected != null) {
                        EntityFindingEditionPane.this.objectEntityInstancePane.updateReference();
                        EntityFindingEditionPane.this.showEntityInstanceListPane((ObjectEntity)EntityFindingEditionPane.this.selected);
                        if (!((ObjectEntity)EntityFindingEditionPane.this.selected).isOrdereable()) {
                            EntityFindingEditionPane.this.objectEntityInstancePane.disableUpDownButtons();
                        } else {
                            EntityFindingEditionPane.this.objectEntityInstancePane.enableUpDownButtons();
                        }
                    }
                }
            });
        }
    }
}

