/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.cpt;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import unbbayes.gui.mebn.cpt.CPTEditionPane;
import unbbayes.gui.mebn.cpt.ColloringUtils;
import unbbayes.gui.mebn.cpt.StyleTable;
import unbbayes.gui.mebn.cpt.StyleTableImpl;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.util.ResourceController;

public class CPTTextPane
extends JTextPane {
    private final CPTEditionPane cptEditionPane_;
    private final StyleTable styleTable;
    private ColloringUtils colloringUtils;
    private StyledDocument doc;
    private int positionCaret = 0;
    private JPopupMenu popupOptions;
    private static ResourceBundle resource = ResourceController.RS_GUI;

    CPTTextPane(CPTEditionPane cptEditionPane) {
        this.cptEditionPane_ = cptEditionPane;
        this.styleTable = new StyleTableImpl(this.getStyledDocument());
        this.doc = this.getStyledDocument();
        this.setCaretPosition(0);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                CPTTextPane.this.positionCaret = e.getDot();
                CPTTextPane.this.cptEditionPane_.atualizeCaretPosition(CPTTextPane.this.positionCaret);
            }
        });
        this.setMinimumSize(new Dimension(100, 100));
        this.setMaximumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(100, 100));
        this.colloringUtils = new ColloringUtils(cptEditionPane.getResidentNode(), this.styleTable);
        if (cptEditionPane.getResidentNode().getTableFunction() != null) {
            this.colloringUtils.turnTextColor(cptEditionPane.getResidentNode().getTableFunction(), 0, this.doc);
        }
        this.popupOptions = this.createPopupMenu();
        this.addKeyListener(new TextPaneKeyListener());
        this.addMouseListener(new TextPaneMouseListener());
    }

    private JPopupMenu createPopupMenu() {
        JMenuItem itemIfAnyClause = new JMenuItem(resource.getString("ifAny"));
        JMenuItem itemIfAllClause = new JMenuItem(resource.getString("ifAll"));
        JMenuItem itemElseClause = new JMenuItem(resource.getString("else"));
        JMenuItem itemEraseAll = new JMenuItem(resource.getString("clear"));
        JMenuItem itemDefaultClause = new JMenuItem(resource.getString("default"));
        JMenuItem itemEqual = new JMenuItem(resource.getString("equal"));
        JMenuItem itemAnd = new JMenuItem(resource.getString("and"));
        JMenuItem itemOr = new JMenuItem(resource.getString("or"));
        JMenuItem itemNot = new JMenuItem(resource.getString("not"));
        JMenuItem itemCardinality = new JMenuItem(resource.getString("card"));
        JMenuItem itemMax = new JMenuItem(resource.getString("max"));
        JMenuItem itemMin = new JMenuItem(resource.getString("min"));
        itemIfAnyClause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertIfClause(0);
            }
        });
        itemIfAllClause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertIfClause(1);
            }
        });
        itemElseClause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertElseClause();
            }
        });
        itemEqual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertEqualOperator();
            }
        });
        itemAnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertAndOperator();
            }
        });
        itemOr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertOrOperator();
            }
        });
        itemNot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertNotOperator();
            }
        });
        itemCardinality.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertCardinalityClause();
            }
        });
        itemMax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertMaxClause();
            }
        });
        itemMin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertMinClause();
            }
        });
        itemEraseAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.clearTable();
            }
        });
        itemDefaultClause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CPTTextPane.this.insertDefaultClause();
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(itemIfAnyClause);
        popup.add(itemIfAllClause);
        popup.add(itemElseClause);
        popup.add(itemDefaultClause);
        popup.addSeparator();
        popup.add(itemEqual);
        popup.add(itemAnd);
        popup.add(itemOr);
        popup.add(itemNot);
        popup.addSeparator();
        popup.add(itemMax);
        popup.add(itemMin);
        popup.add(itemCardinality);
        popup.addSeparator();
        popup.add(itemEraseAll);
        return popup;
    }

    public void insertIfClause(int choice) {
        Position pos = this.doc.getEndPosition();
        int start = pos.getOffset();
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, "if", this.styleTable.getIfStyle());
            this.doc.insertString(this.positionCaret, " ", this.styleTable.getDefaultStyle());
            if (choice == 0) {
                this.doc.insertString(this.positionCaret, "any", this.styleTable.getAnyStyle());
                this.doc.insertString(this.positionCaret, " ", this.styleTable.getDefaultStyle());
                this.doc.insertString(this.positionCaret, "paramSubSet", this.styleTable.getDescriptionStyle());
                this.doc.insertString(this.positionCaret, " ", this.styleTable.getDefaultStyle());
            } else {
                this.doc.insertString(this.positionCaret, "all", this.styleTable.getAnyStyle());
                this.doc.insertString(this.positionCaret, " ", this.styleTable.getDefaultStyle());
                this.doc.insertString(this.positionCaret, "paramSet", this.styleTable.getDescriptionStyle());
                this.doc.insertString(this.positionCaret, " ", this.styleTable.getDefaultStyle());
            }
            this.doc.insertString(this.positionCaret, "have", this.styleTable.getAnyStyle());
            this.doc.insertString(this.positionCaret, " ( ", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, "booleanFunction", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, " ) ", this.styleTable.getDefaultStyle());
            this.insertStatesDistribution();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    private void insertStatesDistribution() throws BadLocationException {
        this.doc.insertString(this.positionCaret, "[\n", this.styleTable.getDefaultStyle());
        List<Entity> statesList = this.cptEditionPane_.getResidentNode().getPossibleValueList();
        int sizeStatesList = statesList.size();
        for (Entity entity : statesList) {
            this.doc.insertString(this.positionCaret, "   " + entity.getName() + " = ", this.styleTable.getStateNodeStyle());
            this.doc.insertString(this.positionCaret, "formula", this.styleTable.getDescriptionStyle());
            if (--sizeStatesList != 0) {
                this.doc.insertString(this.positionCaret, ",", this.styleTable.getDefaultStyle());
            }
            this.doc.insertString(this.positionCaret, "\n", this.styleTable.getDefaultStyle());
        }
        this.doc.insertString(this.positionCaret, "]\n", this.styleTable.getDefaultStyle());
    }

    public void insertDefaultClause() {
        try {
            this.insertStatesDistribution();
        }
        catch (BadLocationException e) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void clearTable() {
        int end = this.doc.getLength();
        try {
            this.doc.remove(0, end);
            this.positionCaret = 0;
        }
        catch (BadLocationException e) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertElseClause() {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, "else ", this.styleTable.getIfStyle());
            this.insertStatesDistribution();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertAndOperator() {
        try {
            this.replaceSelection("");
            this.insertEqualOperator();
            this.doc.insertString(this.positionCaret, " & ", this.styleTable.getBooleanStyle());
            this.insertEqualOperator();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertOrOperator() {
        try {
            this.replaceSelection("");
            this.insertEqualOperator();
            this.doc.insertString(this.positionCaret, " | ", this.styleTable.getBooleanStyle());
            this.insertEqualOperator();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertNotOperator() {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, " ~ ", this.styleTable.getBooleanStyle());
            this.doc.insertString(this.positionCaret, "Node", this.styleTable.getDescriptionStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertEqualOperator() {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, "Node", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, " = ", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, "NodeState", this.styleTable.getDescriptionStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertCardinalityClause() {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, "cardinality", this.styleTable.getFunctionStyle());
            this.doc.insertString(this.positionCaret, "(", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, " op ", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, ")", this.styleTable.getDefaultStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertParamSet(String param) {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, param, this.styleTable.getArgumentStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertState(String state) {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, state, this.styleTable.getStateNodeStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertStateFather(String state) {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, state, this.styleTable.getStateFatherStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertNode(String param) {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, param, this.styleTable.getFatherStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertMaxClause() {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, "max", this.styleTable.getFunctionStyle());
            this.doc.insertString(this.positionCaret, "(", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, " op1 ", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, ",", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, " op2 ", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, ")", this.styleTable.getDefaultStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public void insertMinClause() {
        try {
            this.replaceSelection("");
            this.doc.insertString(this.positionCaret, "min", this.styleTable.getFunctionStyle());
            this.doc.insertString(this.positionCaret, "(", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, " op1 ", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, ",", this.styleTable.getDefaultStyle());
            this.doc.insertString(this.positionCaret, " op2 ", this.styleTable.getDescriptionStyle());
            this.doc.insertString(this.positionCaret, ")", this.styleTable.getDefaultStyle());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    public String getTableTxt() {
        String text;
        try {
            text = this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            text = null;
        }
        return text;
    }

    public void setCursorPosition(int position) {
        this.setCaretPosition(position);
    }

    private class TextPaneKeyListener
    implements KeyListener {
        private TextPaneKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            try {
                CPTTextPane.this.doc.insertString(CPTTextPane.this.positionCaret, "", CPTTextPane.this.styleTable.getDefaultStyle());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                try {
                    String txtTable = CPTTextPane.this.doc.getText(0, CPTTextPane.this.doc.getLength());
                    int endPosition = CPTTextPane.this.positionCaret;
                    int i = endPosition - 1;
                    while (txtTable.charAt(i) != ' ' && i > 0) {
                        --i;
                    }
                    String text = CPTTextPane.this.doc.getText(i, endPosition - i);
                    CPTTextPane.this.doc.remove(i, endPosition - i);
                    CPTTextPane.this.colloringUtils.turnTextColor(text, i, CPTTextPane.this.doc);
                    if (endPosition != txtTable.length()) {
                        i = endPosition;
                        while (i < txtTable.length() && txtTable.charAt(i) != ' ') {
                            ++i;
                        }
                        if (i == txtTable.length()) {
                            --i;
                        }
                        text = CPTTextPane.this.doc.getText(endPosition, i - endPosition);
                        CPTTextPane.this.doc.remove(endPosition, i - endPosition);
                        CPTTextPane.this.colloringUtils.turnTextColor(text, endPosition, CPTTextPane.this.doc);
                    }
                    CPTTextPane.this.positionCaret = endPosition;
                    CPTTextPane.this.setCaretPosition(CPTTextPane.this.positionCaret);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (e.getKeyCode() == 127 || e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                try {
                    int endPosition;
                    String txtTable = CPTTextPane.this.doc.getText(0, CPTTextPane.this.doc.getLength());
                    int i = endPosition = CPTTextPane.this.positionCaret;
                    while (txtTable.charAt(i) != ' ' && i > 0) {
                        --i;
                    }
                    int j = endPosition;
                    while (j < txtTable.length() && txtTable.charAt(j) != ' ') {
                        ++j;
                    }
                    if (j == txtTable.length()) {
                        --j;
                    }
                    String text = CPTTextPane.this.doc.getText(i, j - i);
                    CPTTextPane.this.doc.remove(i, j - i);
                    CPTTextPane.this.colloringUtils.turnTextColor(text, i, CPTTextPane.this.doc);
                    CPTTextPane.this.positionCaret = endPosition;
                    CPTTextPane.this.setCaretPosition(CPTTextPane.this.positionCaret);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class TextPaneMouseListener
    extends MouseAdapter {
        private TextPaneMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() == 4) {
                CPTTextPane.this.popupOptions.setEnabled(true);
                CPTTextPane.this.popupOptions.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

