/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.cpt;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.gui.mebn.cpt.CPTTextPane;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.compiler.Compiler;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.util.ResourceController;

public class CPTEditionPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MEBNController mebnController;
    private ResidentNode residentNode;
    private CPTTextPane cptTextPane;
    private JpFather jpFather;
    private JpArguments jpArguments;
    private JpStates jpStates;
    private JPanel jpButtonsEdition;
    private JpTurnOptionsPane jpOptionsPane;
    private JTextField txtPosition;
    private JFrame fatherDialog;
    private static ResourceBundle resource = ResourceController.RS_GUI;

    public CPTEditionPane(MEBNController mebnController, ResidentNode residentNode) {
        this.mebnController = mebnController;
        this.residentNode = residentNode;
        this.fatherDialog = (JFrame)this.getParent();
        this.cptTextPane = new CPTTextPane(this);
        this.jpFather = new JpFather();
        this.jpArguments = new JpArguments();
        this.jpStates = new JpStates();
        this.jpButtonsEdition = new JpButtons();
        this.jpOptionsPane = new JpTurnOptionsPane();
        this.setLayout(new BorderLayout());
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.add((Component)this.jpButtonsEdition, "North");
        JScrollPane jspCptTextPane = new JScrollPane(this.cptTextPane);
        centerPane.add((Component)jspCptTextPane, "Center");
        centerPane.add((Component)new JpMainButtons(), "South");
        this.add((Component)centerPane, "Center");
        this.add((Component)this.jpOptionsPane, "West");
        this.setMinimumSize(new Dimension(750, 300));
        this.setPreferredSize(new Dimension(750, 300));
    }

    public ResidentNode getResidentNode() {
        return this.residentNode;
    }

    protected void atualizeCaretPosition(int caretPosition) {
        if (this.txtPosition != null) {
            this.txtPosition.setText(String.valueOf(resource.getString("position")) + ": " + caretPosition);
        }
    }

    private class JpArguments
    extends JPanel {
        private String[] oVariableArray;

        JpArguments() {
            this.setLayout(new BorderLayout());
            this.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("ArgumentTitle")));
            List<OrdinaryVariable> oVariableList = CPTEditionPane.this.residentNode.getOrdinaryVariableList();
            this.oVariableArray = new String[oVariableList.size()];
            int i = 0;
            for (OrdinaryVariable ov : oVariableList) {
                this.oVariableArray[i] = ov.getName();
                ++i;
            }
            final JList<String> jlOVariable = new JList<String>(this.oVariableArray);
            JScrollPane jscJlOVariable = new JScrollPane(jlOVariable);
            this.add((Component)jscJlOVariable, "Center");
            jlOVariable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        int selectedIndex = jlOVariable.getSelectedIndex();
                        CPTEditionPane.this.cptTextPane.insertParamSet(JpArguments.this.oVariableArray[selectedIndex]);
                    }
                }
            });
        }
    }

    private class JpButtons
    extends JPanel {
        private JButton btnIfAnyClause;
        private JButton btnIfAllClause;
        private JButton btnElseClause;
        private JButton btnEraseAll;
        private JButton btnDefaultClause;
        private JButton btnEqual;
        private JButton btnAnd;
        private JButton btnOr;
        private JButton btnNot;
        private JButton btnCardinality;
        private JButton btnMax;
        private JButton btnMin;

        JpButtons() {
            Font font = new Font("Serif", 1, 10);
            this.btnEraseAll = new JButton(resource.getString("clear"));
            this.btnEraseAll.setFont(font);
            this.btnEraseAll.setToolTipText(resource.getString("deleteTip"));
            this.btnIfAnyClause = new JButton(resource.getString("ifAny"));
            this.btnIfAnyClause.setFont(font);
            this.btnIfAnyClause.setToolTipText(resource.getString("anyTip"));
            this.btnIfAllClause = new JButton(resource.getString("ifAll"));
            this.btnIfAllClause.setFont(font);
            this.btnIfAllClause.setToolTipText(resource.getString("allTip"));
            this.btnElseClause = new JButton(resource.getString("else"));
            this.btnElseClause.setFont(font);
            this.btnElseClause.setToolTipText(resource.getString("elseTip"));
            this.btnDefaultClause = new JButton(resource.getString("default"));
            this.btnDefaultClause.setFont(font);
            this.btnDefaultClause.setToolTipText(resource.getString("defaultTip"));
            this.btnEqual = new JButton(resource.getString("equal"));
            this.btnEqual.setFont(font);
            this.btnEqual.setToolTipText(resource.getString("equalTip"));
            this.btnAnd = new JButton(resource.getString("and"));
            this.btnAnd.setFont(font);
            this.btnAnd.setToolTipText(resource.getString("andTip"));
            this.btnOr = new JButton(resource.getString("or"));
            this.btnOr.setFont(font);
            this.btnOr.setToolTipText(resource.getString("orTip"));
            this.btnNot = new JButton(resource.getString("not"));
            this.btnNot.setFont(font);
            this.btnNot.setToolTipText(resource.getString("notTip"));
            this.btnCardinality = new JButton(resource.getString("card"));
            this.btnCardinality.setFont(font);
            this.btnCardinality.setToolTipText(resource.getString("cadinalityTip"));
            this.btnMax = new JButton(resource.getString("max"));
            this.btnMax.setFont(font);
            this.btnMax.setToolTipText(resource.getString("maxTip"));
            this.btnMin = new JButton(resource.getString("min"));
            this.btnMin.setFont(font);
            this.btnMin.setToolTipText(resource.getString("minTip"));
            this.setLayout(new GridLayout(2, 6));
            this.add(this.btnIfAnyClause);
            this.add(this.btnIfAllClause);
            this.add(this.btnElseClause);
            this.add(this.btnDefaultClause);
            this.add(this.btnEqual);
            this.add(this.btnEraseAll);
            this.add(this.btnAnd);
            this.add(this.btnOr);
            this.add(this.btnNot);
            this.add(this.btnMax);
            this.add(this.btnMin);
            this.add(this.btnCardinality);
            this.addButtonsListeners();
        }

        private void addButtonsListeners() {
            this.btnIfAnyClause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertIfClause(0);
                }
            });
            this.btnIfAllClause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertIfClause(1);
                }
            });
            this.btnElseClause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertElseClause();
                }
            });
            this.btnEqual.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertEqualOperator();
                }
            });
            this.btnAnd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertAndOperator();
                }
            });
            this.btnOr.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertOrOperator();
                }
            });
            this.btnNot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertNotOperator();
                }
            });
            this.btnCardinality.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertCardinalityClause();
                }
            });
            this.btnMax.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertMaxClause();
                }
            });
            this.btnMin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertMinClause();
                }
            });
            this.btnEraseAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.clearTable();
                }
            });
            this.btnDefaultClause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.cptTextPane.insertDefaultClause();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JpFather
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private List<InputNode> inputNodeList;
        private final List<ResidentNode> residentNodeAuxList;
        private JList jlStates;
        private JList jlArguments;
        private DefaultListModel listStatesModel;
        private DefaultListModel listArgumentsModel;
        private String[] fatherNodeArray;
        private List<MultiEntityNode> fatherNodeList;

        JpFather() {
            this.setMinimumSize(new Dimension(100, 100));
            this.residentNodeAuxList = new ArrayList<ResidentNode>();
            this.fatherNodeList = new ArrayList<MultiEntityNode>();
            this.residentNodeAuxList.add(CPTEditionPane.this.residentNode);
            this.fatherNodeList.add(CPTEditionPane.this.residentNode);
            this.inputNodeList = CPTEditionPane.this.residentNode.getInputNodeFatherList();
            for (InputNode inputNode : this.inputNodeList) {
                Iterator<ResidentNode> father = inputNode.getInputInstanceOf();
                if (!(father instanceof ResidentNode)) continue;
                this.residentNodeAuxList.add((ResidentNode)((Object)father));
                this.fatherNodeList.add(inputNode);
            }
            for (ResidentNode resident : CPTEditionPane.this.residentNode.getResidentNodeFatherList()) {
                this.residentNodeAuxList.add(resident);
                this.fatherNodeList.add(resident);
            }
            this.fatherNodeArray = new String[this.residentNodeAuxList.size()];
            int i = 0;
            for (ResidentNode node : this.residentNodeAuxList) {
                this.fatherNodeArray[i] = node.getName();
                ++i;
            }
            final JList<String> jlFathers = new JList<String>(this.fatherNodeArray);
            JScrollPane jscJlOFathers = new JScrollPane(jlFathers);
            jlFathers.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        int selectedIndex = jlFathers.getSelectedIndex();
                        CPTEditionPane.this.cptTextPane.insertNode(JpFather.this.fatherNodeArray[selectedIndex]);
                    } else if (e.getModifiers() == 16 && e.getClickCount() == 1) {
                        JpFather.this.jlArguments.setEnabled(true);
                        int selectedIndex = jlFathers.getSelectedIndex();
                        ResidentNode residentNode = (ResidentNode)JpFather.this.residentNodeAuxList.get(selectedIndex);
                        JpFather.this.updateStatesList(residentNode);
                        MultiEntityNode node = (MultiEntityNode)JpFather.this.fatherNodeList.get(selectedIndex);
                        if (node instanceof InputNode) {
                            Vector<OrdinaryVariable> listOrdinaryVariable = ((InputNode)node).getOrdinaryVariableList();
                            JpFather.this.updateArgumentsList(listOrdinaryVariable);
                        } else {
                            List<OrdinaryVariable> listOrdinaryVariable = ((ResidentNode)node).getOrdinaryVariableList();
                            JpFather.this.updateArgumentsList(listOrdinaryVariable);
                            if (node == residentNode) {
                                JpFather.this.jlArguments.setEnabled(false);
                            }
                        }
                    }
                }
            });
            this.listStatesModel = new DefaultListModel();
            this.jlStates = new JList(this.listStatesModel);
            JScrollPane jspStates = new JScrollPane(this.jlStates);
            this.jlStates.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        String selectedIndex = (String)JpFather.this.jlStates.getSelectedValue();
                        CPTEditionPane.this.cptTextPane.insertStateFather(selectedIndex);
                    }
                }
            });
            this.listArgumentsModel = new DefaultListModel();
            this.jlArguments = new JList(this.listArgumentsModel);
            JScrollPane jspArguments = new JScrollPane(this.jlArguments);
            this.jlArguments.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        String selectedIndex = (String)JpFather.this.jlArguments.getSelectedValue();
                        CPTEditionPane.this.cptTextPane.insertParamSet(selectedIndex);
                    }
                }
            });
            this.setLayout(new GridLayout(2, 0));
            jscJlOFathers.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("NodesTitle")));
            jspStates.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("StatesTitle")));
            jspArguments.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("ArgumentTitle")));
            this.add(jscJlOFathers);
            JPanel jpBottom = new JPanel(new GridLayout(0, 2));
            jpBottom.add(jspStates);
            jpBottom.add(jspArguments);
            this.add(jpBottom);
        }

        private void updateStatesList(ResidentNode resident) {
            List<Entity> listStates = resident.getPossibleValueList();
            this.listStatesModel.removeAllElements();
            this.listStatesModel = new DefaultListModel();
            for (Entity entity : listStates) {
                this.listStatesModel.addElement(entity.getName());
            }
            this.jlStates.setModel(this.listStatesModel);
        }

        private void updateArgumentsList(List<OrdinaryVariable> ovList) {
            this.listArgumentsModel.removeAllElements();
            this.listArgumentsModel = new DefaultListModel();
            for (OrdinaryVariable entity : ovList) {
                this.listArgumentsModel.addElement(entity.getName());
            }
            this.jlArguments.setModel(this.listArgumentsModel);
        }
    }

    private class JpMainButtons
    extends JPanel {
        private JButton btnCompile;
        private JButton btnExit;
        private JButton btnSave;

        JpMainButtons() {
            Font font = new Font("Serif", 0, 12);
            this.btnCompile = new JButton(resource.getString("compileCPT"));
            this.btnCompile.setFont(font);
            this.btnCompile.setToolTipText(resource.getString("compileCPTTip"));
            this.btnSave = new JButton(resource.getString("saveCPT"));
            this.btnSave.setFont(font);
            this.btnSave.setToolTipText(resource.getString("saveCPTTip"));
            this.btnExit = new JButton(resource.getString("exitCPT"));
            this.btnExit.setFont(font);
            this.btnExit.setToolTipText(resource.getString("exitCPTTip"));
            CPTEditionPane.this.txtPosition = new JTextField();
            CPTEditionPane.this.txtPosition.setEditable(false);
            CPTEditionPane.this.txtPosition.setForeground(Color.black);
            CPTEditionPane.this.txtPosition.setBackground(Color.WHITE);
            CPTEditionPane.this.txtPosition.setAlignmentX(0.5f);
            this.setLayout(new GridLayout(0, 4));
            this.add(CPTEditionPane.this.txtPosition);
            this.add(this.btnSave);
            this.add(this.btnCompile);
            this.add(this.btnExit);
            this.addListeners();
        }

        private void addListeners() {
            this.btnSave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.mebnController.saveCPT(CPTEditionPane.this.residentNode, CPTEditionPane.this.cptTextPane.getTableTxt());
                    JOptionPane.showMessageDialog(CPTEditionPane.this.mebnController.getCPTDialog(CPTEditionPane.this.residentNode), resource.getString("CptSaveOK"), resource.getString("sucess"), 1);
                    CPTEditionPane.this.mebnController.openCPTDialog(CPTEditionPane.this.residentNode);
                }
            });
            this.btnCompile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Compiler compiler = new Compiler(CPTEditionPane.this.residentNode);
                    try {
                        compiler.parse(CPTEditionPane.this.cptTextPane.getTableTxt());
                        JOptionPane.showMessageDialog(CPTEditionPane.this.mebnController.getCPTDialog(CPTEditionPane.this.residentNode), resource.getString("CptCompileOK"), resource.getString("sucess"), 1);
                    }
                    catch (MEBNException e1) {
                        JOptionPane.showMessageDialog(CPTEditionPane.this.mebnController.getCPTDialog(CPTEditionPane.this.residentNode), String.valueOf(e1.getMessage()) + " > " + compiler.getIndex() + " <", resource.getString("error"), 0);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(CPTEditionPane.this.mebnController.getCPTDialog(CPTEditionPane.this.residentNode), exc.getMessage(), resource.getString("error"), 0);
                    }
                    CPTEditionPane.this.mebnController.openCPTDialog(CPTEditionPane.this.residentNode);
                }
            });
            this.btnExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CPTEditionPane.this.mebnController.closeCPTDialog(CPTEditionPane.this.residentNode);
                }
            });
        }
    }

    private class JpStates
    extends JPanel {
        private String[] statesArray;

        private JpStates() {
            this.setLayout(new BorderLayout());
            this.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("StatesTitle")));
            List<Entity> statesList = CPTEditionPane.this.residentNode.getPossibleValueList();
            this.statesArray = new String[statesList.size()];
            int i = 0;
            for (Entity state : statesList) {
                this.statesArray[i] = state.getName();
                ++i;
            }
            final JList<String> jlStates = new JList<String>(this.statesArray);
            JScrollPane jscJlStates = new JScrollPane(jlStates);
            this.add((Component)jscJlStates, "Center");
            jlStates.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        int selectedIndex = jlStates.getSelectedIndex();
                        CPTEditionPane.this.cptTextPane.insertState(JpStates.this.statesArray[selectedIndex]);
                    }
                }
            });
        }
    }

    private class JpTurnOptionsPane
    extends JPanel {
        private JButton btnSelectFatherTab;
        private JButton btnSelectStatesTab;
        private JPanel jpOptions;
        private CardLayout cardLayout = new CardLayout();
        private static final String TAB_FATHER = "FatherTab";
        private static final String TAB_ARGUMENTS = "ArgumentsTab";
        private static final String TAB_STATES = "StatesTab";

        private JpTurnOptionsPane() {
            this.jpOptions = new JPanel(this.cardLayout);
            this.jpOptions.add(TAB_FATHER, CPTEditionPane.this.jpFather);
            this.jpOptions.add(TAB_ARGUMENTS, CPTEditionPane.this.jpArguments);
            this.jpOptions.add(TAB_STATES, CPTEditionPane.this.jpStates);
            this.cardLayout.show(this.jpOptions, TAB_FATHER);
            JPanel jpButtons = new JPanel(new GridLayout(1, 2));
            this.btnSelectFatherTab = new JButton(resource.getString("fatherCPT"));
            this.btnSelectFatherTab.setToolTipText(resource.getString("fatherCPTTip"));
            this.btnSelectStatesTab = new JButton(resource.getString("statesCPT"));
            this.btnSelectStatesTab.setToolTipText(resource.getString("statesCPTTip"));
            this.btnSelectStatesTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JpTurnOptionsPane.this.cardLayout.show(JpTurnOptionsPane.this.jpOptions, JpTurnOptionsPane.TAB_STATES);
                }
            });
            this.btnSelectFatherTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JpTurnOptionsPane.this.cardLayout.show(JpTurnOptionsPane.this.jpOptions, JpTurnOptionsPane.TAB_FATHER);
                }
            });
            jpButtons.add(this.btnSelectFatherTab);
            jpButtons.add(this.btnSelectStatesTab);
            this.setLayout(new BorderLayout());
            this.add((Component)this.jpOptions, "Center");
            this.setPreferredSize(new Dimension(300, 300));
            this.setMinimumSize(new Dimension(300, 300));
            this.setMaximumSize(new Dimension(300, 300));
        }
    }
}

