/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.auxiliary.ButtonLabel;
import unbbayes.gui.mebn.auxiliary.FocusListenerTextField;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.ReservedWordException;

public class ToolBarOrdVariable
extends JToolBar {
    private MEBNController mebnController;
    private JLabel name;
    private JTextField txtName;
    private JLabel type;
    private OrdinaryVariable ov;
    private JComboBox jcbType = new JComboBox();
    private Type[] types;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private Matcher matcher;

    public ToolBarOrdVariable(MEBNController _mebnController) {
        this.setLayout(new GridLayout(1, 5));
        this.mebnController = _mebnController;
        this.setFloatable(false);
        ButtonLabel btnOrdVariableActive = new ButtonLabel(resource.getString("OrdVariableButton"), IconController.getInstance().getOVariableNodeIcon());
        this.name = new JLabel(resource.getString("nameLabel"));
        this.txtName = new JTextField(10);
        this.type = new JLabel(resource.getString("typeLabel"));
        this.types = this.mebnController.getMultiEntityBayesianNetwork().getTypeContainer().getListOfTypes().toArray(new Type[0]);
        this.buildJComboBoxTypes(this.types);
        this.txtName.addFocusListener(new FocusListenerTextField());
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ToolBarOrdVariable.this.txtName.getText().length() > 0) {
                    try {
                        String name = ToolBarOrdVariable.this.txtName.getText(0, ToolBarOrdVariable.this.txtName.getText().length());
                        ToolBarOrdVariable.this.matcher = ToolBarOrdVariable.this.wordPattern.matcher(name);
                        if (ToolBarOrdVariable.this.matcher.matches()) {
                            if (ToolBarOrdVariable.this.ov != null) {
                                if (ToolBarOrdVariable.this.mebnController.getCurrentMFrag().getOrdinaryVariableByName(name) != null) {
                                    JOptionPane.showMessageDialog(ToolBarOrdVariable.this.mebnController.getMebnEditionPane(), resource.getString("nameAlreadyExists"), resource.getString("nameError"), 0);
                                } else {
                                    try {
                                        ToolBarOrdVariable.this.mebnController.renameOrdinaryVariable(ToolBarOrdVariable.this.ov, name);
                                    }
                                    catch (DuplicatedNameException e1) {
                                        JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                    }
                                    catch (ReservedWordException e2) {
                                        JOptionPane.showMessageDialog(ToolBarOrdVariable.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                                    }
                                }
                            }
                        } else {
                            ToolBarOrdVariable.this.txtName.setBackground(MebnToolkit.getColorTextFieldError());
                            ToolBarOrdVariable.this.txtName.setForeground(Color.WHITE);
                            ToolBarOrdVariable.this.txtName.selectAll();
                            JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                        }
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble.getMessage());
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                try {
                    String name = ToolBarOrdVariable.this.txtName.getText(0, ToolBarOrdVariable.this.txtName.getText().length());
                    ToolBarOrdVariable.this.matcher = ToolBarOrdVariable.this.wordPattern.matcher(name);
                    if (!ToolBarOrdVariable.this.matcher.matches()) {
                        ToolBarOrdVariable.this.txtName.setBackground(MebnToolkit.getColorTextFieldError());
                        ToolBarOrdVariable.this.txtName.setForeground(Color.WHITE);
                    } else {
                        ToolBarOrdVariable.this.txtName.setBackground(MebnToolkit.getColorTextFieldSelected());
                        ToolBarOrdVariable.this.txtName.setForeground(Color.BLACK);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.add(btnOrdVariableActive);
        JToolBar barName = new JToolBar();
        barName.setFloatable(false);
        barName.add(this.txtName);
        this.add(barName);
        JToolBar barType = new JToolBar();
        barType.setFloatable(false);
        barType.add(this.jcbType);
        this.add(barType);
        this.add(new EmptyPanel());
        this.add(new EmptyPanel());
    }

    public void setOrdVariable(OrdinaryVariable _ov) {
        this.ov = _ov;
        this.txtName.setText(this.ov.getName());
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equals(this.ov.getValueType())) {
                this.jcbType.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.repaint();
    }

    public void updateListOfTypes() {
        this.types = this.mebnController.getMultiEntityBayesianNetwork().getTypeContainer().getListOfTypes().toArray(new Type[0]);
        this.buildJComboBoxTypes(this.types);
        this.validate();
    }

    private JComboBox buildJComboBoxTypes(Type[] types) {
        this.jcbType.setModel(new DefaultComboBoxModel<Type>(types));
        if (this.ov != null) {
            this.jcbType.setSelectedItem(this.ov.getType());
        }
        this.jcbType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Type typeName = (Type)ToolBarOrdVariable.this.jcbType.getSelectedItem();
                if (ToolBarOrdVariable.this.ov != null) {
                    ToolBarOrdVariable.this.mebnController.setOrdinaryVariableType(ToolBarOrdVariable.this.ov, typeName);
                }
            }
        });
        return this.jcbType;
    }

    private class EmptyPanel
    extends JButton {
        public EmptyPanel() {
            this.setEnabled(false);
        }
    }
}

