/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.OVariableTree;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.exception.ArgumentNodeAlreadySetException;
import unbbayes.prs.mebn.exception.OVariableAlreadyExistsInArgumentList;

public class OVariableTreeForArgumentEdition
extends OVariableTree {
    private OrdinaryVariable oVariableSelected = null;
    private MEBNController mebnController;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public OVariableTreeForArgumentEdition(MEBNController controller) {
        super(controller);
        this.mebnController = controller;
    }

    public void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = OVariableTreeForArgumentEdition.this.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = OVariableTreeForArgumentEdition.this.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.isLeaf()) {
                    OrdinaryVariable ordinaryVariable = (OrdinaryVariable)OVariableTreeForArgumentEdition.this.ordinaryVariableMap.get(node);
                    if (e.getModifiers() == 4) {
                        OVariableTreeForArgumentEdition.this.oVariableSelected = null;
                    } else if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                        try {
                            OVariableTreeForArgumentEdition.this.controller.addOrdinaryVariableInResident(ordinaryVariable);
                        }
                        catch (OVariableAlreadyExistsInArgumentList e1) {
                            JOptionPane.showMessageDialog(null, resource.getString("oVariableAlreadyIsArgumentError"), resource.getString("operationError"), 0);
                        }
                        catch (ArgumentNodeAlreadySetException e2) {
                            e2.printStackTrace();
                        }
                        OVariableTreeForArgumentEdition.this.oVariableSelected = null;
                    } else if (e.getClickCount() == 1) {
                        OVariableTreeForArgumentEdition.this.oVariableSelected = ordinaryVariable;
                        OVariableTreeForArgumentEdition.this.mebnController.setOVariableSelectedInMFragTree(OVariableTreeForArgumentEdition.this.oVariableSelected);
                    }
                } else {
                    OVariableTreeForArgumentEdition.this.oVariableSelected = null;
                }
            }
        });
    }

    public OrdinaryVariable getOVariableSelected() {
        return this.oVariableSelected;
    }
}

