/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.FormulaTreeController;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.util.ArrayMap;

public class MTheoryTreeForReplaceInFormula
extends JTree {
    private static final long serialVersionUID = 7557085958154752664L;
    private MultiEntityBayesianNetwork net;
    private boolean[] expandedNodes;
    private ArrayMap<Object, MFrag> mFragMap = new ArrayMap();
    private ArrayMap<Object, ResidentNode> residentNodeMap = new ArrayMap();
    private ArrayMap<Object, Object> nodeMap = new ArrayMap();
    private Object objectSelected;
    protected IconController iconController = IconController.getInstance();
    private final MEBNController controller;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private FormulaTreeController formulaTreeController;

    public MTheoryTreeForReplaceInFormula(final MEBNController controller, FormulaTreeController _formulaTreeController) {
        this.controller = controller;
        this.net = controller.getMultiEntityBayesianNetwork();
        this.formulaTreeController = _formulaTreeController;
        this.setCellRenderer(new MTheoryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.net.getName());
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
        this.createTree();
        this.setRootVisible(false);
        this.putClientProperty("JTree.lineStyle", "None");
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = MTheoryTreeForReplaceInFormula.this.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = MTheoryTreeForReplaceInFormula.this.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.isLeaf()) {
                    Object nodeLeaf = MTheoryTreeForReplaceInFormula.this.nodeMap.get(node);
                    MTheoryTreeForReplaceInFormula.this.objectSelected = nodeLeaf;
                    if (nodeLeaf instanceof Node) {
                        if (e.getModifiers() != 4) {
                            if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                                MTheoryTreeForReplaceInFormula.this.formulaTreeController.addNode((ResidentNode)nodeLeaf);
                                controller.updateFormulaActiveContextNode();
                            } else {
                                e.getClickCount();
                            }
                        }
                    } else if (nodeLeaf instanceof StateLink && e.getModifiers() != 4) {
                        if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                            MTheoryTreeForReplaceInFormula.this.formulaTreeController.addEntity(((StateLink)nodeLeaf).getState());
                            controller.updateFormulaActiveContextNode();
                        } else {
                            e.getClickCount();
                        }
                    }
                } else {
                    Object nodeLeaf = MTheoryTreeForReplaceInFormula.this.nodeMap.get(node);
                    MTheoryTreeForReplaceInFormula.this.objectSelected = nodeLeaf;
                    if (nodeLeaf instanceof Node && e.getModifiers() != 4) {
                        if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                            MTheoryTreeForReplaceInFormula.this.formulaTreeController.addNode((ResidentNode)nodeLeaf);
                            controller.updateFormulaActiveContextNode();
                        } else {
                            e.getClickCount();
                        }
                    }
                }
            }
        });
        this.expandTree();
    }

    private void createTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        List<MFrag> mFragList = this.net.getMFragList();
        for (MFrag mFrag : mFragList) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(mFrag.getName());
            root.add(treeNode);
            this.mFragMap.put(treeNode, mFrag);
            this.nodeMap.put(treeNode, mFrag);
            if (!(mFrag instanceof MFrag)) continue;
            List<ResidentNode> residentNodeList = mFrag.getResidentNodeList();
            for (ResidentNode residentNode : residentNodeList) {
                DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(residentNode.getName());
                treeNode.add(treeNodeChild);
                this.residentNodeMap.put(treeNodeChild, residentNode);
                this.nodeMap.put(treeNodeChild, residentNode);
                for (StateLink state : residentNode.getPossibleValueLinkList()) {
                    DefaultMutableTreeNode treeNodeState = new DefaultMutableTreeNode(state.getState().getName());
                    treeNodeChild.add(treeNodeState);
                    this.nodeMap.put(treeNodeState, state);
                }
            }
        }
        this.expandedNodes = new boolean[this.net.getMFragCount()];
        this.expandTree();
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = false;
            ++i;
        }
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = true;
            ++i;
        }
    }

    private void restoreTree() {
        int i = this.expandedNodes.length - 1;
        while (i >= 0) {
            if (this.expandedNodes[i]) {
                this.expandRow(i);
            } else {
                this.collapseRow(i);
            }
            --i;
        }
    }

    public void updateTree() {
        if (this.expandedNodes == null) {
            this.expandedNodes = new boolean[this.net.getMFragCount()];
            int i = 0;
            while (i < this.expandedNodes.length) {
                this.expandedNodes[i] = false;
                ++i;
            }
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.mFragMap.clear();
        this.residentNodeMap.clear();
        this.nodeMap.clear();
        List<MFrag> mFragList = this.net.getMFragList();
        for (MFrag mFrag : mFragList) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(mFrag.getName());
            root.add(treeNode);
            this.mFragMap.put(treeNode, mFrag);
            this.nodeMap.put(treeNode, mFrag);
            if (!(mFrag instanceof MFrag)) continue;
            List<ResidentNode> residentNodeList = mFrag.getResidentNodeList();
            for (ResidentNode residentNode : residentNodeList) {
                DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(residentNode.getName());
                treeNode.add(treeNodeChild);
                this.residentNodeMap.put(treeNodeChild, residentNode);
                this.nodeMap.put(treeNodeChild, residentNode);
                for (Entity state : residentNode.getPossibleValueList()) {
                    DefaultMutableTreeNode treeNodeState = new DefaultMutableTreeNode(state.getName());
                    treeNodeChild.add(treeNodeState);
                    this.nodeMap.put(treeNodeState, state);
                }
            }
        }
        this.restoreTree();
        ((DefaultTreeModel)this.getModel()).reload(root);
        this.restoreTree();
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    private class MTheoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon residentNodeIcon;
        private ImageIcon orangeNodeIcon;
        private ImageIcon mTheoryNodeIcon;
        private ImageIcon stateIcon;

        private MTheoryTreeCellRenderer() {
            this.residentNodeIcon = MTheoryTreeForReplaceInFormula.this.iconController.getYellowNodeIcon();
            this.orangeNodeIcon = MTheoryTreeForReplaceInFormula.this.iconController.getOrangeNodeIcon();
            this.mTheoryNodeIcon = MTheoryTreeForReplaceInFormula.this.iconController.getMTheoryNodeIcon();
            this.stateIcon = MTheoryTreeForReplaceInFormula.this.iconController.getStateIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = MTheoryTreeForReplaceInFormula.this.nodeMap.get((DefaultMutableTreeNode)value);
            if (leaf) {
                if (obj != null) {
                    if (obj instanceof ResidentNode) {
                        this.setIcon(this.residentNodeIcon);
                    } else if (obj instanceof MFrag) {
                        this.setIcon(this.orangeNodeIcon);
                        this.setForeground(Color.BLUE);
                    } else if (obj instanceof StateLink) {
                        this.setIcon(this.stateIcon);
                    } else {
                        this.setIcon(this.mTheoryNodeIcon);
                    }
                }
            } else if (obj instanceof MFrag) {
                this.setOpenIcon(this.orangeNodeIcon);
                this.setClosedIcon(this.orangeNodeIcon);
                this.setIcon(this.orangeNodeIcon);
                this.setForeground(Color.BLUE);
            } else if (obj instanceof ResidentNode) {
                this.setIcon(this.residentNodeIcon);
            } else {
                this.setOpenIcon(this.mTheoryNodeIcon);
                this.setClosedIcon(this.mTheoryNodeIcon);
                this.setIcon(this.mTheoryNodeIcon);
            }
            return this;
        }
    }
}

