/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.ssbn.SSBNWarning;
import unbbayes.util.ResourceController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningPanel
extends JPanel {
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceController.RS_GUI;
    private JTextArea textArea = new JTextArea();
    private JToolBar toolBar = new JToolBar();
    private final MEBNController mebnController;

    public WarningPanel(MEBNController mebnController) {
        super(new BorderLayout());
        this.mebnController = mebnController;
        JScrollPane scrollPane = new JScrollPane(this.textArea, 20, 32);
        this.textArea.setEditable(true);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        FlowLayout layoutManager = new FlowLayout();
        layoutManager.setAlignment(2);
        this.toolBar.setLayout(layoutManager);
        this.toolBar.setBackground(Color.white);
        JButton btnEnd = new JButton(resource.getString("closeButton"));
        btnEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarningPanel.this.mebnController.closeWarningDialog();
            }
        });
        this.toolBar.add(btnEnd);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.toolBar, "Last");
    }

    public void setListWarningAndUpdateText(List<SSBNWarning> listSSBNWarning) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(resource.getString("warningFound")) + ":\n");
        int countWarning = 0;
        builder.append("----------\n");
        for (SSBNWarning w : listSSBNWarning) {
            builder.append("[" + countWarning + "]\n");
            builder.append(String.valueOf(resource.getString("nodeCause")) + ":" + w.getNodeCause().getName() + "\n");
            builder.append(String.valueOf(w.getExplanation()) + "\n");
            builder.append(String.valueOf(w.getDetalhedExplanation()) + "\n");
            builder.append("----------\n");
            ++countWarning;
        }
        this.textArea.setText(builder.toString());
    }

    public String getDescriptionText() {
        return this.textArea.getText();
    }
}

