/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import unbbayes.controller.IconController;
import unbbayes.gui.IFileExtensionAwareWindow;
import unbbayes.prs.msbn.SingleAgentMSBN;

public class MSBNWindow
extends JInternalFrame
implements IFileExtensionAwareWindow {
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[0];
    private static final long serialVersionUID = 0L;
    public static String EDITION_PANE = "editionPane";
    public static String COMPILED_PANE = "compiledPane";
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private SingleAgentMSBN msbn;
    private JScrollPane netScroll;
    private JList netList;
    private JButton compileBtn;
    private JButton editionBtn;
    private JButton removeBtn;
    private JButton newBtn;
    private CardLayout btnCard;
    private JToolBar jtbBtns;
    protected IconController iconController = IconController.getInstance();

    public MSBNWindow(SingleAgentMSBN msbn) {
        super(msbn.getId(), true, true, true, true);
        this.msbn = msbn;
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        this.initComponents();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.makeListPanel(), "West");
        this.init();
    }

    public SingleAgentMSBN getMSNet() {
        return this.msbn;
    }

    private void initComponents() {
        this.netList = new JList(new MSBNListModel());
        this.compileBtn = new JButton(this.iconController.getCompileIcon());
        this.compileBtn.setToolTipText(resource.getString("compileToolTip"));
        this.editionBtn = new JButton(this.iconController.getEditIcon());
        this.removeBtn = new JButton(this.iconController.getLessIcon());
        this.newBtn = new JButton(this.iconController.getMoreIcon());
    }

    private void init() {
        this.netList.setSelectionMode(0);
    }

    private JPanel makeListPanel() {
        JPanel netPanel = new JPanel(new BorderLayout());
        this.netScroll = new JScrollPane(this.netList);
        netPanel.add((Component)this.netScroll, "Center");
        this.setupButtonsPanel();
        netPanel.add((Component)this.jtbBtns, "North");
        return netPanel;
    }

    private void setupButtonsPanel() {
        this.btnCard = new CardLayout();
        this.jtbBtns = new JToolBar();
        this.jtbBtns.setLayout(this.btnCard);
        JPanel editionPane = new JPanel();
        this.jtbBtns.add((Component)editionPane, EDITION_PANE);
        editionPane.add(this.newBtn);
        editionPane.add(this.removeBtn);
        editionPane.add(this.compileBtn);
        JPanel compiledPane = new JPanel();
        compiledPane.add(this.editionBtn);
        this.jtbBtns.add((Component)compiledPane, COMPILED_PANE);
        this.showBtnPanel(EDITION_PANE);
    }

    public void addCompileBtnActionListener(ActionListener a) {
        this.compileBtn.addActionListener(a);
    }

    public void addRemoveBtnActionListener(ActionListener a) {
        this.removeBtn.addActionListener(a);
    }

    public void addNewBtnActionListener(ActionListener a) {
        this.newBtn.addActionListener(a);
    }

    public void addEditionActionListener(ActionListener a) {
        this.editionBtn.addActionListener(a);
    }

    public void addListMouseListener(MouseListener l) {
        this.netList.addMouseListener(l);
    }

    public void showBtnPanel(String paneName) {
        this.btnCard.show(this.jtbBtns, paneName);
    }

    public JList getNetList() {
        return this.netList;
    }

    public void changeToTreeView(JTree tree) {
        this.netScroll.setViewportView(tree);
    }

    public void changeToListView() {
        this.netScroll.setViewportView(this.netList);
    }

    public String[] getSupportedFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    public String getSupportedFilesDescription() {
        return resource.getString("netFileFilterSaveMSBN");
    }

    public String getSavingMessage() {
        return resource.getString("saveTitle");
    }

    private class MSBNListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 0L;

        private MSBNListModel() {
        }

        public int getSize() {
            return MSBNWindow.this.msbn.getNetCount();
        }

        public Object getElementAt(int index) {
            return MSBNWindow.this.msbn.getNetAt(index);
        }
    }
}

