/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import unbbayes.controller.NetworkController;
import unbbayes.controller.SENController;
import unbbayes.gui.GraphPane;
import unbbayes.gui.PreviewPane;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;

public class GlobalOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 0L;
    final JButton probabilisticDescriptionNode;
    final JButton probabilisticExplanationNode;
    final JButton decisionNode;
    final JButton utilityNode;
    final JButton arc;
    final JButton selection;
    final JButton back;
    private NetworkController controller;
    private JTabbedPane jtp;
    private JPanel controllerColorPanel = new JPanel(new BorderLayout());
    private JPanel northControllerColorPanel = new JPanel(new GridLayout(2, 1));
    private JPanel controllerSizePanel = new JPanel(new BorderLayout());
    private JPanel northControllerSizePanel = new JPanel();
    private JPanel flowControllerColorPanel1;
    private JPanel flowControllerColorPanel2;
    private JPanel radiusPanel;
    private JPanel netPanel;
    private JPanel confirmationPanel;
    private JPanel logPanel;
    private JPanel algorithmPanel;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private JButton confirm;
    private JButton restore;
    private JButton cancel;
    private Color probabilisticDescriptionNodeColor;
    private Color probabilisticExplanationNodeColor;
    private Color decisionNodeColor;
    private Color utilityNodeColor;
    private Color edgeColor;
    private Color selectionColor;
    private Color backgroundColor;
    private JLabel radius;
    private JLabel net;
    private JSlider radiusSlider;
    private JSlider netSlider;
    private JCheckBox createLog;
    private boolean createLogBoolean;
    private ButtonGroup algorithmGroup;
    private JRadioButtonMenuItem junctionTreeAlgorithm;
    private JRadioButtonMenuItem likelihoodWeightingAlgorithm;
    private JRadioButtonMenuItem gaussianMixtureAlgorithm;
    private final GraphPane graph;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public GlobalOptionsDialog(GraphPane gra, NetworkController con) {
        super(new Frame(), resource.getString("globalOptionTitle"), true);
        Container contentPane = this.getContentPane();
        this.setSize(550, 470);
        this.setResizable(true);
        this.graph = gra;
        this.controller = con;
        this.createLog = new JCheckBox(resource.getString("createLogLabel"));
        this.algorithmGroup = new ButtonGroup();
        this.junctionTreeAlgorithm = new JRadioButtonMenuItem(resource.getString("junctionTreeAlgorithmName"), this.controller.getInferenceAlgorithm() == SENController.InferenceAlgorithmEnum.JUNCTION_TREE);
        this.likelihoodWeightingAlgorithm = new JRadioButtonMenuItem(resource.getString("likelihoodWeightingAlgorithmName"), this.controller.getInferenceAlgorithm() == SENController.InferenceAlgorithmEnum.LIKELIHOOD_WEIGHTING);
        this.gaussianMixtureAlgorithm = new JRadioButtonMenuItem(resource.getString("gaussianMixtureAlgorithmName"), this.controller.getInferenceAlgorithm() == SENController.InferenceAlgorithmEnum.GAUSSIAN_MIXTURE);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.probabilisticDescriptionNodeColor = ProbabilisticNode.getDescriptionColor();
        this.probabilisticExplanationNodeColor = ProbabilisticNode.getExplanationColor();
        this.decisionNodeColor = DecisionNode.getColor();
        this.utilityNodeColor = UtilityNode.getColor();
        this.edgeColor = Edge.getColor();
        this.selectionColor = GraphPane.getSelectionColor();
        this.backgroundColor = this.graph.getBackgroundColor();
        this.createLogBoolean = this.controller.getSingleEntityNetwork().isCreateLog();
        this.radius = new JLabel(resource.getString("radiusLabel"));
        this.radius.setToolTipText(resource.getString("radiusToolTip"));
        this.radiusSlider = new JSlider(0, 10, 40, Node.getWidth() / 2);
        this.radiusSlider.setToolTipText(resource.getString("radiusToolTip"));
        this.radiusSlider.setMinorTickSpacing(1);
        this.radiusSlider.setMajorTickSpacing(10);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.setPaintLabels(true);
        this.net = new JLabel(resource.getString("netLabel"));
        this.net.setToolTipText(resource.getString("netToolTip"));
        this.netSlider = new JSlider(0, 1500, 11500, (int)this.graph.getGraphDimension().getWidth());
        this.netSlider.setToolTipText(resource.getString("netToolTip"));
        this.netSlider.setMinorTickSpacing(1000);
        this.netSlider.setMajorTickSpacing(5000);
        this.netSlider.setPaintTicks(true);
        this.netSlider.setPaintLabels(true);
        this.jtp = new JTabbedPane();
        this.radiusPanel = new JPanel(this.gbl);
        this.netPanel = new JPanel(this.gbl);
        this.confirmationPanel = new JPanel(new FlowLayout(1));
        this.flowControllerColorPanel1 = new JPanel();
        this.flowControllerColorPanel2 = new JPanel();
        this.logPanel = new JPanel();
        this.algorithmPanel = new JPanel();
        this.probabilisticDescriptionNode = new JButton(resource.getString("probabilisticDescriptionNodeColorLabel"));
        this.probabilisticDescriptionNode.setToolTipText(resource.getString("probabilisticDescriptionNodeColorToolTip"));
        this.probabilisticDescriptionNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("nodeColorLabel"), GlobalOptionsDialog.this.probabilisticDescriptionNodeColor);
                if (color != null) {
                    GlobalOptionsDialog.this.probabilisticDescriptionNodeColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.probabilisticExplanationNode = new JButton(resource.getString("probabilisticExplanationNodeColorLabel"));
        this.probabilisticExplanationNode.setToolTipText(resource.getString("probabilisticExplanationNodeColorToolTip"));
        this.probabilisticExplanationNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("nodeColorLabel"), GlobalOptionsDialog.this.probabilisticExplanationNodeColor);
                if (color != null) {
                    GlobalOptionsDialog.this.probabilisticExplanationNodeColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.decisionNode = new JButton(resource.getString("decisionNodeColorLabel"));
        this.decisionNode.setToolTipText(resource.getString("decisionNodeColorToolTip"));
        this.decisionNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("nodeColorLabel"), GlobalOptionsDialog.this.decisionNodeColor);
                if (color != null) {
                    GlobalOptionsDialog.this.decisionNodeColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.utilityNode = new JButton(resource.getString("utilityNodeColorLabel"));
        this.utilityNode.setToolTipText(resource.getString("utilityNodeColorToolTip"));
        this.utilityNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("nodeColorLabel"), GlobalOptionsDialog.this.utilityNodeColor);
                if (color != null) {
                    GlobalOptionsDialog.this.utilityNodeColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.arc = new JButton(resource.getString("arcColorLabel"));
        this.arc.setToolTipText(resource.getString("arcColorToolTip"));
        this.arc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("edgeColor"), GlobalOptionsDialog.this.edgeColor);
                if (color != null) {
                    GlobalOptionsDialog.this.edgeColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.selection = new JButton(resource.getString("selectionColorLabel"));
        this.selection.setToolTipText(resource.getString("selectionColorToolTip"));
        this.selection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("selectionColor"), GlobalOptionsDialog.this.selectionColor);
                if (color != null) {
                    GlobalOptionsDialog.this.selectionColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.back = new JButton(resource.getString("backgroundColorLabel"));
        this.back.setToolTipText(resource.getString("backgroundColorToolTip"));
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(((Component)e.getSource()).getParent(), resource.getString("backGroundColor"), GlobalOptionsDialog.this.backgroundColor);
                if (color != null) {
                    GlobalOptionsDialog.this.backgroundColor = color;
                    GlobalOptionsDialog.this.repaint();
                }
            }
        });
        this.confirm = new JButton(resource.getString("confirmLabel"));
        this.confirm.setToolTipText(resource.getString("confirmToolTip"));
        this.confirmationPanel.add(this.confirm);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProbabilisticNode.setDescriptionColor(GlobalOptionsDialog.this.probabilisticDescriptionNodeColor.getRGB());
                ProbabilisticNode.setExplanationColor(GlobalOptionsDialog.this.probabilisticExplanationNodeColor.getRGB());
                DecisionNode.setColor(GlobalOptionsDialog.this.decisionNodeColor.getRGB());
                UtilityNode.setColor(GlobalOptionsDialog.this.utilityNodeColor.getRGB());
                Edge.setColor(GlobalOptionsDialog.this.edgeColor.getRGB());
                GraphPane.setSelectionColor(GlobalOptionsDialog.this.selectionColor);
                GlobalOptionsDialog.this.graph.setBackgroundColor(GlobalOptionsDialog.this.backgroundColor);
                Node.setSize(GlobalOptionsDialog.this.radiusSlider.getValue() * 2, GlobalOptionsDialog.this.radiusSlider.getValue() * 2);
                GlobalOptionsDialog.this.graph.setGraphDimension(new Dimension(GlobalOptionsDialog.this.netSlider.getValue(), GlobalOptionsDialog.this.netSlider.getValue()));
                GlobalOptionsDialog.this.controller.getSingleEntityNetwork().setCreateLog(GlobalOptionsDialog.this.createLog.isSelected());
                if (GlobalOptionsDialog.this.junctionTreeAlgorithm.isSelected()) {
                    GlobalOptionsDialog.this.controller.setInferenceAlgorithm(SENController.InferenceAlgorithmEnum.JUNCTION_TREE);
                } else if (GlobalOptionsDialog.this.likelihoodWeightingAlgorithm.isSelected()) {
                    GlobalOptionsDialog.this.controller.setInferenceAlgorithm(SENController.InferenceAlgorithmEnum.LIKELIHOOD_WEIGHTING);
                } else if (GlobalOptionsDialog.this.gaussianMixtureAlgorithm.isSelected()) {
                    GlobalOptionsDialog.this.controller.setInferenceAlgorithm(SENController.InferenceAlgorithmEnum.GAUSSIAN_MIXTURE);
                }
                GlobalOptionsDialog.this.setVisible(false);
                GlobalOptionsDialog.this.dispose();
                GlobalOptionsDialog.this.graph.update();
            }
        });
        this.restore = new JButton(resource.getString("resetLabel"));
        this.restore.setToolTipText(resource.getString("resetToolTip"));
        this.confirmationPanel.add(this.restore);
        this.restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlobalOptionsDialog.this.probabilisticDescriptionNodeColor = ProbabilisticNode.getDescriptionColor();
                GlobalOptionsDialog.this.probabilisticExplanationNodeColor = ProbabilisticNode.getExplanationColor();
                GlobalOptionsDialog.this.decisionNodeColor = DecisionNode.getColor();
                GlobalOptionsDialog.this.utilityNodeColor = UtilityNode.getColor();
                GlobalOptionsDialog.this.edgeColor = Edge.getColor();
                GlobalOptionsDialog.this.selectionColor = GraphPane.getSelectionColor();
                GlobalOptionsDialog.this.backgroundColor = GlobalOptionsDialog.this.graph.getBackgroundColor();
                GlobalOptionsDialog.this.netSlider.setValue((int)GlobalOptionsDialog.this.graph.getGraphDimension().getWidth());
                GlobalOptionsDialog.this.radiusSlider.setValue(Node.getWidth() / 2);
                GlobalOptionsDialog.this.controller.getSingleEntityNetwork().setCreateLog(GlobalOptionsDialog.this.createLogBoolean);
                GlobalOptionsDialog.this.repaint();
            }
        });
        this.cancel = new JButton(resource.getString("cancelLabel"));
        this.cancel.setToolTipText(resource.getString("cancelToolTip"));
        this.confirmationPanel.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlobalOptionsDialog.this.setVisible(false);
                GlobalOptionsDialog.this.dispose();
                GlobalOptionsDialog.this.graph.update();
            }
        });
        this.radiusSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GlobalOptionsDialog.this.repaint();
            }
        });
        this.setConstraints(this.gbc, 0, 0, 1, 1, 1, 1);
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.radius, this.gbc);
        this.setConstraints(this.gbc, 1, 0, 0, 0, 9, 0);
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.radiusSlider, this.gbc);
        this.setConstraints(this.gbc, 0, 0, 1, 1, 1, 1);
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.net, this.gbc);
        this.setConstraints(this.gbc, 1, 0, 0, 0, 9, 0);
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.netSlider, this.gbc);
        this.radiusPanel.add(this.radius);
        this.radiusPanel.add(this.radiusSlider);
        this.netPanel.add(this.net);
        this.netPanel.add(this.netSlider);
        this.flowControllerColorPanel1.add(this.probabilisticDescriptionNode);
        this.flowControllerColorPanel1.add(this.probabilisticExplanationNode);
        this.flowControllerColorPanel1.add(this.decisionNode);
        this.flowControllerColorPanel2.add(this.utilityNode);
        this.flowControllerColorPanel2.add(this.arc);
        this.flowControllerColorPanel2.add(this.selection);
        this.flowControllerColorPanel2.add(this.back);
        this.northControllerColorPanel.add(this.flowControllerColorPanel1);
        this.northControllerColorPanel.add(this.flowControllerColorPanel2);
        this.controllerColorPanel.add((Component)this.northControllerColorPanel, "North");
        this.controllerColorPanel.add((Component)new PreviewPane(this), "Center");
        this.northControllerSizePanel.add(this.netPanel);
        this.northControllerSizePanel.add(this.radiusPanel);
        this.controllerSizePanel.add((Component)this.northControllerSizePanel, "North");
        this.controllerSizePanel.add((Component)new PreviewPane(this), "Center");
        this.logPanel.add(this.createLog);
        this.algorithmGroup.add(this.junctionTreeAlgorithm);
        this.algorithmGroup.add(this.likelihoodWeightingAlgorithm);
        this.algorithmGroup.add(this.gaussianMixtureAlgorithm);
        this.algorithmPanel.add(this.junctionTreeAlgorithm);
        this.algorithmPanel.add(this.likelihoodWeightingAlgorithm);
        this.algorithmPanel.add(this.gaussianMixtureAlgorithm);
        this.jtp.addTab(resource.getString("colorControllerTab"), this.controllerColorPanel);
        this.jtp.addTab(resource.getString("sizeControllerTab"), this.controllerSizePanel);
        this.jtp.addTab(resource.getString("algorithmTab"), this.algorithmPanel);
        this.jtp.addTab(resource.getString("logTab"), this.logPanel);
        contentPane.add((Component)this.jtp, "Center");
        contentPane.add((Component)this.confirmationPanel, "South");
    }

    public int getRadius() {
        return this.radiusSlider.getValue();
    }

    public Color getPropabilisticDescriptionNodeColor() {
        return this.probabilisticDescriptionNodeColor;
    }

    public Color getPropabilisticExplanationNodeColor() {
        return this.probabilisticExplanationNodeColor;
    }

    public Color getDecisionNodeColor() {
        return this.decisionNodeColor;
    }

    public Color getUtilityNodeColor() {
        return this.utilityNodeColor;
    }

    public Color getArcColor() {
        return this.edgeColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    private void setConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

