/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.gui.NetworkWindow;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.util.ArrayMap;
import unbbayes.util.ResourceController;

public class EvidenceTree
extends JTree {
    private static final long serialVersionUID = 0L;
    private SingleEntityNetwork net;
    private NumberFormat nf;
    private boolean[] expandedNodes;
    private ArrayMap<Object, Node> objectsMap = new ArrayMap();
    protected IconController iconController = IconController.getInstance();
    private final NetworkWindow netWindow;
    private ResourceBundle resource = ResourceController.RS_GUI;

    public EvidenceTree(SingleEntityNetwork sen, final NetworkWindow netWindow) {
        this.net = sen;
        this.netWindow = netWindow;
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setMaximumFractionDigits(2);
        this.setCellRenderer(new EvidenceTreeCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = EvidenceTree.this.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = EvidenceTree.this.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.isLeaf()) {
                    if (e.getModifiers() == 4) {
                        EvidenceTree.this.showLikelihood((DefaultMutableTreeNode)node.getParent());
                    } else if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                        EvidenceTree.this.treeDoubleClick(node);
                    }
                } else {
                    if (e.getModifiers() == 4) {
                        EvidenceTree.this.showLikelihood(node);
                    }
                    if (e.getClickCount() == 1) {
                        Node newNode = EvidenceTree.this.getNodeMap(node);
                        if (newNode != null) {
                            netWindow.getGraphPane().selectObject(newNode);
                            netWindow.getGraphPane().update();
                        }
                    } else if (e.getClickCount() == 2) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)EvidenceTree.this.getModel().getRoot();
                        int index = root.getIndex(node);
                        ((EvidenceTree)EvidenceTree.this).expandedNodes[index] = !EvidenceTree.this.expandedNodes[index];
                    }
                }
            }
        });
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = false;
            ++i;
        }
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
        i = 0;
        while (i < this.expandedNodes.length) {
            this.expandedNodes[i] = true;
            ++i;
        }
    }

    private void restoreTree() {
        int i = this.expandedNodes.length - 1;
        while (i >= 0) {
            if (this.expandedNodes[i]) {
                this.expandRow(i);
            } else {
                this.collapseRow(i);
            }
            --i;
        }
    }

    public void resetTree() {
        this.expandedNodes = null;
    }

    public void updateTree() {
        if (this.expandedNodes == null) {
            this.expandedNodes = new boolean[this.net.getNodesCopy().size()];
            int i = 0;
            while (i < this.expandedNodes.length) {
                this.expandedNodes[i] = true;
                ++i;
            }
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.objectsMap.clear();
        DefaultTreeModel model = new DefaultTreeModel((DefaultMutableTreeNode)this.net.getHierarchicTree().copyTree().getModel().getRoot());
        this.setModel(model);
        root = (DefaultMutableTreeNode)this.getModel().getRoot();
        ArrayList<Node> nodes = this.net.getNodesCopy();
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            Node node = nodes.get(i);
            TreeVariable treeVariable = (TreeVariable)node;
            DefaultMutableTreeNode treeNode = this.findUserObject(node.getDescription(), root);
            if (treeNode == null) {
                treeNode = new DefaultMutableTreeNode(node.getDescription());
                root.add(treeNode);
            }
            this.objectsMap.put(treeNode, node);
            int statesSize = node.getStatesSize();
            int j = 0;
            while (j < statesSize) {
                String label = treeVariable.getType() == 0 ? String.valueOf(node.getStateAt(j)) + ": " + this.nf.format((double)treeVariable.getMarginalAt(j) * 100.0) : String.valueOf(node.getStateAt(j)) + ": " + this.nf.format(treeVariable.getMarginalAt(j));
                treeNode.add(new DefaultMutableTreeNode(label));
                ++j;
            }
            ++i;
        }
        this.restoreTree();
        ((DefaultTreeModel)this.getModel()).reload(root);
        this.restoreTree();
    }

    public void setNumberFormat(Locale local) {
        this.nf = NumberFormat.getInstance(local);
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    private void treeDoubleClick(DefaultMutableTreeNode treeNode) {
        TreeVariable node;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        Node obj = this.objectsMap.get(parent);
        if (obj != null && (node = (TreeVariable)obj).getInformationType() == 3) {
            int i = 0;
            while (i < parent.getChildCount()) {
                DefaultMutableTreeNode auxNode = (DefaultMutableTreeNode)parent.getChildAt(i);
                auxNode.setUserObject(String.valueOf(node.getStateAt(i)) + ": 0");
                ++i;
            }
            if (node.getType() == 0) {
                treeNode.setUserObject(String.valueOf(node.getStateAt(parent.getIndex(treeNode))) + ": 100");
            } else {
                treeNode.setUserObject(String.valueOf(node.getStateAt(parent.getIndex(treeNode))) + ": **");
            }
            node.addFinding(parent.getIndex(treeNode));
            ((DefaultTreeModel)this.getModel()).reload(parent);
        }
    }

    private void showLikelihood(DefaultMutableTreeNode node) {
        ProbabilisticNode auxVP = (ProbabilisticNode)this.objectsMap.get(node);
        if (auxVP != null && auxVP.getInformationType() == 3) {
            JPanel panel = new JPanel();
            JTable table = new JTable(auxVP.getStatesSize(), 2);
            int i = 0;
            while (i < auxVP.getStatesSize()) {
                table.setValueAt(auxVP.getStateAt(i), i, 0);
                table.setValueAt("100", i, 1);
                ++i;
            }
            JLabel label = new JLabel(auxVP.toString());
            panel.add(label);
            panel.add(table);
            if (JOptionPane.showConfirmDialog(this.netWindow.getDesktopPane(), panel, this.resource.getString("likelihoodName"), 2) == 0) {
                float[] values = new float[auxVP.getStatesSize()];
                try {
                    i = 0;
                    while (i < auxVP.getStatesSize()) {
                        values[i] = this.nf.parse((String)table.getValueAt(i, 1)).floatValue();
                        ++i;
                    }
                }
                catch (ParseException e) {
                    System.err.println(e.getMessage());
                    return;
                }
                double maxValue = values[0];
                i = 1;
                while (i < auxVP.getStatesSize()) {
                    if (maxValue < (double)values[i]) {
                        maxValue = values[i];
                    }
                    ++i;
                }
                if (maxValue == 0.0) {
                    System.err.println("likelihoodException");
                    return;
                }
                i = 0;
                while (i < auxVP.getStatesSize()) {
                    int n = i++;
                    values[n] = (float)((double)values[n] / maxValue);
                }
                i = 0;
                while (i < values.length && values[i] == 1.0f) {
                    ++i;
                }
                if (i == values.length) {
                    return;
                }
                auxVP.addLikeliHood(values);
                i = 0;
                while (i < node.getChildCount()) {
                    DefaultMutableTreeNode auxNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    String str = (String)auxNode.getUserObject();
                    auxNode.setUserObject(String.valueOf(str.substring(0, str.lastIndexOf(58) + 1)) + this.nf.format(values[i] * 100.0f));
                    ++i;
                }
                ((DefaultTreeModel)this.getModel()).reload(node);
            }
        }
    }

    public Node getNodeMap(DefaultMutableTreeNode node) {
        Node obj = this.objectsMap.get(node);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    private class EvidenceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon folderSmallIcon;
        private ImageIcon folderSmallDisabledIcon;
        private ImageIcon yellowBallIcon;
        private ImageIcon greenBallIcon;

        private EvidenceTreeCellRenderer() {
            this.folderSmallIcon = EvidenceTree.this.iconController.getFolderSmallIcon();
            this.folderSmallDisabledIcon = EvidenceTree.this.iconController.getFolderSmallDisabledIcon();
            this.yellowBallIcon = EvidenceTree.this.iconController.getYellowBallIcon();
            this.greenBallIcon = EvidenceTree.this.iconController.getGreenBallIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent();
                Object obj = EvidenceTree.this.objectsMap.get(parent);
                if (obj != null) {
                    Node node = (Node)obj;
                    if (node.getInformationType() == 3) {
                        this.setIcon(this.yellowBallIcon);
                    } else {
                        this.setIcon(this.greenBallIcon);
                    }
                } else {
                    this.setIcon(this.yellowBallIcon);
                }
            } else {
                Object obj = EvidenceTree.this.objectsMap.get((DefaultMutableTreeNode)value);
                if (obj != null) {
                    Node node = (Node)obj;
                    if (node.getInformationType() == 3) {
                        this.setOpenIcon(this.folderSmallIcon);
                        this.setClosedIcon(this.folderSmallIcon);
                        this.setIcon(this.folderSmallIcon);
                    } else {
                        this.setOpenIcon(this.folderSmallDisabledIcon);
                        this.setClosedIcon(this.folderSmallDisabledIcon);
                        this.setIcon(this.folderSmallDisabledIcon);
                    }
                } else {
                    this.setOpenIcon(this.folderSmallIcon);
                    this.setClosedIcon(this.folderSmallIcon);
                    this.setIcon(this.folderSmallIcon);
                }
            }
            return this;
        }
    }
}

