/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import unbbayes.draw.DrawElement;

public class DrawEllipse
extends DrawElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Point2D.Double position;
    private Point2D.Double size;

    public DrawEllipse(Point2D.Double position, Point2D.Double size) {
        this.position = position;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        graphics.setColor(this.getFillColor());
        graphics.fill(new Ellipse2D.Double(this.position.x - this.size.x / 2.0, this.position.y - this.size.y / 2.0, this.size.x, this.size.y));
        if (this.isSelected()) {
            graphics.setColor(DrawEllipse.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(DrawEllipse.getOutlineColor());
        }
        graphics.draw(new Ellipse2D.Double(this.position.x - this.size.x / 2.0, this.position.y - this.size.y / 2.0, this.size.x, this.size.y));
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }
}

