/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;

public class Simplesampling
extends Batch {
    private boolean remove;
    private boolean[] deleteIndex;
    private static boolean useRatio = true;
    private static boolean useK = false;
    private static boolean useOverThresh = false;
    private static boolean usePosThresh = false;
    private static boolean useNegThresh = false;
    private static boolean useCleaning = false;

    public Simplesampling(InstanceSet instanceSet) {
        this(instanceSet, null);
    }

    public Simplesampling(InstanceSet instanceSet, PreprocessorParameters parameters) {
        super(useRatio, useK, useOverThresh, usePosThresh, useNegThresh, useCleaning, instanceSet, parameters);
        this.preprocessorName = "Simplesampling";
    }

    public void runAll() {
        int numInstances = this.instanceSet.numInstances;
        int[] instancesIDs = new int[numInstances];
        int i = 0;
        while (i < numInstances) {
            instancesIDs[i] = i;
            ++i;
        }
        this.run(instancesIDs);
    }

    protected void run() {
        Instance[] instances = this.instanceSet.instances;
        int numInstances = this.instanceSet.numInstances;
        int counter = 0;
        int[] instancesIDsTmp = new int[numInstances];
        int classIndex = this.instanceSet.classIndex;
        int inst = 0;
        while (inst < numInstances) {
            if (instances[inst].data[classIndex] == (float)this.interestingClass) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        this.run(instancesIDs);
    }

    public void run(int[] instancesIDs) {
        int counterIndex = this.instanceSet.counterIndex;
        int numInstancesIDs = instancesIDs.length;
        int inst = 0;
        boolean delete = false;
        int i = 0;
        while (i < numInstancesIDs) {
            inst = instancesIDs[i];
            int weight = (int)this.instanceSet.instances[inst].data[counterIndex];
            int newWeight = Math.round((float)this.proportion * (float)weight);
            int difference = newWeight - weight;
            this.instanceSet.numWeightedInstances += difference;
            this.instanceSet.instances[inst].data[counterIndex] = newWeight;
            if (newWeight <= 0) {
                this.deleteIndex[inst] = true;
                delete = true;
            }
            ++i;
        }
        if (delete && this.remove) {
            this.instanceSet.removeInstances(this.deleteIndex);
        }
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void setDeleteIndex(boolean[] deleteIndex) {
        this.deleteIndex = deleteIndex;
    }

    protected void initializeBatch(InstanceSet instanceSet) {
        this.setInstanceSet(instanceSet);
        this.setInterestingClass(this.positiveClass);
    }
}

