/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import java.lang.constant.Constable;
import java.util.ArrayList;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;

public abstract class Batch {
    private ArrayList<Object>[] parametersList;
    protected int numBatchIterations;
    private int currentBatchIteration;
    protected InstanceSet instanceSet;
    private boolean useRatio;
    private boolean useK;
    private boolean useOverThresh;
    private boolean usePosThresh;
    private boolean useNegThresh;
    private boolean useCleaning;
    protected String preprocessorName;
    protected int ratio;
    protected int k;
    protected float oversamplingThreshold;
    protected float positiveThreshold;
    protected float negativeThreshold;
    protected boolean clean;
    protected boolean autoOversamplingThreshold;
    protected int positiveClass;
    protected int negativeClass;
    protected double proportion;
    protected int interestingClass;
    protected boolean useSimplesampling;

    public Batch(boolean useRatio, boolean useK, boolean useOverThresh, boolean usePosThresh, boolean useNegThresh, boolean useCleaning, InstanceSet instanceSet, PreprocessorParameters parameters) throws IllegalArgumentException {
        this.useRatio = useRatio;
        this.useK = useK;
        this.useOverThresh = useOverThresh;
        this.usePosThresh = usePosThresh;
        this.useNegThresh = useNegThresh;
        this.useCleaning = useCleaning;
        this.instanceSet = instanceSet;
        this.positiveClass = instanceSet.getPositiveClass();
        this.negativeClass = instanceSet.getNegativeClass();
        if (parameters != null) {
            this.buildBatchParameters(parameters);
        }
    }

    protected abstract void run() throws Exception;

    public final void getNextBatchIteration(InstanceSet instanceSet) throws Exception {
        this.initializeBatch(instanceSet);
        this.setBatchParameters(this.currentBatchIteration);
        this.run();
        ++this.currentBatchIteration;
    }

    protected abstract void initializeBatch(InstanceSet var1) throws Exception;

    public final void getBatchIteration(int parameterID) throws Exception {
        this.setBatchParameters(parameterID);
        this.run();
    }

    public final int getNumBatchIterations() {
        return this.numBatchIterations;
    }

    public abstract void setInstanceSet(InstanceSet var1);

    public void setProportion(double proportion) {
        this.proportion = proportion;
    }

    public void setInterestingClass(int interestingClass) {
        this.interestingClass = interestingClass;
    }

    public void setUseSimplesampling(boolean useSimplesampling) {
        this.useSimplesampling = useSimplesampling;
    }

    /*
     * Unable to fully structure code
     */
    public final void buildBatchParameters(PreprocessorParameters parameters) throws IllegalArgumentException {
        ratioStart = parameters.getRatioStart();
        ratioEnd = parameters.getRatioEnd();
        ratioStep = parameters.getRatioStep();
        t1Start = parameters.getOverThresholdStart();
        t1End = parameters.getOverThresholdEnd();
        t1Step = parameters.getOverThresholdStep();
        t2Start = parameters.getPosThresholdStart();
        t2End = parameters.getPosThresholdEnd();
        t2Step = parameters.getPosThresholdStep();
        t3Start = parameters.getNegThresholdStart();
        t3End = parameters.getNegThresholdEnd();
        t3Step = parameters.getNegThresholdStep();
        clusterStart = parameters.getClusterStart();
        clusterEnd = parameters.getClusterEnd();
        clusterStep = parameters.getClusterStep();
        oversamplingThresholdStart = parameters.getOverThresholdStart();
        oversamplingThresholdEnd = parameters.getOverThresholdEnd();
        oversamplingThresholdStep = parameters.getOverThresholdStep();
        positiveThresholdStart = parameters.getPosThresholdStart();
        positiveThresholdEnd = parameters.getPosThresholdEnd();
        positiveThresholdStep = parameters.getPosThresholdStep();
        negativeThresholdStart = parameters.getNegThresholdStart();
        negativeThresholdEnd = parameters.getNegThresholdEnd();
        negativeThresholdStep = parameters.getNegThresholdStep();
        if (ratioStep >= 1 && ratioStep >= 1 && t1Step >= 1 && t2Step >= 1 && t3Step >= 1 && clusterStep >= 1 && oversamplingThresholdStep >= 1 && positiveThresholdStep >= 1 && negativeThresholdStep >= 1) ** GOTO lbl28
        throw new IllegalArgumentException("Illegal arguments!");
lbl-1000:
        // 1 sources

        {
            ratioStart += ratioStep;
lbl28:
            // 2 sources

            ** while ((float)ratioStart / 100.0f <= this.instanceSet.getClassFrequency((int)this.positiveClass))
        }
lbl29:
        // 1 sources

        this.numBatchIterations = this.useCleaning != false ? 2 : 1;
        if (this.useRatio) {
            this.numBatchIterations *= (ratioEnd - ratioStart) / ratioStep + 1;
        } else {
            ratioStep = 100000;
        }
        if (this.useK) {
            this.numBatchIterations *= (clusterEnd - clusterStart) / clusterStep + 1;
        } else {
            clusterStep = 100000;
        }
        if (this.useOverThresh) {
            this.numBatchIterations *= (oversamplingThresholdEnd - oversamplingThresholdStart) / oversamplingThresholdStep + 1;
        } else {
            t1Step = 100000;
        }
        if (this.usePosThresh) {
            this.numBatchIterations *= (positiveThresholdEnd - positiveThresholdStart) / positiveThresholdStep + 1;
        } else {
            t2Step = 100000;
        }
        if (this.useNegThresh) {
            this.numBatchIterations *= (negativeThresholdEnd - negativeThresholdStart) / negativeThresholdStep + 1;
        } else {
            t3Step = 100000;
        }
        this.parametersList = new ArrayList[this.numBatchIterations];
        count = 0;
        ratio = ratioStart;
        while (ratio <= ratioEnd) {
            k = clusterStart;
            while (k <= clusterEnd) {
                t1 = t1Start;
                while (t1 <= t1End) {
                    t2 = t2Start;
                    while (t2 <= t2End) {
                        t3 = t3Start;
                        while (t3 <= t3End) {
                            clean = false;
                            parametersListAux = new ArrayList<Constable>(6);
                            parametersListAux.add(Integer.valueOf(ratio));
                            parametersListAux.add(Integer.valueOf(k));
                            parametersListAux.add(Integer.valueOf(t1));
                            parametersListAux.add(Integer.valueOf(t2));
                            parametersListAux.add(Integer.valueOf(t3));
                            parametersListAux.add(Boolean.valueOf(clean));
                            parametersListAux.trimToSize();
                            this.parametersList[count] = parametersListAux;
                            ++count;
                            if (this.useCleaning) {
                                clean = true;
                                parametersListAux = new ArrayList<E>(6);
                                parametersListAux.add(Integer.valueOf(ratio));
                                parametersListAux.add(Integer.valueOf(k));
                                parametersListAux.add(Integer.valueOf(t1));
                                parametersListAux.add(Integer.valueOf(t2));
                                parametersListAux.add(Integer.valueOf(t3));
                                parametersListAux.add(Boolean.valueOf(clean));
                                parametersListAux.trimToSize();
                                this.parametersList[count] = parametersListAux;
                                ++count;
                            }
                            t3 += t3Step;
                        }
                        t2 += t2Step;
                    }
                    t1 += t1Step;
                }
                k += clusterStep;
            }
            ratio += ratioStep;
        }
    }

    protected final void setBatchParameters(int parameterID) {
        ArrayList<Object> parametersListAux = this.parametersList[parameterID];
        this.ratio = (Integer)parametersListAux.get(0);
        this.k = (Integer)parametersListAux.get(1);
        this.oversamplingThreshold = (float)((Integer)parametersListAux.get(2)).intValue() / 100.0f;
        this.positiveThreshold = (float)((Integer)parametersListAux.get(3)).intValue() / 100.0f;
        this.negativeThreshold = (float)((Integer)parametersListAux.get(4)).intValue() / 100.0f;
        this.clean = (Boolean)parametersListAux.get(5);
        this.computeProportion(this.instanceSet);
    }

    protected void computeProportion(InstanceSet instanceSet) {
        float[] originalDist = instanceSet.getClassDistribution(true);
        this.proportion = originalDist[this.negativeClass] * (float)this.ratio;
        this.proportion /= (double)(originalDist[this.positiveClass] * (float)(100 - this.ratio));
    }

    public final String parametersToString(int parameterID) {
        String result = "";
        if (this.useRatio) {
            result = String.valueOf(result) + "PosFreq: " + this.ratio;
        }
        result = String.valueOf(result) + "\t";
        if (this.useK) {
            result = String.valueOf(result) + "k: " + this.k;
        }
        result = String.valueOf(result) + "\t";
        if (this.useOverThresh) {
            result = String.valueOf(result) + "Over ";
            result = this.autoOversamplingThreshold ? String.valueOf(result) + this.oversamplingThreshold * this.instanceSet.getClassFrequency(this.positiveClass) : String.valueOf(result) + this.oversamplingThreshold;
        }
        result = String.valueOf(result) + "\t";
        if (this.usePosThresh) {
            result = String.valueOf(result) + "Pos " + this.positiveThreshold;
        }
        result = String.valueOf(result) + "\t";
        if (this.useNegThresh) {
            result = String.valueOf(result) + "Neg " + this.negativeThreshold;
        }
        result = String.valueOf(result) + "\t";
        if (this.useCleaning) {
            result = String.valueOf(result) + "Clean: " + this.clean;
        }
        return result;
    }

    public final String getPreprocessorName() {
        return this.preprocessorName;
    }
}

