/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.preprocessor;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class PreprocessorParameters {
    private float sampleSize;
    private boolean compact;
    private boolean canceled = false;
    private int classIndex = -1;

    public PreprocessorParameters(Component parent, InstanceSet inst, boolean size) {
        JTextField sizeField = new JTextField();
        JLabel sizeLabel = null;
        sizeLabel = size ? new JLabel("Size") : new JLabel("Proportion");
        JComboBox<String> attributesComboBox = new JComboBox<String>();
        attributesComboBox.setMaximumRowCount(5);
        attributesComboBox.addItem("None");
        int numAttributes = inst.numAttributes();
        int i = 0;
        while (i < numAttributes) {
            Attribute aux = inst.getAttribute(i);
            attributesComboBox.addItem(aux.getAttributeName());
            ++i;
        }
        JLabel classLabel = new JLabel("Class");
        JCheckBox compactCheckBox = new JCheckBox();
        JLabel compactLabel = new JLabel("Compact");
        JPanel panel = new JPanel(new GridLayout(3, 3));
        panel.add((Component)sizeLabel, null);
        panel.add((Component)sizeField, null);
        panel.add((Component)compactLabel, null);
        panel.add((Component)compactCheckBox, null);
        panel.add((Component)classLabel, null);
        panel.add(attributesComboBox, null);
        if (JOptionPane.showInternalConfirmDialog(parent, panel, "", 2) == 0) {
            int selectedAttribute = attributesComboBox.getSelectedIndex();
            if (selectedAttribute != 0) {
                this.classIndex = selectedAttribute - 1;
            }
            this.sampleSize = Float.parseFloat(sizeField.getText());
            this.compact = compactCheckBox.isSelected();
        } else {
            this.canceled = true;
        }
    }

    public float getSampleSize() {
        return this.sampleSize;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getClassIndex() {
        return this.classIndex;
    }
}

