/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.preprocessor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.AttributeStats;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Stats;
import unbbayes.datamining.gui.preprocessor.AttributeSelectionPanel;
import unbbayes.datamining.gui.preprocessor.DiscretizationPanel;
import unbbayes.datamining.gui.preprocessor.PreprocessorMain;
import unbbayes.util.GraphPaperLayout;

public class PreprocessPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private JPanel filePanel = new JPanel();
    private AttributeSelectionPanel attributePanel = new AttributeSelectionPanel();
    private JLabel jLabel6 = new JLabel();
    private JLabel jLabel5 = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private BorderLayout borderLayout9 = new BorderLayout();
    private BorderLayout borderLayout8 = new BorderLayout();
    private BorderLayout borderLayout7 = new BorderLayout();
    private BorderLayout borderLayout6 = new BorderLayout();
    private BorderLayout borderLayout5 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout13 = new BorderLayout();
    private BorderLayout borderLayout12 = new BorderLayout();
    private BorderLayout borderLayout11 = new BorderLayout();
    private BorderLayout borderLayout10 = new BorderLayout();
    private JPanel jPanel23 = new JPanel();
    private JPanel jPanel22 = new JPanel();
    private JPanel jPanel21 = new JPanel();
    private JPanel jPanel20 = new JPanel();
    private JPanel jPanel19 = new JPanel();
    private JPanel jPanel18 = new JPanel();
    private JPanel jPanel13 = new JPanel();
    private JPanel jPanel12 = new JPanel();
    private JPanel jPanel11 = new JPanel();
    private JPanel jPanel10 = new JPanel();
    private GridLayout gridLayout3 = new GridLayout();
    private GridLayout gridLayout2 = new GridLayout();
    private BorderLayout borderLayout32 = new BorderLayout();
    private BorderLayout borderLayout31 = new BorderLayout();
    private BorderLayout borderLayout30 = new BorderLayout();
    private JPanel jPanel40 = new JPanel();
    private JPanel attributeInformationPanel = new JPanel();
    private BorderLayout borderLayout29 = new BorderLayout();
    private BorderLayout borderLayout28 = new BorderLayout();
    private BorderLayout borderLayout27 = new BorderLayout();
    private BorderLayout borderLayout26 = new BorderLayout();
    private BorderLayout borderLayout25 = new BorderLayout();
    private BorderLayout borderLayout24 = new BorderLayout();
    private BorderLayout borderLayout23 = new BorderLayout();
    private BorderLayout borderLayout22 = new BorderLayout();
    private JPanel jPanel39 = new JPanel();
    private BorderLayout borderLayout21 = new BorderLayout();
    private JPanel jPanel38 = new JPanel();
    private JPanel jPanel37 = new JPanel();
    private JLabel jLabel9 = new JLabel();
    private JPanel jPanel36 = new JPanel();
    private JPanel jPanel35 = new JPanel();
    private JPanel jPanel34 = new JPanel();
    private JPanel jPanel33 = new JPanel();
    private JPanel jPanel32 = new JPanel();
    private JPanel jPanel31 = new JPanel();
    private JPanel jPanel30 = new JPanel();
    private BorderLayout borderLayout17 = new BorderLayout();
    private JPanel jPanel29 = new JPanel();
    private JPanel jPanel28 = new JPanel();
    private JPanel jPanel27 = new JPanel();
    private JLabel jLabel16 = new JLabel();
    private JLabel jLabel15 = new JLabel();
    private JLabel jLabel14 = new JLabel();
    private JLabel jLabel13 = new JLabel();
    private JLabel jLabel12 = new JLabel();
    private JLabel jLabel11 = new JLabel();
    private JLabel jLabel10 = new JLabel();
    private GridLayout gridLayout5 = new GridLayout();
    private ButtonGroup buttonGroup2 = new ButtonGroup();
    private TitledBorder titledBorder4;
    private TitledBorder titledBorder3;
    private TitledBorder titledBorder2;
    private TitledBorder titledBorder1;
    private Border border1;
    private InstanceSet instances;
    private JScrollPane jScrollPane2 = new JScrollPane();
    private BorderLayout borderLayout35 = new BorderLayout();
    private JTable jTable1 = new JTable();
    private JPanel numericAttributePanel = new JPanel();
    private PreprocessorMain reference;
    private GridLayout gridLayout4 = new GridLayout();
    private JPanel jPanel14 = new JPanel();
    private JButton discretizeButton = new JButton();
    private int selectedAttribute;
    private GridLayout gridLayout6 = new GridLayout();
    private GraphPaperLayout gridLayout1 = new GraphPaperLayout(new Dimension(6, 6));
    private AttributeStats[] attributeStats;

    public PreprocessPanel(PreprocessorMain reference) {
        this.reference = reference;
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.preprocessor.resources.PreprocessorResource");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder4 = new TitledBorder(this.border1, this.resource.getString("continuousAttributes"));
        this.titledBorder3 = new TitledBorder(this.border1, this.resource.getString("attributeInfo"));
        this.titledBorder2 = new TitledBorder(this.border1, this.resource.getString("fileAttributes"));
        this.titledBorder1 = new TitledBorder(this.border1, this.resource.getString("file"));
        this.border1 = BorderFactory.createLineBorder(new Color(153, 153, 153), 1);
        this.filePanel.setLayout(this.gridLayout2);
        this.jLabel6.setText(this.resource.getString("attributes"));
        this.jLabel5.setText(this.resource.getString("instances"));
        this.jLabel4.setText(this.resource.getString("none"));
        this.jLabel3.setText(this.resource.getString("none"));
        this.jLabel2.setText(this.resource.getString("none"));
        this.jLabel1.setText(this.resource.getString("relation"));
        this.jPanel23.setLayout(this.borderLayout13);
        this.jPanel22.setLayout(this.borderLayout12);
        this.jPanel21.setLayout(this.borderLayout11);
        this.jPanel20.setLayout(this.borderLayout10);
        this.jPanel19.setLayout(this.borderLayout9);
        this.jPanel18.setLayout(this.borderLayout8);
        this.jPanel13.setLayout(this.borderLayout7);
        this.jPanel12.setLayout(this.borderLayout6);
        this.jPanel11.setLayout(this.borderLayout5);
        this.jPanel10.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(2);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setVgap(3);
        this.setLayout(this.gridLayout1);
        this.jPanel40.setLayout(this.borderLayout27);
        this.attributeInformationPanel.setLayout(this.borderLayout17);
        this.jPanel39.setLayout(this.borderLayout28);
        this.jPanel38.setLayout(this.borderLayout29);
        this.jPanel37.setLayout(this.borderLayout30);
        this.jLabel9.setText(this.resource.getString("name"));
        this.jPanel36.setLayout(this.borderLayout32);
        this.jPanel35.setLayout(this.borderLayout31);
        this.jPanel34.setLayout(this.borderLayout26);
        this.jPanel33.setLayout(this.borderLayout25);
        this.jPanel32.setLayout(this.borderLayout22);
        this.jPanel31.setLayout(this.borderLayout23);
        this.jPanel30.setLayout(this.borderLayout24);
        this.jPanel29.setLayout(this.borderLayout21);
        this.jPanel28.setLayout(this.gridLayout5);
        this.jLabel16.setText(this.resource.getString("distinct"));
        this.jLabel15.setText(this.resource.getString("none"));
        this.jLabel14.setText(this.resource.getString("missing"));
        this.jLabel13.setText(this.resource.getString("none"));
        this.jLabel12.setText(this.resource.getString("none"));
        this.jLabel11.setText(this.resource.getString("type"));
        this.jLabel10.setText(this.resource.getString("none"));
        this.gridLayout5.setRows(2);
        this.gridLayout5.setColumns(2);
        this.filePanel.setBorder(this.titledBorder1);
        this.attributePanel.setBorder(this.titledBorder2);
        this.attributeInformationPanel.setBorder(this.titledBorder3);
        this.jPanel27.setLayout(this.borderLayout35);
        this.numericAttributePanel.setLayout(this.gridLayout4);
        this.discretizeButton.setEnabled(false);
        this.discretizeButton.setText(this.resource.getString("discretizeAttribute"));
        this.discretizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.discretizeButton_actionPerformed(e);
            }
        });
        this.numericAttributePanel.setBorder(this.titledBorder4);
        this.jScrollPane2.setBorder(null);
        this.attributePanel.setToolTipText(this.resource.getString("selectedAttributes"));
        this.gridLayout6.setColumns(2);
        this.jPanel13.add((Component)this.jPanel22, "Center");
        this.jPanel22.add((Component)this.jLabel3, "Center");
        this.jPanel13.add((Component)this.jPanel23, "West");
        this.jPanel23.add((Component)this.jLabel6, "Center");
        this.jPanel10.add((Component)this.jPanel12, null);
        this.jPanel12.add((Component)this.jPanel20, "Center");
        this.jPanel20.add((Component)this.jLabel2, "Center");
        this.jPanel12.add((Component)this.jPanel21, "West");
        this.jPanel21.add((Component)this.jLabel5, "Center");
        this.jPanel10.add((Component)this.jPanel13, null);
        this.filePanel.add((Component)this.jPanel11, null);
        this.jPanel11.add((Component)this.jPanel18, "West");
        this.jPanel18.add((Component)this.jLabel1, "Center");
        this.jPanel11.add((Component)this.jPanel19, "Center");
        this.jPanel19.add((Component)this.jLabel4, "Center");
        this.filePanel.add((Component)this.jPanel10, null);
        this.attributeInformationPanel.add((Component)this.jPanel27, "Center");
        this.jPanel27.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.jTable1, null);
        this.attributeInformationPanel.add((Component)this.jPanel28, "North");
        this.jPanel29.add((Component)this.jPanel33, "West");
        this.jPanel33.add((Component)this.jLabel9, "Center");
        this.jPanel29.add((Component)this.jPanel34, "Center");
        this.jPanel34.add((Component)this.jLabel10, "Center");
        this.jPanel28.add((Component)this.jPanel32, null);
        this.jPanel28.add((Component)this.jPanel29, null);
        this.jPanel32.add((Component)this.jPanel35, "West");
        this.jPanel35.add((Component)this.jLabel11, "Center");
        this.jPanel32.add((Component)this.jPanel36, "Center");
        this.jPanel36.add((Component)this.jLabel12, "Center");
        this.jPanel28.add((Component)this.jPanel31, null);
        this.jPanel31.add((Component)this.jPanel37, "Center");
        this.jPanel37.add((Component)this.jLabel13, "Center");
        this.jPanel31.add((Component)this.jPanel38, "West");
        this.jPanel38.add((Component)this.jLabel14, "Center");
        this.jPanel28.add((Component)this.jPanel30, null);
        this.jPanel30.add((Component)this.jPanel39, "Center");
        this.jPanel39.add((Component)this.jLabel15, "Center");
        this.jPanel30.add((Component)this.jPanel40, "West");
        this.jPanel40.add((Component)this.jLabel16, "Center");
        this.numericAttributePanel.add((Component)this.jPanel14, null);
        this.jPanel14.add((Component)this.discretizeButton, null);
        this.jTable1.setSelectionMode(0);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().setResizingAllowed(false);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setRowSelectionAllowed(false);
        this.attributePanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PreprocessPanel.this.jPanel8_valueChanged(e);
            }
        });
        this.add((Component)this.filePanel, new Rectangle(0, 0, 3, 1));
        this.add((Component)this.attributePanel, new Rectangle(0, 1, 3, 5));
        this.add((Component)this.numericAttributePanel, new Rectangle(3, 0, 3, 1));
        this.add((Component)this.attributeInformationPanel, new Rectangle(3, 1, 3, 5));
    }

    public void setBaseInstances(InstanceSet inst) {
        this.instances = inst;
        this.setTable(null, 0);
        this.jLabel4.setText(inst.getRelationName());
        this.jLabel2.setText(String.valueOf(inst.numWeightedInstances()));
        this.jLabel3.setText(String.valueOf(inst.numAttributes()));
        this.attributeStats = inst.getAttributeStats();
        this.attributePanel.setInstances(this.instances);
    }

    protected void setTable(AttributeStats as, int index) {
        if (as == null) {
            this.jTable1.setModel(new ValuesTableModel());
        } else {
            if (as.getNumericStats() != null) {
                Object[] colNames = new Object[]{this.resource.getString("statistic"), this.resource.getString("value")};
                Object[][] data = new Object[4][2];
                Stats stats = as.getNumericStats();
                data[0][0] = this.resource.getString("minimum");
                data[0][1] = new Float(stats.getMin());
                data[1][0] = this.resource.getString("maximum");
                data[1][1] = new Float(stats.getMax());
                data[2][0] = this.resource.getString("mean");
                data[2][1] = new Float((float)stats.getMean());
                data[3][0] = this.resource.getString("stdDev");
                data[3][1] = new Float((float)stats.getStdDev());
                this.jTable1.setModel(new ValuesTableModel(data, colNames));
                return;
            }
            if (as.getNominalCountsWeighted() != null) {
                Attribute att = this.instances.getAttribute(index);
                Object[] colNames = new Object[]{this.resource.getString("label"), this.resource.getString("count")};
                Object[][] data = new Object[as.getNominalCounts().length][2];
                int i = 0;
                while (i < as.getNominalCountsWeighted().length) {
                    data[i][0] = att.value(i);
                    data[i][1] = new Float(as.getNominalCountsWeighted()[i]);
                    ++i;
                }
                this.jTable1.setModel(new ValuesTableModel(data, colNames));
            } else {
                this.jTable1.setModel(new ValuesTableModel());
            }
        }
    }

    void jPanel8_valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel lm = (ListSelectionModel)e.getSource();
            int i = e.getFirstIndex();
            while (i <= e.getLastIndex()) {
                if (lm.isSelectedIndex(i)) {
                    try {
                        this.selectedAttribute = i;
                        Attribute att = this.instances.getAttribute(this.selectedAttribute);
                        byte type = att.getAttributeType();
                        if (type == 1) {
                            this.jLabel12.setText(this.resource.getString("nominal"));
                            this.discretizeButton.setEnabled(false);
                        } else {
                            this.jLabel12.setText(this.resource.getString("numeric"));
                            this.discretizeButton.setEnabled(true);
                        }
                        this.jLabel10.setText(att.getAttributeName());
                        AttributeStats attStats = this.attributeStats[this.selectedAttribute];
                        long percent = Math.round(100.0 * (double)attStats.getMissingCountWeighted() / (double)this.instances.numWeightedInstances());
                        this.jLabel13.setText(attStats.getMissingCountWeighted() + " (" + percent + "%)");
                        this.jLabel15.setText("" + attStats.getDistinctCount());
                        this.setTable(attStats, this.selectedAttribute);
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                ++i;
            }
        }
    }

    void discretizeButton_actionPerformed(ActionEvent e) {
        new DiscretizationPanel(this.reference, this.instances, this.instances.getAttribute(this.selectedAttribute));
    }

    public AttributeSelectionPanel getAttributePanel() {
        return this.attributePanel;
    }

    private class ValuesTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 0L;

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public ValuesTableModel() {
        }

        public ValuesTableModel(Object[][] data, Object[] colNames) {
            super(data, colNames);
        }
    }
}

