/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.preprocessor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.discretize.FrequencyDiscretization;
import unbbayes.datamining.discretize.RangeDiscretization;
import unbbayes.datamining.gui.preprocessor.PreprocessorMain;

public class DiscretizationPanel {
    private JComboBox numberStatesComboBox;
    private JComboBox discretizationTypeComboBox;

    public DiscretizationPanel(PreprocessorMain reference, InstanceSet inst, Attribute selectedAttribute) {
        if (JOptionPane.showInternalConfirmDialog(reference, this.buildPanel(), "Discretization " + selectedAttribute.getAttributeName(), 2) == 0) {
            if (this.discretizationTypeComboBox.getSelectedIndex() == 0) {
                RangeDiscretization range = new RangeDiscretization(inst);
                try {
                    range.discretizeAttribute(selectedAttribute, this.numberStatesComboBox.getSelectedIndex() + 1);
                    reference.updateInstances(range.getInstances());
                    reference.setStatusBar("Range discretization successful");
                }
                catch (Exception ex) {
                    reference.setStatusBar(ex.getMessage());
                }
            } else if (this.discretizationTypeComboBox.getSelectedIndex() == 1) {
                FrequencyDiscretization freq = new FrequencyDiscretization(inst);
                try {
                    freq.discretizeAttribute(selectedAttribute, this.numberStatesComboBox.getSelectedIndex() + 1);
                    reference.updateInstances(freq.getInstances());
                    reference.setStatusBar("Frequency discretization successful");
                }
                catch (Exception ex) {
                    reference.setStatusBar(ex.getMessage());
                }
            }
        }
    }

    private JPanel buildPanel() {
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JLabel numberStatesLabel = new JLabel("Number of States :");
        jPanel5.add((Component)numberStatesLabel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.numberStatesComboBox = new JComboBox();
        this.numberStatesComboBox.setMaximumRowCount(5);
        int i = 0;
        while (i < 100) {
            this.numberStatesComboBox.addItem(String.valueOf(i + 1));
            ++i;
        }
        jPanel4.add((Component)this.numberStatesComboBox, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel discretizationTypeLabel = new JLabel("Discretization Type :");
        jPanel3.add((Component)discretizationTypeLabel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.discretizationTypeComboBox = new JComboBox();
        this.discretizationTypeComboBox.addItem("Range");
        this.discretizationTypeComboBox.addItem("Frequency");
        jPanel2.add((Component)this.discretizationTypeComboBox, "Center");
        JPanel discretizationPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        discretizationPanel.add((Component)jPanel3, null);
        discretizationPanel.add((Component)jPanel2, null);
        discretizationPanel.add((Component)jPanel5, null);
        discretizationPanel.add((Component)jPanel4, null);
        return discretizationPanel;
    }
}

