/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralnetwork;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel labelMomentum = new JLabel();
    private JComboBox comboActivationFunction = new JComboBox();
    private JLabel labelActivationFunction = new JLabel();
    private JPanel panelOptions = new JPanel();
    private JLabel labelLearningRate = new JLabel();
    private JPanel panelActivationFunction = new JPanel();
    private SpinnerNumberModel learningRateSpinnerModel = new SpinnerNumberModel(0.3, 0.01, 1.0, 0.01);
    private SpinnerNumberModel momentumSpinnerModel = new SpinnerNumberModel(0.2, 0.0, 1.0, 0.01);
    private JSpinner spinnerLearningRate = new JSpinner();
    private JSpinner spinnerMomentum = new JSpinner();
    private JPanel panelLearningRate = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel panelMomentum = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public OptionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralnetwork.resources.NeuralNetworkResource");
        this.panelOptions.setBorder(BorderFactory.createEtchedBorder());
        this.panelOptions.setLayout(this.gridBagLayout1);
        this.labelActivationFunction.setText(String.valueOf(this.resource.getString("activationFunctionLabel")) + ":");
        this.labelActivationFunction.setVerticalAlignment(3);
        this.labelMomentum.setText(String.valueOf(this.resource.getString("momentumLabel")) + ":");
        this.labelMomentum.setVerticalAlignment(3);
        this.setLayout(this.borderLayout1);
        this.labelLearningRate.setVerifyInputWhenFocusTarget(true);
        this.labelLearningRate.setText(String.valueOf(this.resource.getString("learningRateLabel")) + ":");
        this.labelLearningRate.setVerticalAlignment(3);
        this.borderLayout1.setHgap(3);
        this.borderLayout1.setVgap(0);
        this.spinnerLearningRate.setModel(this.learningRateSpinnerModel);
        this.spinnerLearningRate.setBorder(null);
        this.spinnerLearningRate.setDebugGraphicsOptions(0);
        this.spinnerMomentum.setModel(this.momentumSpinnerModel);
        this.spinnerMomentum.setBorder(null);
        this.spinnerMomentum.setDebugGraphicsOptions(0);
        this.panelLearningRate.setLayout(this.borderLayout2);
        this.panelMomentum.setLayout(this.borderLayout3);
        this.panelActivationFunction.setLayout(this.borderLayout4);
        this.panelActivationFunction.add((Component)this.comboActivationFunction, "Center");
        this.panelActivationFunction.add((Component)this.labelActivationFunction, "North");
        this.add((Component)this.panelOptions, "Center");
        this.panelLearningRate.add((Component)this.labelLearningRate, "North");
        this.panelLearningRate.add((Component)this.spinnerLearningRate, "Center");
        this.panelOptions.add((Component)this.panelLearningRate, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 67, 0));
        this.panelOptions.add((Component)this.panelMomentum, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 83, 0));
        this.panelOptions.add((Component)this.panelActivationFunction, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 42, 0));
        this.panelMomentum.add((Component)this.labelMomentum, "North");
        this.panelMomentum.add((Component)this.spinnerMomentum, "Center");
        this.comboActivationFunction.insertItemAt(this.resource.getString("sigmoid"), 0);
        this.comboActivationFunction.insertItemAt(this.resource.getString("tanh"), 1);
        this.setEnabled(false);
        this.comboActivationFunction.setSelectedIndex(0);
    }

    public void setEnabled(boolean enable) {
        this.spinnerLearningRate.setEnabled(enable);
        this.spinnerMomentum.setEnabled(enable);
        this.comboActivationFunction.setEnabled(enable);
    }

    public float getLearningRate() throws NumberFormatException {
        return Float.parseFloat(this.spinnerLearningRate.getValue().toString());
    }

    public float getMomentum() throws NumberFormatException {
        return Float.parseFloat(this.spinnerMomentum.getValue().toString());
    }

    public int getSelectedActivationFunction() {
        if (this.comboActivationFunction.getSelectedIndex() == 0) {
            return 0;
        }
        if (this.comboActivationFunction.getSelectedIndex() == 1) {
            return 1;
        }
        return 0;
    }
}

