/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralnetwork;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.IconController;
import unbbayes.datamining.gui.AttributePanel;
import unbbayes.datamining.gui.neuralnetwork.AdvancedOptionsPanel;
import unbbayes.datamining.gui.neuralnetwork.InferencePanel;
import unbbayes.datamining.gui.neuralnetwork.NeuralNetworkController;
import unbbayes.datamining.gui.neuralnetwork.OptionsPanel;
import unbbayes.datamining.gui.neuralnetwork.TrainingPanel;

public class NeuralNetworkMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private JToolBar toolBar = new JToolBar();
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private JLabel label3 = new JLabel();
    private JButton openButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton openModelButton = new JButton();
    private JButton helpButton = new JButton();
    private JButton learnButton = new JButton();
    private ImageIcon openIcon;
    private ImageIcon openModelIcon;
    private ImageIcon compileIcon;
    private ImageIcon helpIcon;
    private ImageIcon saveIcon;
    private ImageIcon advancedOptionsIcon;
    private IconController iconController = IconController.getInstance();
    private JPanel jPanel1 = new JPanel();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JLabel statusBar = new JLabel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JPanel statusPanel = new JPanel();
    private Border border1;
    private TitledBorder titledBorder1;
    private JPanel settingsPanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private NeuralNetworkController controller;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem openMenu = new JMenuItem();
    private JMenuItem openModelMenu = new JMenuItem();
    private JMenuItem saveModelMenu = new JMenuItem();
    private JMenuItem exitMenu = new JMenuItem();
    private JMenu optionsMenu = new JMenu();
    private JMenuItem trainingMenu = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpTopicsMenu = new JMenuItem();
    private JButton advancedOptionsButton = new JButton();
    private JMenuItem advancedOptionsMenu = new JMenuItem();
    protected AttributePanel attributePanel = new AttributePanel();
    protected TrainingPanel chartPanel = new TrainingPanel();
    protected InferencePanel inferencePanel = new InferencePanel();
    protected OptionsPanel optionsPanel = new OptionsPanel();
    protected AdvancedOptionsPanel advancedOptionsPanel = new AdvancedOptionsPanel();

    public NeuralNetworkMain() {
        super("Neural Network", true, true, true, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralnetwork.resources.NeuralNetworkResource");
        this.openIcon = this.iconController.getOpenIcon();
        this.openModelIcon = this.iconController.getOpenModelIcon();
        this.compileIcon = this.iconController.getCompileIcon();
        this.helpIcon = this.iconController.getHelpIcon();
        this.saveIcon = this.iconController.getSaveIcon();
        this.advancedOptionsIcon = this.iconController.getGlobalOptionIcon();
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Status");
        this.openButton.setIcon(this.openIcon);
        this.saveButton.setIcon(this.saveIcon);
        this.openModelButton.setIcon(this.openModelIcon);
        this.helpButton.setIcon(this.helpIcon);
        this.learnButton.setIcon(this.compileIcon);
        this.toolBar.setFloatable(false);
        this.label1.setText("   ");
        this.label2.setText("   ");
        this.label3.setText("   ");
        this.openButton.setToolTipText(this.resource.getString("openFileToolTip"));
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.open_actionPerformed(e);
            }
        });
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(this.resource.getString("saveModelToolTip"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.saveModel_actionPerformed(e);
            }
        });
        this.openModelButton.setToolTipText(this.resource.getString("openModelToolTip"));
        this.openModelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.openModel_actionPerformed(e);
            }
        });
        this.helpButton.setToolTipText(this.resource.getString("helpFileTooltip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.help_actionPerformed(e);
            }
        });
        this.learnButton.setEnabled(false);
        this.learnButton.setToolTipText(this.resource.getString("learnDataTooltip"));
        this.learnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.learn_actionPerformed(e);
            }
        });
        this.statusBar.setText(this.resource.getString("welcome"));
        this.statusPanel.setLayout(this.borderLayout5);
        this.statusPanel.setBorder(this.titledBorder1);
        this.jPanel1.setLayout(this.borderLayout1);
        this.settingsPanel.setLayout(this.borderLayout2);
        this.borderLayout2.setHgap(4);
        this.attributePanel.setBorder(BorderFactory.createEtchedBorder());
        this.fileMenu.setText(this.resource.getString("fileMenu"));
        this.openMenu.setIcon(this.openIcon);
        this.openMenu.setText(this.resource.getString("openMenu"));
        this.openMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.open_actionPerformed(e);
            }
        });
        this.openModelMenu.setIcon(this.openModelIcon);
        this.openModelMenu.setText(this.resource.getString("openModelMenu"));
        this.openModelMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.openModel_actionPerformed(e);
            }
        });
        this.saveModelMenu.setEnabled(false);
        this.saveModelMenu.setIcon(this.saveIcon);
        this.saveModelMenu.setText(this.resource.getString("saveModelMenu"));
        this.saveModelMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.saveModel_actionPerformed(e);
            }
        });
        this.exitMenu.setText(this.resource.getString("exitMenu"));
        this.exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.exitMenu_actionPerformed(e);
            }
        });
        this.optionsMenu.setEnabled(false);
        this.optionsMenu.setIcon(null);
        this.optionsMenu.setText(this.resource.getString("optionsMenu"));
        this.trainingMenu.setIcon(this.compileIcon);
        this.trainingMenu.setText(this.resource.getString("learnMenu"));
        this.trainingMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.learn_actionPerformed(e);
            }
        });
        this.helpMenu.setText(this.resource.getString("helpMenu"));
        this.helpTopicsMenu.setIcon(this.helpIcon);
        this.helpTopicsMenu.setText(this.resource.getString("helpTopicsMenu"));
        this.helpTopicsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.help_actionPerformed(e);
            }
        });
        this.advancedOptionsButton.setEnabled(false);
        this.advancedOptionsButton.setToolTipText(this.resource.getString("advancedOptionsToolTip"));
        this.advancedOptionsButton.setIcon(this.advancedOptionsIcon);
        this.advancedOptionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.advancedOptions_actionPerformed(e);
            }
        });
        this.advancedOptionsMenu.setEnabled(true);
        this.advancedOptionsMenu.setIcon(this.advancedOptionsIcon);
        this.advancedOptionsMenu.setText(this.resource.getString("advancedOptionsMenu"));
        this.advancedOptionsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralNetworkMain.this.advancedOptions_actionPerformed(e);
            }
        });
        this.toolBar.add((Component)this.openButton, null);
        this.toolBar.add((Component)this.learnButton, null);
        this.toolBar.add((Component)this.label1, null);
        this.toolBar.add((Component)this.advancedOptionsButton, null);
        this.toolBar.add((Component)this.label2, null);
        this.toolBar.add((Component)this.openModelButton, null);
        this.toolBar.add((Component)this.saveButton, null);
        this.toolBar.add((Component)this.label3, null);
        this.toolBar.add((Component)this.helpButton, null);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.settingsPanel, this.resource.getString("settingsPanel"));
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusBar, "Center");
        this.settingsPanel.add((Component)this.optionsPanel, "West");
        this.settingsPanel.add((Component)this.attributePanel, "Center");
        this.jTabbedPane1.add((Component)this.chartPanel, this.resource.getString("chartPanel"));
        this.jTabbedPane1.add((Component)this.inferencePanel, this.resource.getString("inferencePanel"));
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.optionsMenu);
        this.jMenuBar1.add(this.helpMenu);
        this.fileMenu.add(this.openMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openModelMenu);
        this.fileMenu.add(this.saveModelMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenu);
        this.optionsMenu.add(this.trainingMenu);
        this.optionsMenu.add(this.advancedOptionsMenu);
        this.helpMenu.add(this.helpTopicsMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.jTabbedPane1.setEnabledAt(2, false);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    public void setController(NeuralNetworkController controller) {
        this.controller = controller;
    }

    void help_actionPerformed(ActionEvent e) {
        try {
            this.controller.help();
        }
        catch (Exception evt) {
            this.statusBar.setText("Error = " + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    void learn_actionPerformed(ActionEvent e) {
        this.jTabbedPane1.setEnabledAt(0, false);
        this.jTabbedPane1.setEnabledAt(1, true);
        this.jTabbedPane1.setSelectedIndex(1);
        this.jTabbedPane1.setEnabledAt(2, true);
        this.saveButton.setEnabled(true);
        this.saveModelMenu.setEnabled(true);
        this.learnButton.setEnabled(false);
        this.advancedOptionsButton.setEnabled(false);
        this.optionsMenu.setEnabled(false);
        try {
            this.controller.learn();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.statusBar.setText(String.valueOf(this.resource.getString("exception")) + " " + ex.getMessage());
            this.jTabbedPane1.setEnabledAt(0, true);
            this.jTabbedPane1.setEnabledAt(1, false);
            this.jTabbedPane1.setSelectedIndex(0);
            this.jTabbedPane1.setEnabledAt(2, false);
            this.saveButton.setEnabled(false);
            this.saveModelMenu.setEnabled(false);
            this.learnButton.setEnabled(true);
            this.advancedOptionsButton.setEnabled(true);
            this.optionsMenu.setEnabled(true);
        }
    }

    void open_actionPerformed(ActionEvent e) {
        try {
            boolean success = this.controller.openFile();
            if (success) {
                this.jTabbedPane1.setEnabledAt(0, false);
                this.optionsPanel.setEnabled(true);
                this.jTabbedPane1.setEnabledAt(0, true);
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.setEnabledAt(1, false);
                this.jTabbedPane1.setEnabledAt(2, false);
                this.learnButton.setEnabled(true);
                this.advancedOptionsButton.setEnabled(true);
                this.optionsMenu.setEnabled(true);
                this.saveButton.setEnabled(false);
                this.saveModelMenu.setEnabled(false);
                this.statusBar.setText(this.resource.getString("openFileSuccess"));
                this.chartPanel.clear();
            }
        }
        catch (NullPointerException npe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorDB")) + " " + npe.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + " " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + " " + ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.statusBar.setText(String.valueOf(this.resource.getString("error")) + ex.getMessage());
        }
    }

    void saveModel_actionPerformed(ActionEvent e) {
        try {
            boolean success = this.controller.saveModel();
            if (success) {
                this.statusBar.setText(this.resource.getString("saveModelSuccess"));
            }
        }
        catch (Exception ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFileException")) + " " + ioe.getMessage());
        }
    }

    void openModel_actionPerformed(ActionEvent e) {
        try {
            boolean success = this.controller.openModel();
            if (success) {
                this.jTabbedPane1.setEnabledAt(0, false);
                this.jTabbedPane1.setEnabledAt(1, false);
                this.jTabbedPane1.setEnabledAt(2, true);
                this.jTabbedPane1.setSelectedIndex(2);
                this.learnButton.setEnabled(false);
                this.advancedOptionsButton.setEnabled(false);
                this.optionsMenu.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.saveModelMenu.setEnabled(false);
                this.statusBar.setText(this.resource.getString("modelOpenSuccess"));
                this.jTabbedPane1.setSelectedIndex(2);
                this.chartPanel.clear();
            }
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFileException")) + " " + ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            this.statusBar.setText(cnfe.getMessage());
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
        }
    }

    void exitMenu_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void advancedOptions_actionPerformed(ActionEvent e) {
        this.advancedOptionsPanel.sethiddenLayerSize(this.controller.getHiddenLayerSize());
        this.hide();
        int options = JOptionPane.showInternalOptionDialog(this, this.advancedOptionsPanel, this.resource.getString("advancedOptionsTitle"), 2, -1, null, null, null);
        if (options == 0) {
            this.advancedOptionsPanel.updateValues();
        }
        this.show();
    }
}

