/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import unbbayes.controller.IconController;
import unbbayes.datamining.classifiers.CombinatorialNeuralModel;
import unbbayes.datamining.classifiers.cnmentities.Combination;
import unbbayes.datamining.classifiers.cnmentities.OutputNeuron;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.gui.neuralmodel.NeuralModelController;

public class RulesPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private ImageIcon printIcon;
    private ImageIcon printPreviewIcon;
    private ResourceBundle resource;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTable tableRules;
    private CombinatorialNeuralModel combinatorialNetwork;
    private ArrayList<TableLine> tableLinesArray;
    private Attribute[] attributeVector;
    private int classIndex;
    private Object[] longValues = new Object[6];
    private RulesTableModel rulesTableModel;
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel2 = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private JLabel labelMinSupport = new JLabel();
    private JComboBox comboMinConfidence = new JComboBox();
    private JLabel labelMinConfidence = new JLabel();
    private JComboBox comboMinSupport = new JComboBox();
    private JPanel jPanel3 = new JPanel();
    private JButton printButton = new JButton();
    private JButton previewButton = new JButton();
    private GridLayout gridLayout2 = new GridLayout();
    private NeuralModelController controller;
    protected IconController iconController = IconController.getInstance();

    public RulesPanel(NeuralModelController controller) {
        this();
        this.setController(controller);
    }

    private RulesPanel() {
        try {
            this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralmodel.resources.NeuralModelResource");
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.printIcon = this.iconController.getPrintTableIcon();
        this.printPreviewIcon = this.iconController.getPrintPreviewTableIcon();
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(5);
        this.gridLayout1.setHgap(5);
        this.labelMinSupport.setHorizontalAlignment(4);
        this.labelMinSupport.setText(this.resource.getString("minimumSupport"));
        this.labelMinConfidence.setHorizontalAlignment(4);
        this.labelMinConfidence.setText(this.resource.getString("minimumConfidence"));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.comboMinSupport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesPanel.this.combo_actionPerformed(e);
            }
        });
        this.comboMinConfidence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesPanel.this.combo_actionPerformed(e);
            }
        });
        this.printButton.setIcon(this.printIcon);
        this.printButton.setToolTipText(this.resource.getString("printTableToolTip"));
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesPanel.this.printButton_actionPerformed(e);
            }
        });
        this.previewButton.setIcon(this.printPreviewIcon);
        this.previewButton.setToolTipText(this.resource.getString("previewTableToolTip"));
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesPanel.this.previewButton_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setHgap(4);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.labelMinSupport, null);
        this.jPanel2.add((Component)this.comboMinSupport, null);
        this.jPanel2.add((Component)this.labelMinConfidence, null);
        this.jPanel2.add((Component)this.comboMinConfidence, null);
        this.jPanel2.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.previewButton, null);
        this.jPanel3.add((Component)this.printButton, null);
        int i = 0;
        while (i < 101) {
            this.comboMinSupport.addItem(new String(String.valueOf(i) + "%"));
            this.comboMinConfidence.addItem(new String(String.valueOf(i) + "%"));
            ++i;
        }
        this.longValues[0] = new Integer(999);
        this.longValues[1] = new String();
        this.longValues[2] = new String();
        this.longValues[3] = new String("100,0%");
        this.longValues[4] = new Integer(999);
        this.longValues[5] = new String("100,0%");
    }

    public void setController(NeuralModelController controller) {
        this.controller = controller;
    }

    public void setRulesPanel(CombinatorialNeuralModel combinatorialNetwork) {
        this.setRulesPanel(combinatorialNetwork, 60, 7);
    }

    public void setRulesPanel(CombinatorialNeuralModel combinatorialNetwork, int confidence, int support) {
        this.combinatorialNetwork = combinatorialNetwork;
        this.comboMinSupport.setSelectedIndex(support);
        this.comboMinConfidence.setSelectedIndex(confidence);
        this.attributeVector = combinatorialNetwork.getAttributeVector();
        this.classIndex = combinatorialNetwork.getClassIndex();
        this.createTableLines(support, confidence);
        this.rulesTableModel = new RulesTableModel();
        this.tableRules = new JTable(this.rulesTableModel);
        this.initColumnSizes(this.tableRules, this.rulesTableModel);
        this.jScrollPane1.getViewport().add((Component)this.tableRules, null);
    }

    private void createTableLines(int minSupport, int minConfidence) {
        Iterator combinations = this.combinatorialNetwork.getModel();
        DecimalFormat numFormat = new DecimalFormat("##0.0");
        this.tableLinesArray = new ArrayList();
        while (combinations.hasNext()) {
            Combination combination = (Combination)combinations.next();
            OutputNeuron[] outputArray = combination.getOutputArray();
            ArrayList inputList = this.extractInputs(combination);
            int i = 0;
            while (i < outputArray.length) {
                OutputNeuron tempOutput = outputArray[i];
                if (tempOutput != null && tempOutput.getConfidence() >= (float)minConfidence && tempOutput.getSupport() >= (float)minSupport) {
                    Attribute att;
                    String inputCell = String.valueOf(this.resource.getString("if")) + " ";
                    int j = 0;
                    while (j < inputList.size()) {
                        int[] input = (int[])inputList.get(j);
                        att = this.attributeVector[input[0]];
                        inputCell = String.valueOf(inputCell) + att.getAttributeName() + " = " + att.value(input[1]) + " ";
                        if (j < inputList.size() - 1) {
                            inputCell = String.valueOf(inputCell) + " " + this.resource.getString("and") + " ";
                        }
                        ++j;
                    }
                    if (((String)this.longValues[1]).length() < inputCell.length()) {
                        this.longValues[1] = inputCell;
                    }
                    String outputCell = String.valueOf(this.resource.getString("then")) + " ";
                    att = this.attributeVector[this.classIndex];
                    outputCell = String.valueOf(outputCell) + att.getAttributeName() + " = " + att.value(i);
                    if (((String)this.longValues[2]).length() < outputCell.length()) {
                        this.longValues[2] = outputCell;
                    }
                    Integer numberOfCases = new Integer(tempOutput.getAccumulator());
                    String confidence = new String(String.valueOf(numFormat.format(tempOutput.getConfidence())) + "%");
                    String support = new String(String.valueOf(numFormat.format(tempOutput.getSupport())) + "%");
                    TableLine tableLine = new TableLine(inputCell, outputCell, confidence, numberOfCases, support);
                    this.tableLinesArray.add(tableLine);
                }
                ++i;
            }
        }
    }

    private ArrayList extractInputs(Combination combination) {
        String key = combination.getKey();
        StringTokenizer strTokenizer = new StringTokenizer(key, " ");
        int numOfTokens = strTokenizer.countTokens();
        ArrayList<int[]> inputArray = new ArrayList<int[]>();
        int i = 0;
        while (i < numOfTokens) {
            int[] input = new int[2];
            input[0] = (int)Float.parseFloat(strTokenizer.nextToken());
            ++i;
            input[1] = (int)Float.parseFloat(strTokenizer.nextToken());
            inputArray.add(input);
            ++i;
        }
        return inputArray;
    }

    private void initColumnSizes(JTable table, RulesTableModel tableModel) {
        TableColumn column = null;
        Component component = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < 6) {
            column = table.getColumnModel().getColumn(i);
            component = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = component.getPreferredSize().width;
            component = table.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(table, this.longValues[i], false, false, 0, i);
            cellWidth = component.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
            ++i;
        }
    }

    void combo_actionPerformed(ActionEvent e) {
        if (this.rulesTableModel != null) {
            int minConfidence = this.comboMinConfidence.getSelectedIndex();
            int minSupport = this.comboMinSupport.getSelectedIndex();
            this.createTableLines(minSupport, minConfidence);
            this.rulesTableModel.fireTableDataChanged();
        }
    }

    void printButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        this.controller.printTable(this.tableRules);
        this.setCursor(new Cursor(0));
    }

    void previewButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        this.controller.printPreviewer(this.tableRules);
        this.setCursor(new Cursor(0));
    }

    public int getSupport() {
        return this.comboMinSupport.getSelectedIndex();
    }

    public int getConfidence() {
        return this.comboMinConfidence.getSelectedIndex();
    }

    class RulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 0L;

        RulesTableModel() {
        }

        public String getColumnName(int col) {
            String[] columnNames = new String[]{RulesPanel.this.resource.getString("index"), RulesPanel.this.resource.getString("if"), RulesPanel.this.resource.getString("then"), RulesPanel.this.resource.getString("confidence"), RulesPanel.this.resource.getString("cases"), RulesPanel.this.resource.getString("support")};
            return columnNames[col].toString();
        }

        public int getColumnCount() {
            return 6;
        }

        public int getRowCount() {
            return RulesPanel.this.tableLinesArray.size();
        }

        public Object getValueAt(int row, int col) {
            TableLine tableLine = (TableLine)RulesPanel.this.tableLinesArray.get(row);
            switch (col) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return tableLine.input;
                }
                case 2: {
                    return tableLine.output;
                }
                case 3: {
                    return tableLine.confidence;
                }
                case 4: {
                    return tableLine.numberOfCases;
                }
                case 5: {
                    return tableLine.support;
                }
            }
            return null;
        }
    }

    class TableLine {
        String input;
        String output;
        String confidence;
        Integer numberOfCases;
        String support;

        public TableLine(String input, String output, String confidence, Integer numberOfCases, String support) {
            this.input = input;
            this.output = output;
            this.confidence = confidence;
            this.numberOfCases = numberOfCases;
            this.support = support;
        }
    }
}

