/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.evaluation.batchEvaluation.model.Logs;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.LogsTabController;

public class LogsTab {
    private static final long serialVersionUID = -5280637854285401090L;
    private String tabTitle;
    private ResourceBundle resource;
    private LogsTabController controller;
    private BatchEvaluationMain mainView;
    private JTextArea textArea;
    private Logs data;

    public LogsTab(BatchEvaluationMain mainView, BatchEvaluation model) {
        this.mainView = mainView;
        this.resource = mainView.getResourceBundle();
        this.tabTitle = this.resource.getString("logTabTitle");
        this.controller = new LogsTabController(this, model);
        this.data = this.controller.getData();
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public JPanel getTabPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane dataTableScroll = new JScrollPane(this.textArea);
        dataTableScroll.setPreferredSize(new Dimension(1000, 150));
        panel.add((Component)dataTableScroll, "North");
        panel.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
        String copyButtonText = this.resource.getString("copyButtonText");
        JButton copyButton = new JButton(copyButtonText);
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogsTab.this.copyData();
            }
        });
        String clearButtonText = this.resource.getString("clearButtonText");
        JButton clearButton = new JButton(clearButtonText);
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogsTab.this.controller.clearData();
            }
        });
        panel.add((Component)copyButton, new CC().spanX(4).split(4).tag("other"));
        panel.add((Component)clearButton, new CC().tag("other"));
        return panel;
    }

    public void copyData() {
        this.textArea.selectAll();
        this.textArea.copy();
    }

    public void clearData() {
        this.textArea.setText(null);
    }

    public void insertData(String log) {
        this.textArea.append(String.valueOf(log) + "\n");
    }

    public LogsTabController getController() {
        return this.controller;
    }

    public BatchEvaluationMain getMainView() {
        return this.mainView;
    }
}

