/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.evaluation.batchEvaluation.model.Evaluations;
import unbbayes.datamining.gui.UtilsGUI;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.EvaluationsTabController;

public class EvaluationsTab {
    private String tabTitle;
    private ResourceBundle resource;
    private BatchEvaluationMain mainView;
    private EvaluationsTabController controller;
    private UtilsGUI utilsGUI;
    private UtilsGUI.EachRowEditor rowEditorClass;
    private UtilsGUI.EachRowRenderer rowRendererClass;
    private UtilsGUI.EachRowEditor rowEditorCounter;
    private UtilsGUI.EachRowRenderer rowRendererCounter;
    private Evaluations data;
    private JTable table;

    public EvaluationsTab(BatchEvaluationMain mainView, BatchEvaluation model) {
        this.mainView = mainView;
        this.utilsGUI = new UtilsGUI();
        this.resource = mainView.getResourceBundle();
        this.tabTitle = this.resource.getString("evaluationsTabTitle");
        this.controller = new EvaluationsTabController(this, model);
        this.data = this.controller.getData();
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    protected JPanel getTabPanel() throws Exception {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.table = this.gettable();
        JScrollPane dataTableScroll = new JScrollPane(this.table);
        dataTableScroll.setPreferredSize(new Dimension(1000, 150));
        panel.add((Component)dataTableScroll, "North");
        panel.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
        String newButtonText = this.resource.getString("newButtonText");
        JButton newButton = new JButton(newButtonText);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationsTab.this.controller.insertData();
            }
        });
        String deleteButtonText = this.resource.getString("deleteButtonText");
        JButton deleteButton = new JButton(deleteButtonText);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationsTab.this.removeRow();
            }
        });
        panel.add((Component)newButton, new CC().spanX(4).split(4).tag("other"));
        panel.add((Component)deleteButton, new CC().tag("other"));
        return panel;
    }

    public void loadEvaluationData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererClass = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorCounter = new UtilsGUI.EachRowEditor(utilsGUI2, this.table);
        this.rowRendererCounter = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel EvaluationModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        EvaluationModel.fireTableDataChanged();
    }

    public void updateColumnModel() {
        int numRows = this.table.getRowCount();
        int row = 0;
        while (row < numRows) {
            String[] evaluationNames = this.data.getEvaluationNames();
            this.changeColumnModel(evaluationNames, row);
            ++row;
        }
    }

    private void changeColumnModel(String[] evaluationNames, int row) {
        TableColumnModel columnModel = this.table.getColumnModel();
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass.setEditorAt(row, new UtilsGUI.ComboBoxEditor(utilsGUI, evaluationNames));
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowRendererClass.add(row, new UtilsGUI.ComboBoxRenderer(utilsGUI2, evaluationNames));
        columnModel.getColumn(1).setCellEditor(this.rowEditorClass);
        columnModel.getColumn(1).setCellRenderer(this.rowRendererClass);
    }

    public void addRow(Object[] dataTableEntry, String[] evaluationNames) {
        DefaultTableModel EvaluationModel = (DefaultTableModel)this.table.getModel();
        EvaluationModel.addRow(dataTableEntry);
        int row = this.table.getRowCount() - 1;
        this.changeColumnModel(evaluationNames, row);
        this.table.changeSelection(row, 0, false, false);
        this.table.requestFocusInWindow();
    }

    public void removeRow() {
        if (this.table.getRowCount() > 0) {
            DefaultTableModel EvaluationModel = (DefaultTableModel)this.table.getModel();
            int row = this.table.getSelectedRow();
            EvaluationModel.removeRow(row);
            this.rowEditorClass.remove(row);
            this.rowRendererClass.remove(row);
            this.rowEditorCounter.remove(row);
            this.rowRendererCounter.remove(row);
            int rowFocus = this.table.getRowCount() - 1;
            this.table.changeSelection(rowFocus, 0, false, false);
            this.table.requestFocusInWindow();
        }
    }

    private JTable gettable() {
        DefaultTableModel EvaluationModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            public String getColumnName(int col) {
                return EvaluationsTab.this.data.getColumnName(col);
            }

            public int getColumnCount() {
                return EvaluationsTab.this.data.getColumnCount();
            }

            public int getRowCount() {
                return EvaluationsTab.this.data.getRowCount();
            }

            public void addRow(Object[] rowData) {
                EvaluationsTab.this.data.addRow(rowData);
                super.fireTableDataChanged();
            }

            public void removeRow(int row) {
                if (row >= 0) {
                    EvaluationsTab.this.data.removeEvaluation(row);
                    super.fireTableDataChanged();
                }
            }

            public Object getValueAt(int row, int col) {
                return EvaluationsTab.this.data.getValueAt(row, col);
            }

            public void setValueAt(Object value, int row, int col) {
                EvaluationsTab.this.data.setValueAt(value, row, col);
                this.fireTableCellUpdated(row, col);
            }

            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        JTable table = new JTable(EvaluationModel);
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass = new UtilsGUI.EachRowEditor(utilsGUI, table);
        this.rowRendererClass = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorCounter = new UtilsGUI.EachRowEditor(utilsGUI2, table);
        this.rowRendererCounter = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setCellEditor(new UtilsGUI.CheckBoxEditor());
        columnModel.getColumn(0).setCellRenderer(new UtilsGUI.CheckBoxRenderer(this.utilsGUI));
        table.setAutoResizeMode(0);
        table.setSelectionMode(0);
        int width = 50;
        table.getColumnModel().getColumn(0).setPreferredWidth(width);
        width = 400;
        table.getColumnModel().getColumn(1).setPreferredWidth(width);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 5);
        return table;
    }

    public EvaluationsTabController getController() {
        return this.controller;
    }

    public void updateData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererClass = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorCounter = new UtilsGUI.EachRowEditor(utilsGUI2, this.table);
        this.rowRendererCounter = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel datasetModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        datasetModel.fireTableDataChanged();
    }

    public BatchEvaluationMain getMainView() {
        return this.mainView;
    }
}

