/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.evaluation.batchEvaluation.model.Datasets;
import unbbayes.datamining.gui.UtilsGUI;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.DatasetsTabController;

public class DatasetsTab {
    private String tabTitle;
    private ResourceBundle resource;
    private BatchEvaluationMain mainView;
    private DatasetsTabController controller;
    private UtilsGUI utilsGUI;
    private UtilsGUI.EachRowEditor rowEditorClass;
    private UtilsGUI.EachRowRenderer rowRendererClass;
    private UtilsGUI.EachRowEditor rowEditorCounter;
    private UtilsGUI.EachRowRenderer rowRendererCounter;
    private Datasets data;
    private JTable table;

    protected DatasetsTab(BatchEvaluationMain mainView, BatchEvaluation model) {
        this.mainView = mainView;
        this.utilsGUI = new UtilsGUI();
        this.resource = mainView.getResourceBundle();
        this.tabTitle = this.resource.getString("datasetsTabTitle");
        this.controller = new DatasetsTabController(this, model);
        this.data = this.controller.getData();
    }

    protected String getTabTitle() {
        return this.tabTitle;
    }

    protected JPanel getTabPanel() throws Exception {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.table = this.getDataTable();
        JScrollPane dataTableScroll = new JScrollPane(this.table);
        dataTableScroll.setPreferredSize(new Dimension(1000, 150));
        panel.add((Component)dataTableScroll, "North");
        panel.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
        String newButtonText = this.resource.getString("newButtonText");
        JButton newButton = new JButton(newButtonText);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetsTab.this.controller.addData();
            }
        });
        String deleteButtonText = this.resource.getString("deleteButtonText");
        JButton deleteButton = new JButton(deleteButtonText);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetsTab.this.removeData();
            }
        });
        panel.add((Component)newButton, new CC().spanX(4).split(4).tag("other"));
        panel.add((Component)deleteButton, new CC().tag("other"));
        return panel;
    }

    public void updateData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererClass = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorCounter = new UtilsGUI.EachRowEditor(utilsGUI2, this.table);
        this.rowRendererCounter = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel datasetModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        datasetModel.fireTableDataChanged();
    }

    public void updateColumnModel() {
        int numRows = this.table.getRowCount();
        int row = 0;
        while (row < numRows) {
            String[] attributesName = this.data.getAttributes(row);
            this.changeColumnModel(attributesName, row);
            ++row;
        }
    }

    private void changeColumnModel(String[] attributesName, int row) {
        TableColumnModel columnModel = this.table.getColumnModel();
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass.setEditorAt(row, new UtilsGUI.ComboBoxEditor(utilsGUI, attributesName));
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowRendererClass.add(row, new UtilsGUI.ComboBoxRenderer(utilsGUI2, attributesName));
        columnModel.getColumn(3).setCellEditor(this.rowEditorClass);
        columnModel.getColumn(3).setCellRenderer(this.rowRendererClass);
        UtilsGUI utilsGUI3 = this.utilsGUI;
        utilsGUI3.getClass();
        this.rowEditorCounter.setEditorAt(row, new UtilsGUI.ComboBoxEditor(utilsGUI3, attributesName));
        UtilsGUI utilsGUI4 = this.utilsGUI;
        utilsGUI4.getClass();
        this.rowRendererCounter.add(row, new UtilsGUI.ComboBoxRenderer(utilsGUI4, attributesName));
        columnModel.getColumn(4).setCellEditor(this.rowEditorCounter);
        columnModel.getColumn(4).setCellRenderer(this.rowRendererCounter);
    }

    public void addData(Object[] dataTableEntry, String[] attributesName) {
        DefaultTableModel datasetModel = (DefaultTableModel)this.table.getModel();
        datasetModel.addRow(dataTableEntry);
        int row = this.table.getRowCount() - 1;
        this.changeColumnModel(attributesName, row);
        this.table.changeSelection(row, 0, false, false);
        this.table.requestFocusInWindow();
    }

    public void removeData() {
        if (this.table.getRowCount() > 0) {
            DefaultTableModel datasetModel = (DefaultTableModel)this.table.getModel();
            int row = this.table.getSelectedRow();
            datasetModel.removeRow(row);
            this.rowEditorClass.remove(row);
            this.rowRendererClass.remove(row);
            this.rowEditorCounter.remove(row);
            this.rowRendererCounter.remove(row);
            int rowFocus = this.table.getRowCount() - 1;
            this.table.changeSelection(rowFocus, 0, false, false);
            this.table.requestFocusInWindow();
        }
    }

    private JTable getDataTable() {
        DefaultTableModel datasetModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            public String getColumnName(int col) {
                return DatasetsTab.this.data.getColumnName(col);
            }

            public int getColumnCount() {
                return DatasetsTab.this.data.getColumnCount();
            }

            public int getRowCount() {
                return DatasetsTab.this.data.getRowCount();
            }

            public void addRow(Object[] rowData) {
                DatasetsTab.this.data.addRow(rowData);
                super.fireTableDataChanged();
            }

            public void removeRow(int row) {
                if (row >= 0) {
                    DatasetsTab.this.data.removeDataset(row);
                    super.fireTableDataChanged();
                }
            }

            public Object getValueAt(int row, int col) {
                return DatasetsTab.this.data.getValueAt(row, col);
            }

            public void setValueAt(Object value, int row, int col) {
                DatasetsTab.this.data.setValueAt(value, row, col);
                this.fireTableCellUpdated(row, col);
            }

            public boolean isCellEditable(int row, int col) {
                return col != 2 && col != 5;
            }
        };
        JTable table = new JTable(datasetModel);
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClass = new UtilsGUI.EachRowEditor(utilsGUI, table);
        this.rowRendererClass = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorCounter = new UtilsGUI.EachRowEditor(utilsGUI2, table);
        this.rowRendererCounter = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setCellEditor(new UtilsGUI.CheckBoxEditor());
        columnModel.getColumn(0).setCellRenderer(new UtilsGUI.CheckBoxRenderer(this.utilsGUI));
        columnModel.getColumn(1).setCellEditor(new UtilsGUI.CheckBoxEditor());
        columnModel.getColumn(1).setCellRenderer(new UtilsGUI.CheckBoxRenderer(this.utilsGUI));
        table.setAutoResizeMode(0);
        table.setSelectionMode(0);
        int width = 50;
        table.getColumnModel().getColumn(0).setPreferredWidth(width);
        width = 60;
        table.getColumnModel().getColumn(1).setPreferredWidth(width);
        width = 200;
        table.getColumnModel().getColumn(2).setPreferredWidth(width);
        width = 100;
        table.getColumnModel().getColumn(3).setPreferredWidth(width);
        width = 100;
        table.getColumnModel().getColumn(4).setPreferredWidth(width);
        width = 400;
        table.getColumnModel().getColumn(5).setPreferredWidth(width);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 5);
        return table;
    }

    public BatchEvaluationMain getMainView() {
        return this.mainView;
    }

    public DatasetsTabController getController() {
        return this.controller;
    }
}

