/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.evaluation.batchEvaluation.model.Classifiers;
import unbbayes.datamining.gui.UtilsGUI;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.ClassifiersTabController;

public class ClassifiersTab {
    private String tabTitle;
    private ResourceBundle resource;
    private BatchEvaluationMain mainView;
    private ClassifiersTabController controller;
    private UtilsGUI utilsGUI;
    private UtilsGUI.EachRowEditor rowEditorClassifier;
    private UtilsGUI.EachRowRenderer rowRendererClassifier;
    private UtilsGUI.EachRowEditor rowEditorConfig;
    private UtilsGUI.EachRowRenderer rowRendererConfig;
    private Classifiers data;
    private JTable table;

    public ClassifiersTab(BatchEvaluationMain mainView, BatchEvaluation model) {
        this.mainView = mainView;
        this.utilsGUI = new UtilsGUI();
        this.resource = mainView.getResourceBundle();
        this.tabTitle = this.resource.getString("classifiersTabTitle");
        this.controller = new ClassifiersTabController(this, model);
        this.data = this.controller.getData();
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    protected JPanel getTabPanel() throws Exception {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.table = this.gettable();
        JScrollPane dataTableScroll = new JScrollPane(this.table);
        dataTableScroll.setPreferredSize(new Dimension(1000, 150));
        panel.add((Component)dataTableScroll, "North");
        panel.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
        String newButtonText = this.resource.getString("newButtonText");
        JButton newButton = new JButton(newButtonText);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifiersTab.this.controller.insertData();
            }
        });
        String deleteButtonText = this.resource.getString("deleteButtonText");
        JButton deleteButton = new JButton(deleteButtonText);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifiersTab.this.removeRow();
            }
        });
        panel.add((Component)newButton, new CC().spanX(4).split(4).tag("other"));
        panel.add((Component)deleteButton, new CC().tag("other"));
        return panel;
    }

    public void loadClassifierData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClassifier = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererClassifier = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorConfig = new UtilsGUI.EachRowEditor(utilsGUI2, this.table);
        this.rowRendererConfig = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel ClassifierModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        ClassifierModel.fireTableDataChanged();
    }

    public void updateColumnModel() {
        int numRows = this.table.getRowCount();
        int row = 0;
        while (row < numRows) {
            String[] classifierNames = this.data.getClassifierNames();
            this.changeColumnModel(classifierNames, row);
            ++row;
        }
    }

    private void changeColumnModel(String[] classifierNames, int row) {
        TableColumnModel columnModel = this.table.getColumnModel();
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClassifier.setEditorAt(row, new UtilsGUI.ComboBoxEditor(utilsGUI, classifierNames));
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowRendererClassifier.add(row, new UtilsGUI.ComboBoxRenderer(utilsGUI2, classifierNames));
        columnModel.getColumn(1).setCellEditor(this.rowEditorClassifier);
        columnModel.getColumn(1).setCellRenderer(this.rowRendererClassifier);
    }

    public void addRow(Object[] dataTableEntry, String[] classifierNames) {
        DefaultTableModel ClassifierModel = (DefaultTableModel)this.table.getModel();
        ClassifierModel.addRow(dataTableEntry);
        int row = this.table.getRowCount() - 1;
        this.changeColumnModel(classifierNames, row);
        this.table.changeSelection(row, 0, false, false);
        this.table.requestFocusInWindow();
    }

    public void removeRow() {
        if (this.table.getRowCount() > 0) {
            DefaultTableModel ClassifierModel = (DefaultTableModel)this.table.getModel();
            int row = this.table.getSelectedRow();
            ClassifierModel.removeRow(row);
            this.rowEditorClassifier.remove(row);
            this.rowRendererClassifier.remove(row);
            this.rowEditorConfig.remove(row);
            this.rowRendererConfig.remove(row);
            int rowFocus = this.table.getRowCount() - 1;
            this.table.changeSelection(rowFocus, 0, false, false);
            this.table.requestFocusInWindow();
        }
    }

    private JTable gettable() {
        DefaultTableModel ClassifierModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            public String getColumnName(int col) {
                return ClassifiersTab.this.data.getColumnName(col);
            }

            public int getColumnCount() {
                return ClassifiersTab.this.data.getColumnCount();
            }

            public int getRowCount() {
                return ClassifiersTab.this.data.getRowCount();
            }

            public void addRow(Object[] rowData) {
                ClassifiersTab.this.data.addRow(rowData);
                super.fireTableDataChanged();
            }

            public void removeRow(int row) {
                if (row >= 0) {
                    ClassifiersTab.this.data.removeClassifier(row);
                    super.fireTableDataChanged();
                }
            }

            public Object getValueAt(int row, int col) {
                return ClassifiersTab.this.data.getValueAt(row, col);
            }

            public void setValueAt(Object value, int row, int col) {
                ClassifiersTab.this.data.setValueAt(value, row, col);
                this.fireTableCellUpdated(row, col);
            }

            public boolean isCellEditable(int row, int col) {
                return col != 2;
            }

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        JTable table = new JTable(ClassifierModel);
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClassifier = new UtilsGUI.EachRowEditor(utilsGUI, table);
        this.rowRendererClassifier = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorConfig = new UtilsGUI.EachRowEditor(utilsGUI2, table);
        this.rowRendererConfig = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setCellEditor(new UtilsGUI.CheckBoxEditor());
        columnModel.getColumn(0).setCellRenderer(new UtilsGUI.CheckBoxRenderer(this.utilsGUI));
        table.setAutoResizeMode(0);
        table.setSelectionMode(0);
        int width = 50;
        table.getColumnModel().getColumn(0).setPreferredWidth(width);
        width = 400;
        table.getColumnModel().getColumn(1).setPreferredWidth(width);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 5);
        return table;
    }

    public ClassifiersTabController getController() {
        return this.controller;
    }

    public void updateData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorClassifier = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererClassifier = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowEditorConfig = new UtilsGUI.EachRowEditor(utilsGUI2, this.table);
        this.rowRendererConfig = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel datasetModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        datasetModel.fireTableDataChanged();
    }

    public BatchEvaluationMain getMainView() {
        return this.mainView;
    }
}

