/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.IconController;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.gui.evaluation.batchEvaluation.ClassifiersTab;
import unbbayes.datamining.gui.evaluation.batchEvaluation.DatasetsTab;
import unbbayes.datamining.gui.evaluation.batchEvaluation.EvaluationsTab;
import unbbayes.datamining.gui.evaluation.batchEvaluation.LogsTab;
import unbbayes.datamining.gui.evaluation.batchEvaluation.PreprocessorsTab;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.BatchEvaluationMainController;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.ClassifiersTabController;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.DatasetsTabController;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.EvaluationsTabController;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.LogsTabController;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.PreprocessorsTabController;

public class BatchEvaluationMain
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private ResourceBundle resource;
    private JTabbedPane mainPanel;
    private ImageIcon openIcon;
    private ImageIcon saveIcon;
    private ImageIcon runIcon;
    private ImageIcon helpIcon;
    private JPanel jPanel = new JPanel();
    private JPanel contentPane;
    private JMenu jMenuFile = new JMenu();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenuItem jMenuOpen = new JMenuItem();
    private JMenuItem jMenuSave = new JMenuItem();
    private JMenuItem jMenuRun = new JMenuItem();
    private JMenuBar jMenuBar = new JMenuBar();
    private Border border;
    private BorderLayout borderLayout = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private TitledBorder titledBorder;
    private JToolBar jToolBar = new JToolBar();
    private JButton helpButton = new JButton();
    private JButton openButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton runButton = new JButton();
    private JLabel statusBar = new JLabel();
    private DatasetsTab datasetsTab;
    private PreprocessorsTab preprocessorTab;
    private ClassifiersTab classifierTab;
    private EvaluationsTab evaluationTab;
    private LogsTab logTab;
    private BatchEvaluationMainController controller;

    public BatchEvaluationMain() {
        super("", true, true, true, true);
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.evaluation.batchEvaluation.resources.BatchEvaluationResource");
        this.setTitle(this.resource.getString("mainTitle"));
        this.enableEvents(64L);
        this.controller = new BatchEvaluationMainController(this);
        try {
            this.buildView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildView() throws Exception {
        this.mainPanel = this.buildPanel();
        IconController iconController = IconController.getInstance();
        this.openIcon = iconController.getOpenIcon();
        this.saveIcon = iconController.getSaveIcon();
        this.runIcon = iconController.getCompileIcon();
        this.helpIcon = iconController.getHelpIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.border = BorderFactory.createLineBorder(new Color(153, 153, 153), 1);
        this.titledBorder = new TitledBorder(this.border, this.resource.getString("selectProgram"));
        this.contentPane.setLayout(this.borderLayout);
        this.setSize(new Dimension(640, 480));
        this.jMenuFile.setMnemonic(((Character)this.resource.getObject("fileMnemonic")).charValue());
        this.jMenuFile.setText(this.resource.getString("file"));
        this.jMenuHelp.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        this.jMenuHelp.setText(this.resource.getString("help"));
        this.jMenuHelpAbout.setIcon(this.helpIcon);
        this.jMenuHelpAbout.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        this.jMenuHelpAbout.setText(this.resource.getString("helpTopics"));
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.help(e);
            }
        });
        this.jPanel.setLayout(this.borderLayout2);
        this.jPanel.setBorder(this.titledBorder);
        this.titledBorder.setTitle(this.resource.getString("status"));
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jMenuFileExit.setMnemonic(((Character)this.resource.getObject("fileExitMnemonic")).charValue());
        this.jMenuFileExit.setText(this.resource.getString("exit"));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.fileExit(e);
            }
        });
        this.jToolBar.setFloatable(false);
        this.jMenuOpen.setIcon(this.openIcon);
        this.jMenuOpen.setMnemonic(((Character)this.resource.getObject("openScriptMnemonic")).charValue());
        this.jMenuOpen.setText(this.resource.getString("openScript"));
        this.jMenuOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.openScript();
            }
        });
        this.jMenuSave.setIcon(this.saveIcon);
        this.jMenuSave.setMnemonic(((Character)this.resource.getObject("saveScriptMnemonic")).charValue());
        this.jMenuSave.setText(this.resource.getString("saveScript"));
        this.jMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.saveScript();
            }
        });
        this.jMenuRun.setIcon(this.runIcon);
        this.jMenuRun.setMnemonic(((Character)this.resource.getObject("runScriptMnemonic")).charValue());
        this.jMenuRun.setText(this.resource.getString("runScript"));
        this.jMenuRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.runScript();
            }
        });
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.help(e);
            }
        });
        this.openButton.setToolTipText(this.resource.getString("openScript"));
        this.openButton.setIcon(this.openIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.openScript();
            }
        });
        this.saveButton.setToolTipText(this.resource.getString("saveScript"));
        this.saveButton.setIcon(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.saveScript();
            }
        });
        this.runButton.setToolTipText(this.resource.getString("runScript"));
        this.runButton.setIcon(this.runIcon);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchEvaluationMain.this.runScript();
            }
        });
        this.jMenuFile.add(this.jMenuOpen);
        this.jMenuFile.add(this.jMenuSave);
        this.jMenuFile.add(this.jMenuRun);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        this.contentPane.add((Component)this.jPanel, "South");
        this.jPanel.add((Component)this.statusBar, "Center");
        this.contentPane.add((Component)this.mainPanel, "Center");
        this.contentPane.add((Component)this.jToolBar, "North");
        this.jToolBar.add((Component)this.openButton, null);
        this.jToolBar.add((Component)this.saveButton, null);
        this.jToolBar.add((Component)this.runButton, null);
        this.jToolBar.add((Component)this.helpButton, null);
    }

    private JTabbedPane buildPanel() throws Exception {
        JTabbedPane tabbedPane = new JTabbedPane();
        BatchEvaluation model = this.controller.getModel();
        this.datasetsTab = new DatasetsTab(this, model);
        this.preprocessorTab = new PreprocessorsTab(this, model);
        this.classifierTab = new ClassifiersTab(this, model);
        this.evaluationTab = new EvaluationsTab(this, model);
        this.logTab = new LogsTab(this, model);
        String datasetsTabTitle = this.datasetsTab.getTabTitle();
        String preprocessorTabTitle = this.preprocessorTab.getTabTitle();
        String classifierTabTitle = this.classifierTab.getTabTitle();
        String evaluationTabTitle = this.evaluationTab.getTabTitle();
        String logTabTitle = this.logTab.getTabTitle();
        JPanel datasetsTabPanel = this.datasetsTab.getTabPanel();
        JPanel preprocessorTabPanel = this.preprocessorTab.getTabPanel();
        JPanel classifierTabPanel = this.classifierTab.getTabPanel();
        JPanel evaluationTabPanel = this.evaluationTab.getTabPanel();
        JPanel logTabPanel = this.logTab.getTabPanel();
        tabbedPane.addTab(datasetsTabTitle, datasetsTabPanel);
        tabbedPane.addTab(preprocessorTabTitle, preprocessorTabPanel);
        tabbedPane.addTab(classifierTabTitle, classifierTabPanel);
        tabbedPane.addTab(evaluationTabTitle, evaluationTabPanel);
        tabbedPane.addTab(logTabTitle, logTabPanel);
        return tabbedPane;
    }

    private void fileExit(ActionEvent e) {
        this.controller.fileExit();
    }

    private void openScript() {
        this.controller.openScript();
    }

    private void saveScript() {
        this.controller.saveScript();
    }

    protected void runScript() {
        this.controller.runScript();
    }

    private void help(ActionEvent e) {
        this.controller.help();
    }

    public ResourceBundle getResourceBundle() {
        return this.resource;
    }

    public void setStatusBar(String text) {
        this.statusBar.setText(text);
    }

    public DatasetsTabController getDatasetsTabController() {
        return this.datasetsTab.getController();
    }

    public PreprocessorsTabController getPreprocessorsTabController() {
        return this.preprocessorTab.getController();
    }

    public ClassifiersTabController getClassifiersTabController() {
        return this.classifierTab.getController();
    }

    public EvaluationsTabController getEvaluationsTabController() {
        return this.evaluationTab.getController();
    }

    public LogsTabController getLogsTabController() {
        return this.logTab.getController();
    }

    public void disableFunctions() {
        this.openButton.setEnabled(false);
        this.runButton.setEnabled(false);
        this.jMenuOpen.setEnabled(false);
        this.jMenuRun.setEnabled(false);
    }

    public void enableFunctions() {
        this.openButton.setEnabled(true);
        this.runButton.setEnabled(true);
        this.jMenuOpen.setEnabled(true);
        this.jMenuRun.setEnabled(true);
    }
}

