/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.ProgressDialog;
import unbbayes.datamining.classifiers.BayesianNetwork;
import unbbayes.datamining.classifiers.Classifier;
import unbbayes.datamining.classifiers.CombinatorialNeuralModel;
import unbbayes.datamining.classifiers.DistributionClassifier;
import unbbayes.datamining.classifiers.NeuralNetwork;
import unbbayes.datamining.classifiers.decisiontree.DecisionTreeLearning;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.Evaluation;
import unbbayes.datamining.gui.evaluation.EvaluationMain;
import unbbayes.datamining.gui.evaluation.EvaluationOptions;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.util.GraphPaperLayout;

public class EvaluationPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private JPanel jPanel63 = new JPanel();
    private BorderLayout borderLayout45 = new BorderLayout();
    private JPanel jPanel62 = new JPanel();
    private BorderLayout borderLayout44 = new BorderLayout();
    private JButton jButton9 = new JButton();
    private JPanel jPanel2 = new JPanel();
    private JPanel classifierOutputPanel = new JPanel();
    private JPanel modelPanel = new JPanel(new BorderLayout());
    private JScrollPane jScrollPane2 = new JScrollPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private TitledBorder titledBorder10;
    private TitledBorder titledBorder9;
    private TitledBorder titledBorder8;
    private TitledBorder titledBorder7;
    private TitledBorder titledBorder6;
    private ImageIcon salvarIcon;
    private Border border10;
    private InstanceSet instances;
    private Classifier classifier;
    private Thread thread;
    private JTextArea jTextArea2 = new JTextArea();
    private JTextField jTextField1 = new JTextField();
    private InstanceSet userTest;
    private JLabel jLabel1 = new JLabel();
    private EvaluationMain reference;
    private JFileChooser fileChooser;
    private JLabel jLabel2 = new JLabel();
    private JButton jButton7 = new JButton();
    private GridLayout gridLayout2 = new GridLayout();
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel jPanel1 = new JPanel();
    private JComboBox jComboBox2 = new JComboBox();
    private JPanel classSelectionPanel = new JPanel();
    private JPanel logPanel = new JPanel();
    private BorderLayout borderLayout43 = new BorderLayout();
    private JPanel evaluationTypePanel = new JPanel();
    private GridLayout gridLayout3 = new GridLayout();
    private JPanel jPanel4 = new JPanel();
    private JPanel jPanel5 = new JPanel();
    private JPanel jPanel6 = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JRadioButton jRadioButton1 = new JRadioButton();
    private JRadioButton jRadioButton2 = new JRadioButton();
    private JRadioButton jRadioButton3 = new JRadioButton();
    private GraphPaperLayout paperLayout = new GraphPaperLayout(new Dimension(4, 9));
    private JButton jButton1 = new JButton();
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private TitledBorder titledBorder1;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea jTextArea1 = new JTextArea();
    private int[] priorityClassValues;
    private float[] priorityProbabilities;
    private EvaluationPanel evaluationPanel;

    public EvaluationPanel(EvaluationMain reference) {
        this.reference = reference;
        try {
            this.evaluationPanel = this;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.salvarIcon = IconController.getInstance().getSaveIcon();
        this.titledBorder10 = new TitledBorder(this.border10, "Classifier output");
        this.titledBorder9 = new TitledBorder(this.border10, "Select Class");
        this.titledBorder8 = new TitledBorder(this.border10, "Log");
        this.titledBorder7 = new TitledBorder(this.border10, "Test Options");
        this.titledBorder6 = new TitledBorder(this.border10, "Model");
        this.titledBorder1 = new TitledBorder(this.border10, "Evaluation Type");
        this.jPanel62.setLayout(this.borderLayout45);
        this.jButton9.setEnabled(false);
        this.jButton9.setIcon(this.salvarIcon);
        this.jButton9.setMnemonic('S');
        this.jButton9.setText("Save information...");
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jButton9_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.paperLayout);
        this.classifierOutputPanel.setLayout(this.borderLayout44);
        this.setLayout(this.borderLayout1);
        this.modelPanel.setBorder(this.titledBorder6);
        this.classifierOutputPanel.setBorder(this.titledBorder10);
        this.jTextArea2.setEditable(false);
        this.jLabel2.setText("  ");
        this.jButton7.setEnabled(false);
        this.jButton7.setText("Start");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jButton7_actionPerformed(e);
            }
        });
        this.gridLayout2.setColumns(2);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.jPanel1.setLayout(this.gridLayout2);
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jComboBox2_actionPerformed(e);
            }
        });
        this.jComboBox2.setEnabled(false);
        this.classSelectionPanel.setLayout(this.gridLayout1);
        this.classSelectionPanel.setBorder(this.titledBorder9);
        this.classSelectionPanel.setMinimumSize(new Dimension(148, 104));
        this.logPanel.setLayout(this.borderLayout43);
        this.logPanel.setBorder(this.titledBorder8);
        this.evaluationTypePanel.setLayout(this.gridLayout3);
        this.gridLayout3.setRows(3);
        this.evaluationTypePanel.setBorder(this.titledBorder1);
        this.jPanel6.setLayout(this.borderLayout3);
        this.jPanel5.setLayout(this.borderLayout4);
        this.jPanel4.setLayout(this.borderLayout5);
        this.jRadioButton1.setEnabled(false);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Normal");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jRadioButton_actionPerformed(e);
            }
        });
        this.jRadioButton2.setEnabled(false);
        this.jRadioButton2.setText("Relative probabilities");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jRadioButton_actionPerformed(e);
            }
        });
        this.jRadioButton3.setEnabled(false);
        this.jRadioButton3.setText("Absolute probabilities");
        this.jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jRadioButton_actionPerformed(e);
            }
        });
        this.jButton1.setEnabled(false);
        this.jButton1.setText("Set ...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationPanel.this.jButton1_actionPerformed(e);
            }
        });
        this.jTextArea1.setEditable(false);
        this.modelPanel.add((Component)this.jLabel2, "Center");
        this.classifierOutputPanel.add((Component)this.jPanel62, "Center");
        this.jPanel62.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.jTextArea2, null);
        this.classifierOutputPanel.add((Component)this.jPanel63, "South");
        this.jPanel63.add((Component)this.jButton9, null);
        this.evaluationTypePanel.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jRadioButton1, "Center");
        this.evaluationTypePanel.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jRadioButton2, "Center");
        this.evaluationTypePanel.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jRadioButton3, "Center");
        this.jPanel4.add((Component)this.jButton1, "East");
        this.classSelectionPanel.add((Component)this.jComboBox2, null);
        this.classSelectionPanel.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jButton7, null);
        this.logPanel.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTextArea1, null);
        this.jPanel2.add((Component)this.modelPanel, new Rectangle(0, 0, 4, 1));
        this.jPanel2.add((Component)this.evaluationTypePanel, new Rectangle(0, 1, 1, 2));
        this.jPanel2.add((Component)this.classSelectionPanel, new Rectangle(0, 3, 1, 2));
        this.jPanel2.add((Component)this.logPanel, new Rectangle(0, 5, 1, 4));
        this.jPanel2.add((Component)this.classifierOutputPanel, new Rectangle(1, 1, 3, 8));
        this.add((Component)this.jPanel2, "Center");
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.buttonGroup1.add(this.jRadioButton3);
    }

    void jButton9_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            try {
                String fileName = selectedFile.getName();
                if (!fileName.regionMatches(true, fileName.length() - 4, ".txt", 0, 4)) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".txt");
                }
                BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(selectedFile));
                PrintWriter pw = new PrintWriter(w, true);
                int lineCount = this.jTextArea2.getLineCount();
                int i = 0;
                while (i < lineCount) {
                    int startLine = this.jTextArea2.getLineStartOffset(i);
                    int endLine = this.jTextArea2.getLineEndOffset(i);
                    pw.println(this.jTextArea2.getText(startLine, endLine - startLine - 1));
                    ++i;
                }
                pw.flush();
                ((OutputStream)w).close();
                this.reference.setStatusBar("File saved. " + fileName);
            }
            catch (BadLocationException ble) {
                this.reference.setStatusBar("Bad location " + ble.getMessage());
            }
            catch (IOException ioe) {
                this.reference.setStatusBar("Error writing file " + selectedFile.getName() + " " + ioe.getMessage());
            }
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    void jButton7_actionPerformed(ActionEvent e) {
        if (this.thread == null) {
            this.jButton7.setEnabled(false);
            this.thread = new Thread(){

                public void run() {
                    int numAttributes = EvaluationPanel.this.instances.numAttributes();
                    if (EvaluationPanel.this.classifier instanceof DistributionClassifier) {
                        if (EvaluationPanel.this.jRadioButton1.isSelected()) {
                            ((DistributionClassifier)EvaluationPanel.this.classifier).setNormalClassification();
                        } else if (EvaluationPanel.this.jRadioButton2.isSelected()) {
                            ((DistributionClassifier)EvaluationPanel.this.classifier).setRelativeClassification();
                        } else if (EvaluationPanel.this.jRadioButton3.isSelected()) {
                            ((DistributionClassifier)EvaluationPanel.this.classifier).setAbsoluteClassification(EvaluationPanel.this.priorityClassValues, EvaluationPanel.this.priorityProbabilities);
                            int i = 0;
                            while (i < EvaluationPanel.this.priorityClassValues.length) {
                                System.out.println(String.valueOf(EvaluationPanel.this.priorityClassValues[i]) + " " + EvaluationPanel.this.priorityProbabilities[i]);
                                ++i;
                            }
                        }
                    }
                    EvaluationPanel.this.setCursor(new Cursor(3));
                    try {
                        StringBuffer outBuff = new StringBuffer();
                        String currentHour = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                        String classifierName = EvaluationPanel.this.classifier.getClass().getName().substring("unbbayes.datamining.classifiers.".length());
                        EvaluationPanel.this.jTextArea1.append("Started  " + currentHour + classifierName + "\n");
                        outBuff.append("=== Run information ===\n\n");
                        outBuff.append("Scheme:           " + classifierName);
                        outBuff.append("\n");
                        outBuff.append("Relation:         " + EvaluationPanel.this.instances.getRelationName() + '\n');
                        outBuff.append("Instances:        " + EvaluationPanel.this.instances.numWeightedInstances() + '\n');
                        outBuff.append("Attributes:       " + EvaluationPanel.this.instances.numAttributes() + '\n');
                        if (numAttributes < 100) {
                            int i = 0;
                            while (i < numAttributes) {
                                outBuff.append("                  " + EvaluationPanel.this.instances.getAttribute(i).getAttributeName() + '\n');
                                ++i;
                            }
                        } else {
                            outBuff.append("                  [list of attributes omitted]\n");
                        }
                        outBuff.append("ClassAttribute:   " + EvaluationPanel.this.instances.getClassAttribute().getAttributeName() + '\n');
                        outBuff.append("Test mode:    ");
                        outBuff.append("=== Classifier model ===\n\n");
                        outBuff.append(String.valueOf(EvaluationPanel.this.classifier.toString()) + "\n\n");
                        Evaluation eval = new Evaluation(EvaluationPanel.this.instances, EvaluationPanel.this.classifier);
                        ProgressDialog progressDialog = new ProgressDialog(null, eval);
                        boolean successStatus = progressDialog.load();
                        outBuff.append(eval.toString());
                        outBuff.append("\n");
                        outBuff.append(eval.toClassDetailsString());
                        outBuff.append("\n");
                        outBuff.append(eval.toMatrixString());
                        EvaluationPanel.this.jTextArea2.setText(outBuff.toString());
                        currentHour = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                        EvaluationPanel.this.jTextArea1.append("Finished " + currentHour + classifierName + "\n");
                        EvaluationPanel.this.jButton9.setEnabled(true);
                        EvaluationPanel.this.setCursor(new Cursor(0));
                    }
                    catch (Exception e) {
                        EvaluationPanel.this.setCursor(new Cursor(0));
                        JOptionPane.showConfirmDialog(EvaluationPanel.this, "Exception " + e.getMessage(), "Error", -1, 0);
                        e.printStackTrace();
                    }
                    EvaluationPanel.this.thread = null;
                    EvaluationPanel.this.jButton7.setEnabled(true);
                }
            };
            this.thread.start();
        }
    }

    public void setModel(Classifier classifier, InstanceSet inst) {
        this.jTextArea2.setText("");
        if (classifier instanceof BayesianNetwork) {
            this.jLabel2.setText("Model - Bayesian Network");
        } else if (classifier instanceof DecisionTreeLearning) {
            this.jLabel2.setText("Model - Decision Tree");
        } else if (classifier instanceof CombinatorialNeuralModel) {
            this.jLabel2.setText("Model - Combinatorial Neural Model");
        } else if (classifier instanceof NeuralNetwork) {
            this.jLabel2.setText("Model - Backpropagation Neural Network");
        }
        this.classifier = classifier;
        this.instances = inst;
        int numAtt = this.instances.numAttributes();
        this.jComboBox2.setEnabled(true);
        this.jButton7.setEnabled(true);
        this.jComboBox2.removeAllItems();
        int i = 0;
        while (i < numAtt) {
            this.jComboBox2.addItem(this.instances.getAttribute(i).getAttributeName());
            if (i == numAtt - 1) {
                this.jComboBox2.setSelectedItem(this.instances.getAttribute(i).getAttributeName());
            }
            ++i;
        }
        this.instances.setClassIndex(this.jComboBox2.getSelectedIndex());
        if (classifier instanceof BayesianNetwork) {
            this.jRadioButton1.setEnabled(true);
            this.jRadioButton2.setEnabled(true);
            this.jRadioButton3.setEnabled(true);
            try {
                ((BayesianNetwork)classifier).setClassAttribute(this.instances.getAttribute(this.jComboBox2.getSelectedIndex()));
                ProbabilisticNode classNode = ((BayesianNetwork)classifier).getClassNode();
                int statesSize = classNode.getStatesSize();
                this.priorityClassValues = new int[statesSize];
                this.priorityProbabilities = new float[statesSize];
                int i2 = 0;
                while (i2 < statesSize) {
                    this.priorityClassValues[i2] = i2;
                    this.priorityProbabilities[i2] = classNode.getMarginalAt(i2);
                    ++i2;
                }
            }
            catch (Exception ex) {
                this.reference.setStatusBar(ex.getMessage());
            }
        } else if (classifier instanceof DecisionTreeLearning || classifier instanceof CombinatorialNeuralModel || classifier instanceof NeuralNetwork) {
            this.jRadioButton1.setEnabled(true);
            this.jRadioButton2.setEnabled(false);
            this.jRadioButton3.setEnabled(false);
        }
    }

    void jComboBox2_actionPerformed(ActionEvent e) {
        if (this.jComboBox2.getSelectedIndex() >= 0) {
            this.instances.setClassIndex(this.jComboBox2.getSelectedIndex());
            if (this.classifier instanceof BayesianNetwork) {
                try {
                    Attribute classAttribute = this.instances.getClassAttribute();
                    ((BayesianNetwork)this.classifier).setClassAttribute(classAttribute);
                    this.reference.setStatusBar("Class Attribute " + classAttribute.getAttributeName() + " Set");
                }
                catch (Exception ex) {
                    this.reference.setStatusBar("Error " + ex.getMessage());
                }
            }
        }
    }

    public void setTextArea(String text) {
        this.jTextArea2.setText(text);
    }

    void jRadioButton_actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jRadioButton3) {
            this.jButton1.setEnabled(true);
        } else {
            this.jButton1.setEnabled(false);
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        if (this.classifier instanceof BayesianNetwork) {
            ((BayesianNetwork)this.classifier).resetNet();
            new EvaluationOptions(((BayesianNetwork)this.classifier).getClassNode(), this);
        }
    }

    public void setAbsoluteValues(int[] priorityClassValues, float[] priorityProbabilities) {
        this.priorityClassValues = priorityClassValues;
        this.priorityProbabilities = priorityProbabilities;
    }
}

