/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation;

import java.util.Hashtable;

public class EvaluationIDs {
    public static final int AUC = 0;
    public static final String AUC_NAME = "AUC";
    public static final int ROC_POINTS = 1;
    public static final String ROC_POINTS_NAME = "ROC points";
    private static Hashtable<Integer, String> evaluationIDToName;
    private static Hashtable<String, Integer> evaluationNameToID;
    private static String[] evaluationNames;

    private static void initiate() {
        evaluationIDToName = new Hashtable();
        evaluationIDToName.put(0, AUC_NAME);
        evaluationIDToName.put(1, ROC_POINTS_NAME);
        evaluationNameToID = new Hashtable();
        evaluationNameToID.put(AUC_NAME, 0);
        evaluationNameToID.put(ROC_POINTS_NAME, 1);
    }

    public static String[] getEvaluationNames() {
        if (evaluationIDToName == null) {
            EvaluationIDs.initiate();
        }
        if (evaluationNames == null) {
            int numEvaluations = evaluationIDToName.size();
            evaluationNames = new String[numEvaluations];
            int i = 0;
            while (i < numEvaluations) {
                EvaluationIDs.evaluationNames[i] = evaluationIDToName.get(i);
                ++i;
            }
        }
        return (String[])evaluationNames.clone();
    }

    public static String getEvaluationName(int evaluationID) {
        if (evaluationIDToName == null) {
            EvaluationIDs.initiate();
        }
        return evaluationIDToName.get(evaluationID);
    }

    public static int getEvaluationID(String evaluationName) {
        return evaluationNameToID.get(evaluationName);
    }

    public int getNumEvaluations() {
        return evaluationIDToName.size();
    }
}

