/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.datamanipulation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import unbbayes.datamining.datamanipulation.ArffLoader;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Loader;
import unbbayes.datamining.datamanipulation.TxtLoader;
import unbbayes.datamining.gui.UtilsGUI;

public class AttributeTypeChooserController {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.datamanipulation.resources.AttributeTypeChooserResource");
    private byte[] attributeType;
    private int numAttributes;
    private int counterIndex = -1;
    private boolean[] attributeIsString;
    private StreamTokenizer tokenizer;
    private Object[][] instances;
    private int numInstancesAux = 100;
    private String[] attributeName;
    private InstanceSet instanceSet;
    private boolean[] counterIndexAux;
    private Hashtable<Object, Object> attTypes;
    private Loader loader;
    private Object[][] chooserData;
    private byte[] attributeTypeOriginal;
    private UtilsGUI utilsGUI = new UtilsGUI();

    public AttributeTypeChooserController(File file, Component parent) throws Exception {
        this.run(file, parent);
    }

    private void run(File file, Component parent) throws Exception {
        JPanel principalPanel = this.buildWindow(file);
        if (JOptionPane.showInternalConfirmDialog(parent, principalPanel, resource.getString("windowTitle"), 2, -1) == 0) {
            int size = this.numAttributes--;
            InstanceSet instanceSet = this.loader.getInstanceSet();
            String counterAttributeName = instanceSet.getCounterAttributeName();
            if (this.counterIndex != -1) {
                counterAttributeName = this.attributeName[this.counterIndex];
            }
            this.attributeType = new byte[this.numAttributes];
            this.attributeIsString = new boolean[this.numAttributes];
            int attIndex = 0;
            String[] attributeNameAux = new String[this.numAttributes];
            int att = 0;
            while (att < size) {
                if (att != this.counterIndex) {
                    this.attributeType[attIndex] = (Byte)this.attTypes.get(this.chooserData[0][att]);
                    this.attributeIsString[attIndex] = (Boolean)this.chooserData[1][att];
                    attributeNameAux[attIndex] = this.attributeName[att];
                    ++attIndex;
                }
                ++att;
            }
            this.attributeName = attributeNameAux;
            this.loader = this.loader instanceof TxtLoader ? new TxtLoader(this.loader.file, -1) : new ArffLoader(this.loader.file, -1);
            this.loader.setAttributeIsString(this.attributeIsString);
            this.loader.setAttributeType(this.attributeType);
            this.loader.setCounterAttribute(this.counterIndex);
            this.loader.setCounterAttributeName(counterAttributeName);
            this.loader.setAttributeName(this.attributeName);
            if (this.counterIndex != -1) {
                this.loader.setCompacted(true);
            }
            this.loader.setNumAttributes(this.numAttributes);
            if (this.loader instanceof ArffLoader) {
                boolean[] buildNominalFromHeader = new boolean[this.numAttributes];
                int att2 = 0;
                while (att2 < this.numAttributes) {
                    buildNominalFromHeader[att2] = this.attributeTypeOriginal[att2] == 1 && this.attributeType[att2] == 1;
                    ++att2;
                }
                ((ArffLoader)this.loader).buildAttributes(buildNominalFromHeader, instanceSet.attributes);
            }
        } else {
            this.loader = null;
        }
    }

    private JPanel buildWindow(File file) throws Exception {
        this.getPreliminaries(file);
        JTable dataTable = new JTable(this.instances, this.attributeName){
            private static final long serialVersionUID = 1L;

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        dataTable.getTableHeader().setReorderingAllowed(false);
        dataTable.getTableHeader().setResizingAllowed(false);
        dataTable.setAutoResizeMode(0);
        dataTable.setSelectionMode(0);
        JScrollPane dataTableScroll = new JScrollPane(dataTable);
        dataTableScroll.setHorizontalScrollBarPolicy(32);
        JTable chooserTable = this.buildChooserTable();
        chooserTable.getTableHeader().setReorderingAllowed(false);
        chooserTable.getTableHeader().setResizingAllowed(false);
        String[] chooserTableRowHeaderData = new String[]{String.valueOf(resource.getString("attributeType")) + "  ", String.valueOf(resource.getString("isString")) + "  ", String.valueOf(resource.getString("counter")) + "  "};
        JList<String> chooserTableRowHeader = new JList<String>(chooserTableRowHeaderData);
        chooserTableRowHeader.setFixedCellWidth(150);
        chooserTableRowHeader.setFixedCellHeight(dataTable.getRowHeight());
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        chooserTableRowHeader.setCellRenderer(new UtilsGUI.RowHeaderRenderer(utilsGUI, chooserTable, true));
        int numLines = dataTable.getRowCount();
        String[] dummyRowHeaderData = new String[numLines];
        int i = 0;
        while (i < numLines) {
            dummyRowHeaderData[i] = "";
            ++i;
        }
        JList<String> dataTableRowHeader = new JList<String>(dummyRowHeaderData);
        dataTableRowHeader.setFixedCellWidth(chooserTableRowHeader.getFixedCellWidth());
        dataTableRowHeader.setFixedCellHeight(dataTable.getRowHeight());
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        dataTableRowHeader.setCellRenderer(new UtilsGUI.RowHeaderRenderer(utilsGUI2, chooserTable, false));
        dataTableScroll.setRowHeaderView(dataTableRowHeader);
        JScrollPane chooserScroll = new JScrollPane(chooserTable){
            private static final long serialVersionUID = 1L;

            public void setColumnHeaderView(Component view) {
            }
        };
        chooserScroll.setRowHeaderView(chooserTableRowHeader);
        chooserScroll.setVerticalScrollBarPolicy(22);
        chooserScroll.setHorizontalScrollBarPolicy(31);
        chooserScroll.getVerticalScrollBar().setEnabled(false);
        JScrollBar bar1 = dataTableScroll.getHorizontalScrollBar();
        final JScrollBar bar2 = chooserScroll.getHorizontalScrollBar();
        bar1.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar2.setValue(e.getValue());
            }
        });
        chooserScroll.setPreferredSize(new Dimension(500, 50));
        dataTableScroll.setPreferredSize(new Dimension(500, 150));
        chooserScroll.setBorder(new EmptyBorder(dataTableScroll.getInsets()));
        dataTableScroll.setBorder(new EmptyBorder(dataTableScroll.getInsets()));
        JPanel principalPanel = new JPanel();
        principalPanel.setLayout(new BorderLayout());
        principalPanel.add((Component)chooserScroll, "Center");
        principalPanel.add((Component)dataTableScroll, "South");
        return principalPanel;
    }

    private JTable buildChooserTable() {
        this.attTypes = new Hashtable();
        this.attTypes.put("numeric", (byte)0);
        this.attTypes.put("nominal", (byte)1);
        this.attTypes.put("cyclic", (byte)2);
        this.attTypes.put((byte)0, "numeric");
        this.attTypes.put((byte)1, "nominal");
        this.attTypes.put((byte)2, "cyclic");
        String[] comboValues = new String[]{(String)this.attTypes.get((byte)0), (String)this.attTypes.get((byte)1), (String)this.attTypes.get((byte)2)};
        AbstractTableModel chooserModel = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            public int getColumnCount() {
                return AttributeTypeChooserController.this.numAttributes;
            }

            public int getRowCount() {
                return 3;
            }

            public Object getValueAt(int row, int col) {
                return AttributeTypeChooserController.this.chooserData[row][col];
            }

            public void setValueAt(Object value, int row, int col) {
                int last = AttributeTypeChooserController.this.counterIndex;
                if (row == 2) {
                    if (col == AttributeTypeChooserController.this.counterIndex) {
                        AttributeTypeChooserController.this.counterIndex = -1;
                        ((AttributeTypeChooserController)AttributeTypeChooserController.this).chooserData[row][col] = false;
                    } else {
                        if (AttributeTypeChooserController.this.counterIndex != -1) {
                            ((AttributeTypeChooserController)AttributeTypeChooserController.this).chooserData[row][((AttributeTypeChooserController)AttributeTypeChooserController.this).counterIndex] = false;
                        }
                        ((AttributeTypeChooserController)AttributeTypeChooserController.this).chooserData[row][col] = true;
                        AttributeTypeChooserController.this.counterIndex = col;
                    }
                } else {
                    ((AttributeTypeChooserController)AttributeTypeChooserController.this).chooserData[row][col] = value;
                    if (row == 0 && value != "nominal") {
                        this.setValueAt(new Boolean(false), 1, col);
                    }
                }
                this.fireTableCellUpdated(row, col);
                if (AttributeTypeChooserController.this.counterIndex != -1) {
                    this.fireTableCellUpdated(row, last);
                }
            }

            public boolean isCellEditable(int row, int col) {
                if (row == 1) {
                    return AttributeTypeChooserController.this.chooserData[0][col] == "nominal";
                }
                return true;
            }
        };
        this.chooserData = new Object[3][this.numAttributes];
        int att = 0;
        while (att < this.numAttributes) {
            this.chooserData[0][att] = (String)this.attTypes.get(this.attributeType[att]);
            this.chooserData[1][att] = this.attributeIsString[att];
            this.chooserData[2][att] = this.counterIndexAux[att];
            ++att;
        }
        JTable chooserTable = new JTable(chooserModel);
        TableColumnModel columnModel = chooserTable.getColumnModel();
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        int att2 = 0;
        while (att2 < this.numAttributes) {
            UtilsGUI utilsGUI = this.utilsGUI;
            utilsGUI.getClass();
            UtilsGUI.EachRowEditor rowEditor = new UtilsGUI.EachRowEditor(utilsGUI, chooserTable);
            UtilsGUI.EachRowRenderer rowRenderer = new UtilsGUI.EachRowRenderer(this.utilsGUI);
            UtilsGUI utilsGUI2 = this.utilsGUI;
            utilsGUI2.getClass();
            rowEditor.setEditorAt(0, new UtilsGUI.ComboBoxEditor(utilsGUI2, comboValues));
            UtilsGUI utilsGUI3 = this.utilsGUI;
            utilsGUI3.getClass();
            rowRenderer.add(0, new UtilsGUI.ComboBoxRenderer(utilsGUI3, comboValues));
            rowEditor.setEditorAt(1, new UtilsGUI.CheckBoxEditor());
            rowRenderer.add(1, new CheckBoxRenderer());
            rowEditor.setEditorAt(2, new UtilsGUI.RadioButtonEditor(this.utilsGUI));
            rowRenderer.add(2, new UtilsGUI.RadioButtonRenderer(this.utilsGUI));
            columnModel.getColumn(att2).setCellEditor(rowEditor);
            columnModel.getColumn(att2).setCellRenderer(rowRenderer);
            ++att2;
        }
        chooserTable.setAutoResizeMode(0);
        chooserTable.setSelectionMode(0);
        return chooserTable;
    }

    private void getPreliminaries(File file) throws Exception {
        int att;
        String fileName = file.getName();
        if (fileName.regionMatches(true, fileName.length() - 5, ".arff", 0, 5)) {
            this.loader = new ArffLoader(file, this.numInstancesAux);
        } else if (fileName.regionMatches(true, fileName.length() - 4, ".txt", 0, 4)) {
            this.loader = new TxtLoader(file, this.numInstancesAux);
        } else {
            throw new IOException(resource.getString("fileExtensionException"));
        }
        this.loader.buildHeader();
        if (this.loader.getnumInitialInstances() < this.numInstancesAux) {
            this.numInstancesAux = this.loader.getnumInitialInstances();
        }
        boolean reading = true;
        int i = 0;
        while (reading && i < this.numInstancesAux) {
            reading = this.loader.getInstance();
            ++i;
        }
        this.instanceSet = this.loader.getInstanceSet();
        this.counterIndex = this.loader.getLikelyCounterIndex();
        this.numAttributes = this.instanceSet.numAttributes;
        this.attributeType = this.instanceSet.attributeType;
        this.attributeTypeOriginal = (byte[])this.attributeType.clone();
        this.attributeName = new String[this.numAttributes];
        this.attributeIsString = new boolean[this.numAttributes];
        int att2 = 0;
        while (att2 < this.numAttributes) {
            this.attributeName[att2] = this.instanceSet.getAttribute(att2).getAttributeName();
            this.attributeIsString[att2] = this.instanceSet.getAttribute(att2).isString();
            ++att2;
        }
        this.instances = new Object[this.numInstancesAux][this.numAttributes];
        int inst = 0;
        while (inst < this.numInstancesAux) {
            Instance instance = this.instanceSet.instances[inst];
            int att3 = 0;
            while (att3 < this.numAttributes) {
                this.instances[inst][att3] = instance.stringValue(att3);
                ++att3;
            }
            ++inst;
        }
        if (this.loader instanceof TxtLoader) {
            this.attributeIsString = new boolean[this.numAttributes];
            this.attributeType = new byte[this.numAttributes];
            att = 0;
            while (att < this.numAttributes) {
                this.attributeIsString[att] = false;
                this.attributeType[att] = 0;
                int inst2 = 0;
                while (inst2 < this.numInstancesAux) {
                    Instance instance = this.instanceSet.instances[inst2];
                    try {
                        Float.parseFloat(instance.stringValue(att));
                    }
                    catch (Exception e) {
                        this.attributeIsString[att] = true;
                        this.attributeType[att] = 1;
                        break;
                    }
                    ++inst2;
                }
                ++att;
            }
        }
        this.counterIndexAux = new boolean[this.numAttributes];
        att = 0;
        while (att < this.numAttributes) {
            this.counterIndexAux[att] = false;
            if (att == this.counterIndex) {
                this.counterIndexAux[att] = true;
            }
            ++att;
        }
        if (this.counterIndex != -1 && !this.attributeIsString[this.counterIndex]) {
            this.attributeType[this.counterIndex] = 0;
        }
    }

    protected void initTokenizer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(33, 255);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.whitespaceChars(9, 9);
        this.tokenizer.commentChar(37);
        this.tokenizer.quoteChar(34);
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.parseNumbers();
    }

    public Loader getLoader() {
        return this.loader;
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -9005292408131451196L;

        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (AttributeTypeChooserController.this.chooserData[0][column] == "nominal") {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

