/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.c45;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.datamining.datamanipulation.Options;

public class DecisionTreeOptions
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.c45.resources.DecisiontreeResource");
    private JCheckBox gainRatioCheckBox;
    private JCheckBox prunningCheckBox;
    private JTextField verbosityValueLabel;
    private JScrollBar verbosityScroll;
    private JTextField confidenceValueLabel;
    private JScrollBar confidenceScroll;

    public DecisionTreeOptions() {
        this.enableEvents(64L);
        this.setTitle(this.resource.getString("preferences"));
        this.setSize(220, 310);
        this.setResizable(false);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        FlowLayout leftFlowLayout = new FlowLayout();
        leftFlowLayout.setAlignment(0);
        FlowLayout rightFlowLayout = new FlowLayout();
        rightFlowLayout.setAlignment(2);
        GridLayout twoColumsLayout = new GridLayout();
        twoColumsLayout.setColumns(2);
        twoColumsLayout.setRows(1);
        GridLayout twoRowsLayout = new GridLayout();
        twoRowsLayout.setColumns(1);
        twoRowsLayout.setRows(2);
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(twoRowsLayout);
        northPanel.setBorder(new TitledBorder(border, this.resource.getString("prunning1")));
        contentPane.add((Component)northPanel, "North");
        JPanel prunningCheckBoxPanel = new JPanel();
        prunningCheckBoxPanel.setLayout(leftFlowLayout);
        this.prunningCheckBox = new JCheckBox(this.resource.getString("prunning2"));
        this.prunningCheckBox.setSelected(Options.getInstance().getIfUsingPrunning());
        this.prunningCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeOptions.this.confidenceScroll.setEnabled(DecisionTreeOptions.this.prunningCheckBox.isSelected());
                DecisionTreeOptions.this.confidenceValueLabel.setEnabled(DecisionTreeOptions.this.prunningCheckBox.isSelected());
            }
        });
        prunningCheckBoxPanel.add(this.prunningCheckBox);
        northPanel.add(prunningCheckBoxPanel);
        JPanel confidencePanel = new JPanel();
        confidencePanel.setLayout(twoColumsLayout);
        northPanel.add(confidencePanel);
        JPanel confidenceLabelPanel = new JPanel();
        confidenceLabelPanel.setLayout(leftFlowLayout);
        JLabel confidenceLabel = new JLabel(this.resource.getString("confidenceLevel"));
        confidenceLabel.setPreferredSize(new Dimension(100, 20));
        confidenceLabelPanel.add(confidenceLabel);
        confidencePanel.add(confidenceLabelPanel);
        int confidenceValue = (int)(Options.getInstance().getConfidenceLevel() * 100.0f);
        JPanel confidenceFieldPanel = new JPanel();
        confidenceFieldPanel.setLayout(leftFlowLayout);
        this.confidenceValueLabel = new JTextField(String.valueOf(confidenceValue) + "    ");
        this.confidenceValueLabel.setEnabled(Options.getInstance().getIfUsingPrunning());
        this.confidenceValueLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeOptions.this.fixConfidenceValues();
            }
        });
        this.confidenceValueLabel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DecisionTreeOptions.this.fixConfidenceValues();
            }
        });
        this.confidenceScroll = new JScrollBar();
        this.confidenceScroll.setMinimum(1);
        this.confidenceScroll.setMaximum(99);
        this.confidenceScroll.setVisibleAmount(0);
        this.confidenceScroll.setValue(100 - confidenceValue);
        this.confidenceScroll.setPreferredSize(new Dimension(16, 20));
        this.confidenceScroll.setEnabled(Options.getInstance().getIfUsingPrunning());
        this.confidenceScroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                DecisionTreeOptions.this.confidenceValueLabel.setText(String.valueOf(100 - e.getValue()));
            }
        });
        confidenceFieldPanel.add(this.confidenceValueLabel);
        confidenceFieldPanel.add(this.confidenceScroll);
        confidenceFieldPanel.add(new JLabel("%"));
        confidencePanel.add(confidenceFieldPanel);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(twoRowsLayout);
        contentPane.add((Component)centerPanel, "Center");
        JPanel gainRatioPanel = new JPanel();
        gainRatioPanel.setLayout(leftFlowLayout);
        gainRatioPanel.setBorder(new TitledBorder(border, this.resource.getString("gainRatio1")));
        this.gainRatioCheckBox = new JCheckBox(this.resource.getString("gainRatio2"));
        this.gainRatioCheckBox.setSelected(Options.getInstance().getIfUsingGainRatio());
        gainRatioPanel.add(this.gainRatioCheckBox);
        centerPanel.add(gainRatioPanel);
        JPanel verbosityPanel = new JPanel();
        verbosityPanel.setLayout(twoColumsLayout);
        verbosityPanel.setBorder(new TitledBorder(border, this.resource.getString("verbosity1")));
        centerPanel.add(verbosityPanel);
        JPanel verbosityLabelPanel = new JPanel();
        verbosityLabelPanel.setLayout(leftFlowLayout);
        JLabel verbosityLabel = new JLabel(this.resource.getString("verbosity2"));
        verbosityLabel.setPreferredSize(new Dimension(100, 20));
        verbosityLabelPanel.add(verbosityLabel);
        verbosityPanel.add(verbosityLabelPanel);
        int verbosityValue = Options.getInstance().getVerbosityLevel();
        JPanel verbosityFieldPanel = new JPanel();
        verbosityFieldPanel.setLayout(leftFlowLayout);
        this.verbosityValueLabel = new JTextField(String.valueOf(verbosityValue) + "    ");
        this.verbosityValueLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeOptions.this.fixVerbosityValues();
            }
        });
        this.verbosityValueLabel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DecisionTreeOptions.this.fixVerbosityValues();
            }
        });
        this.verbosityScroll = new JScrollBar();
        this.verbosityScroll.setMinimum(1);
        this.verbosityScroll.setMaximum(4);
        this.verbosityScroll.setVisibleAmount(0);
        this.verbosityScroll.setValue(5 - verbosityValue);
        this.verbosityScroll.setPreferredSize(new Dimension(16, 20));
        this.verbosityScroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                DecisionTreeOptions.this.verbosityValueLabel.setText(String.valueOf(5 - e.getValue()));
            }
        });
        verbosityFieldPanel.add(this.verbosityValueLabel);
        verbosityFieldPanel.add(this.verbosityScroll);
        verbosityPanel.add(verbosityFieldPanel);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new FlowLayout());
        contentPane.add((Component)southPanel, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.setPreferredSize(new Dimension(80, 25));
        buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Options.getInstance().setIfUsingGainRatio(DecisionTreeOptions.this.gainRatioCheckBox.isSelected());
                Options.getInstance().setIfUsingPrunning(DecisionTreeOptions.this.prunningCheckBox.isSelected());
                Options.getInstance().setVerbosityLevel(Integer.parseInt(DecisionTreeOptions.this.verbosityValueLabel.getText().trim()));
                Options.getInstance().setConfidenceLevel(Float.parseFloat(DecisionTreeOptions.this.confidenceValueLabel.getText().trim()) / 100.0f);
                DecisionTreeOptions.this.dispose();
            }
        });
        southPanel.add(buttonOK);
        JButton buttonCancel = new JButton(this.resource.getString("cancel"));
        buttonCancel.setMnemonic('C');
        buttonCancel.setPreferredSize(new Dimension(80, 25));
        buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeOptions.this.dispose();
            }
        });
        southPanel.add(buttonCancel);
    }

    private void fixVerbosityValues() {
        String text = this.verbosityValueLabel.getText();
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) break;
            ++i;
        }
        if (text.length() != i || text.length() == 0) {
            this.verbosityValueLabel.setText(String.valueOf(5 - this.verbosityScroll.getValue()) + "    ");
        } else {
            int value = Integer.parseInt(text);
            this.verbosityScroll.setValue(5 - value);
        }
    }

    private void fixConfidenceValues() {
        String text = this.confidenceValueLabel.getText();
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) break;
            ++i;
        }
        if (text.length() != i || text.length() == 0) {
            this.confidenceValueLabel.setText(String.valueOf(100 - this.confidenceScroll.getValue()) + "    ");
        } else {
            int value = Integer.parseInt(text);
            this.confidenceScroll.setValue(100 - value);
        }
    }
}

