/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Datasets
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle resource;
    private ArrayList<ArrayList<String>> attributes;
    private int numColumns;
    private ArrayList<Object[]> dataTable;
    private String[] columnNames;

    public Datasets(ResourceBundle resource) {
        this.resource = resource;
        this.buildDataTable();
    }

    public void buildDataTable() {
        this.dataTable = new ArrayList();
        this.attributes = new ArrayList();
        String[] columnNames = new String[]{this.resource.getString("activeTableHeader"), this.resource.getString("finishedTableHeader"), this.resource.getString("datasetNameTableHeader"), this.resource.getString("classTableHeader"), this.resource.getString("counterTableHeader"), this.resource.getString("fileTableHeader")};
        this.columnNames = columnNames;
        this.numColumns = columnNames.length;
    }

    public void loadScript(ArrayList<Object[]> dataTable) {
        this.dataTable = dataTable;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this.dataTable.size();
    }

    public void addRow(Object[] rowData) {
        this.dataTable.add(rowData);
    }

    public void removeDataset(int row) {
        if (row >= 0) {
            this.dataTable.remove(row);
            this.attributes.remove(row);
        }
    }

    public Object getValueAt(int row, int col) {
        return this.dataTable.get(row)[col];
    }

    public void setValueAt(Object value, int row, int col) {
        this.dataTable.get((int)row)[col] = value;
    }

    public boolean isActive(int i) {
        return (Boolean)this.dataTable.get(i)[0];
    }

    public String getDatasetName(int i) {
        return (String)this.dataTable.get(i)[2];
    }

    public String getDatasetFullName(int i) {
        return (String)this.dataTable.get(i)[5];
    }

    public int getClassIndex(int i) {
        int internalIndex = this.findAttribute((String)this.dataTable.get(i)[3], i);
        return --internalIndex;
    }

    public int getCounterIndex(int i) {
        int internalIndex = this.findAttribute((String)this.dataTable.get(i)[4], i);
        return --internalIndex;
    }

    private int findAttribute(String attributeName, int row) {
        ArrayList<String> attributes = this.attributes.get(row);
        int numAttributes = attributes.size();
        int att = 0;
        while (att < numAttributes) {
            if (attributes.get(att).equals(attributeName)) {
                return att;
            }
            ++att;
        }
        return -1;
    }

    public String getFilePath(int i) {
        return (String)this.dataTable.get(i)[5];
    }

    public ArrayList<Object[]> getDataTable() {
        return this.dataTable;
    }

    public String[] getAttributes(int row) {
        ArrayList<String> attributes = this.attributes.get(row);
        int numAttributes = attributes.size();
        String[] result = new String[numAttributes];
        int att = 0;
        while (att < numAttributes) {
            result[att] = new String(attributes.get(att));
            ++att;
        }
        return result;
    }

    public void addAttributes(ArrayList<String> newAttributes) {
        this.attributes.add(newAttributes);
    }

    public int getNumActiveData() {
        int numData = 0;
        int dataTableSize = this.dataTable.size();
        int i = 0;
        while (i < dataTableSize) {
            if (this.isActive(i)) {
                ++numData;
            }
            ++i;
        }
        return numData;
    }
}

