/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.datamining.classifiers.ClassifierIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classifiers
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle resource;
    private int numColumns;
    private ArrayList<Object[]> dataTable;
    private String[] columnNames;
    private String[] classifierNames = ClassifierIDs.getClassifierNames();

    public Classifiers(ResourceBundle resource) {
        this.resource = resource;
        this.buildDataTable();
    }

    public void buildDataTable() {
        this.dataTable = new ArrayList();
        String[] columnNames = new String[]{this.resource.getString("activeTableHeader"), this.resource.getString("classifierNameTableHeader")};
        this.columnNames = columnNames;
        this.numColumns = columnNames.length;
    }

    public void loadScript(ArrayList<Object[]> dataTable) {
        this.dataTable = dataTable;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this.dataTable.size();
    }

    public void addRow(Object[] rowData) {
        this.dataTable.add(rowData);
    }

    public void removeClassifier(int row) {
        if (row >= 0) {
            this.dataTable.remove(row);
        }
    }

    public Object getValueAt(int row, int col) {
        return this.dataTable.get(row)[col];
    }

    public void setValueAt(Object value, int row, int col) {
        this.dataTable.get((int)row)[col] = value;
    }

    public boolean getActive(int i) {
        return (Boolean)this.dataTable.get(i)[0];
    }

    public String getClassifierName(int i) {
        return (String)this.dataTable.get(i)[1];
    }

    public ArrayList<Object[]> getDataTable() {
        return this.dataTable;
    }

    public String[] getClassifierNames() {
        if (this.classifierNames == null) {
            this.classifierNames = ClassifierIDs.getClassifierNames();
        }
        return (String[])this.classifierNames.clone();
    }
}

