/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCAnalysis {
    private static Random rnd;

    public static float[][] computeROCPoints(float[] probs, InstanceSet testData, int positiveClass) {
        int numInstances = testData.numInstances();
        if (!testData.classIsNominal()) {
            System.out.println("numeric class");
            return null;
        }
        int negativeClass = 1 - positiveClass;
        int[] probsIndex = Utils.sortDescending(probs);
        float[] distribution = testData.getClassDistribution(false);
        float fp = 0.0f;
        float tp = 0.0f;
        float n = distribution[negativeClass];
        float p = distribution[positiveClass];
        float[][] rocPoints = new float[numInstances + 2][2];
        int classIndex = testData.classIndex;
        int counterIndex = testData.counterIndex;
        float[] newProbs = new float[numInstances + 2];
        float lastProb = Float.MIN_VALUE;
        int counter = 0;
        int i = 0;
        while (i < numInstances) {
            int inst = probsIndex[i];
            if (probs[inst] != lastProb) {
                ROCAnalysis.addRocPoint(fp, n, tp, p, rocPoints, counter);
                newProbs[counter] = probs[inst];
                ++counter;
                lastProb = probs[inst];
            }
            Instance instance = testData.instances[inst];
            if (instance.data[classIndex] == (float)positiveClass) {
                tp += instance.data[counterIndex];
            } else {
                fp += instance.data[counterIndex];
            }
            ++i;
        }
        ROCAnalysis.addRocPoint(fp, n, tp, p, rocPoints, counter);
        newProbs[counter] = 0.0f;
        float[][] rocPointsProbs = new float[++counter][3];
        i = 0;
        while (i < counter) {
            rocPointsProbs[i][0] = rocPoints[i][0];
            rocPointsProbs[i][1] = rocPoints[i][1];
            rocPointsProbs[i][2] = newProbs[i];
            ++i;
        }
        return rocPointsProbs;
    }

    private static void addRocPoint(float fp, float n, float tp, float p, float[][] rocPoints, int pos) {
        rocPoints[pos][0] = fp == n ? 1.0f : fp / n;
        rocPoints[pos][1] = tp == p ? 1.0f : tp / p;
    }

    public static double computeAUC(float[] probs, InstanceSet testData, int positiveClass) {
        int numInstances = testData.numInstances();
        if (!testData.classIsNominal()) {
            System.out.println("numeric class");
            return 0.0;
        }
        int negativeClass = 1 - positiveClass;
        int[] probsIndex = Utils.sortDescending(probs);
        float[] distribution = testData.getClassDistribution(false);
        float fp = 0.0f;
        float tp = 0.0f;
        float fpLast = 0.0f;
        float tpLast = 0.0f;
        float n = distribution[negativeClass];
        float p = distribution[positiveClass];
        int classIndex = testData.classIndex;
        int counterIndex = testData.counterIndex;
        double auc = 0.0;
        float lastProb = Float.MIN_VALUE;
        int counter = 0;
        int i = 0;
        while (i < numInstances) {
            int inst = probsIndex[i];
            if (probs[inst] != lastProb) {
                auc += ROCAnalysis.trapezoidArea(fp, fpLast, tp, tpLast);
                ++counter;
                lastProb = probs[inst];
                fpLast = fp;
                tpLast = tp;
            }
            Instance instance = testData.instances[inst];
            if (instance.data[classIndex] == (float)positiveClass) {
                tp += instance.data[counterIndex];
            } else {
                fp += instance.data[counterIndex];
            }
            ++i;
        }
        auc += ROCAnalysis.trapezoidArea(fp, fpLast, tp, tpLast);
        ++counter;
        if (Double.isNaN(auc /= (double)(p * n))) {
            return 0.0;
        }
        return auc;
    }

    private static double trapezoidArea(float fp, float fpLast, float tp, float tpLast) {
        double base = Math.abs(fp - fpLast);
        double height = (tp + tpLast) / 2.0f;
        return base * height;
    }

    public static ArrayList<float[]> computeConvexHull(ArrayList<float[]> rocPoints) {
        ROCAnalysis.sort(rocPoints);
        ROCAnalysis.removeRepeated(rocPoints);
        ROCAnalysis.removePointsUnderDiagonal(rocPoints);
        int numPoints = rocPoints.size();
        float[][] pointsABC = new float[3][2];
        pointsABC[0] = rocPoints.remove(0);
        pointsABC[1] = rocPoints.remove(--numPoints - 1);
        --numPoints;
        ArrayList<float[]> result = new ArrayList<float[]>();
        result.add(pointsABC[0]);
        result.add(pointsABC[1]);
        ROCAnalysis.convexHull(pointsABC, rocPoints, result);
        return result;
    }

    public static void removeRepeated(ArrayList<float[]> rocPoints) {
        int numPoints = rocPoints.size();
        float[] last = rocPoints.get(0);
        int i = 1;
        while (i < numPoints) {
            float[] current = rocPoints.get(i);
            if (ROCAnalysis.equal(last, current)) {
                rocPoints.remove(i);
                --i;
                --numPoints;
            } else {
                last = current;
            }
            ++i;
        }
        rocPoints.trimToSize();
    }

    private static boolean equal(float[] p1, float[] p2) {
        int num = p1.length;
        int i = 0;
        while (i < num) {
            if (Math.abs(p1[i] - p2[i]) > 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void convexHull(float[][] pointsABC, ArrayList<float[]> rocPoints, ArrayList<float[]> result) {
        if (rocPoints.size() == 0) {
            return;
        }
        float[] pointA = pointsABC[0];
        float[] pointB = pointsABC[1];
        float[] pointC = ROCAnalysis.getPointC(pointsABC, rocPoints, result);
        pointsABC[2] = pointC;
        ROCAnalysis.removePointsInsideABC(pointsABC, rocPoints);
        ArrayList<float[]> s1 = new ArrayList<float[]>();
        ArrayList<float[]> s2 = new ArrayList<float[]>();
        ROCAnalysis.buildS1S2(pointsABC, rocPoints, s1, s2);
        pointsABC[0] = pointA;
        pointsABC[1] = pointC;
        ROCAnalysis.convexHull(pointsABC, s1, result);
        pointsABC[0] = pointC;
        pointsABC[1] = pointB;
        ROCAnalysis.convexHull(pointsABC, s2, result);
    }

    public static void buildS1S2(float[][] pointsABC, ArrayList<float[]> rocPoints, ArrayList<float[]> s1, ArrayList<float[]> s2) {
        int numPoints = rocPoints.size();
        float[] pointA = pointsABC[0];
        float[] pointC = pointsABC[2];
        double dCA = ROCAnalysis.distance(pointC, pointA);
        int i = 0;
        while (i < numPoints) {
            float[] pointP = rocPoints.remove(i);
            double dPA = ROCAnalysis.distance(pointP, pointA);
            if (dPA < dCA) {
                s1.add(pointP);
            } else if (dPA > dCA) {
                s2.add(pointP);
            } else {
                boolean bl = true;
            }
            --i;
            --numPoints;
            ++i;
        }
        rocPoints.clear();
        s1.trimToSize();
        s2.trimToSize();
    }

    private static double distance(float[] point1, float[] point2) {
        double result = 0.0;
        int numAxis = point1.length;
        int axis = 0;
        while (axis < numAxis) {
            double dist = point1[axis] - point2[axis];
            result += dist * dist;
            ++axis;
        }
        return Math.sqrt(result);
    }

    public static void removePointsInsideABC(float[][] pointsABC, ArrayList<float[]> rocPoints) {
        float[] pointA = pointsABC[0];
        float[] pointB = pointsABC[1];
        float[] pointC = pointsABC[2];
        int numPoints = rocPoints.size();
        int counter = 0;
        int i = 0;
        while (i < numPoints) {
            float[] point = rocPoints.get(i);
            double dAB = ROCAnalysis.distancePointToLine(point, pointA, pointB);
            double dAC = ROCAnalysis.distancePointToLine(point, pointA, pointC);
            double dBC = ROCAnalysis.distancePointToLine(point, pointB, pointC);
            if (dAB <= 0.0 && dAC >= 0.0 && dBC >= 0.0) {
                rocPoints.remove(i);
                --i;
                --numPoints;
            }
            ++counter;
            ++i;
        }
        rocPoints.trimToSize();
    }

    private static float[] getPointC(float[][] pointsABC, ArrayList<float[]> rocPoints, ArrayList<float[]> result) {
        float[] pointC;
        float[] pointA = pointsABC[0];
        float[] pointB = pointsABC[1];
        int numPoints = rocPoints.size();
        int maxPointCindex = -1;
        double maxDistance = Double.MIN_VALUE;
        int i = 0;
        while (i < numPoints) {
            pointC = rocPoints.get(i);
            double d = -ROCAnalysis.distancePointToLine(pointC, pointA, pointB);
            if (d > maxDistance) {
                maxDistance = d;
                maxPointCindex = i;
            }
            ++i;
        }
        pointC = rocPoints.remove(maxPointCindex);
        result.add(pointC);
        return pointC;
    }

    public static void sort(ArrayList<float[]> rocPoints) {
        Object[] aux = rocPoints.toArray();
        Arrays.sort(aux, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                float[] p1 = (float[])arg0;
                float[] p2 = (float[])arg1;
                int i = 0;
                while (i < p1.length) {
                    float x = p1[i] - p2[i];
                    if (x < 0.0f) {
                        return -1;
                    }
                    if (x > 0.0f) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
        });
        int num = aux.length;
        rocPoints.clear();
        int i = 0;
        while (i < num) {
            rocPoints.add((float[])aux[i]);
            ++i;
        }
    }

    private static void removePointsUnderDiagonal(ArrayList<float[]> rocPoints) {
        int numPoints = rocPoints.size();
        int point = 1;
        while (point < numPoints - 1) {
            double d = rocPoints.get(point)[0] - rocPoints.get(point)[1];
            if (d >= 0.0) {
                rocPoints.remove(point);
                --point;
                --numPoints;
            }
            ++point;
        }
        rocPoints.trimToSize();
    }

    private static double distancePointToLine(float[] point, float[] pointA, float[] pointB) {
        float m;
        if (pointB[0] == pointA[0]) {
            return point[1] - pointB[1];
        }
        float a = m = (pointB[1] - pointA[1]) / (pointB[0] - pointA[0]);
        float b = -1.0f;
        float c = pointB[1] - m * pointB[0];
        double d = a * point[0] + b * point[1] + c;
        return d /= Math.sqrt(a * a + b * b);
    }

    public static float[][][] averageROCPoints(float[][][] rocPoints) {
        int nRocs = rocPoints.length;
        int numT = 0;
        int[] nPts = new int[nRocs];
        int roc = 0;
        while (roc < nRocs) {
            if (rocPoints[roc] == null) {
                boolean bl = true;
            }
            nPts[roc] = rocPoints[roc].length;
            numT += nPts[roc];
            ++roc;
        }
        float[] t = new float[numT];
        int count = 0;
        int roc2 = 0;
        while (roc2 < nRocs) {
            int i = 0;
            while (i < nPts[roc2]) {
                t[count] = rocPoints[roc2][i][2];
                ++count;
                ++i;
            }
            ++roc2;
        }
        Arrays.sort(t);
        ArrayList<float[]> avg = new ArrayList<float[]>();
        ArrayList<float[]> stdDev = new ArrayList<float[]>();
        int samples = numT / nRocs;
        double[] fprsumTemp = new double[nRocs];
        double[] tprsumTemp = new double[nRocs];
        int tIdx = 0;
        while (tIdx < numT) {
            int roc3 = 0;
            while (roc3 < nRocs) {
                int p = ROCAnalysis.rocPointAtThreshold(rocPoints[roc3], t[tIdx]);
                fprsumTemp[roc3] = rocPoints[roc3][p][0];
                tprsumTemp[roc3] = rocPoints[roc3][p][1];
                ++roc3;
            }
            float[] rocPointAvg = new float[2];
            float[] rocPointStdDev = new float[2];
            double[] rocPointAvgStdDev = Utils.computeMeanStdDev(fprsumTemp);
            rocPointAvg[0] = (float)rocPointAvgStdDev[0];
            rocPointStdDev[0] = (float)rocPointAvgStdDev[1];
            rocPointAvgStdDev = Utils.computeMeanStdDev(tprsumTemp);
            rocPointAvg[1] = (float)rocPointAvgStdDev[0];
            rocPointStdDev[1] = (float)rocPointAvgStdDev[1];
            avg.add(rocPointAvg);
            stdDev.add(rocPointStdDev);
            tIdx += numT / samples;
        }
        int numPoints = avg.size();
        if (((float[])avg.get(numPoints - 1))[0] != 0.0f || ((float[])avg.get(numPoints - 1))[1] != 0.0f) {
            float[] lastRocPointAvg = new float[]{0.0f, 0.0f};
            float[] lastRocPointStdDev = new float[]{0.0f, 0.0f};
            avg.add(lastRocPointAvg);
            stdDev.add(lastRocPointStdDev);
            ++numPoints;
        }
        float[][][] newRocPoints = new float[2][numPoints][];
        int i = 0;
        while (i < numPoints) {
            newRocPoints[0][i] = (float[])avg.get(i);
            newRocPoints[1][i] = (float[])stdDev.get(i);
            ++i;
        }
        return newRocPoints;
    }

    private static int rocPointAtThreshold(float[][] rocPoints, float threshold) {
        int numPoints = rocPoints.length;
        int i = 0;
        while (i < numPoints && rocPoints[i][2] > threshold) {
            ++i;
        }
        return i;
    }
}

