/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.discretize;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;
import unbbayes.datamining.discretize.IDiscretization;

public class RangeDiscretization
implements IDiscretization {
    private int numThresholds;
    private InstanceSet inst;

    public RangeDiscretization(InstanceSet inst) {
        this.inst = new InstanceSet(inst);
    }

    public void discretizeAttribute(Attribute att) throws Exception {
        this.discretizeAttribute(att, 10);
    }

    public void discretizeAttribute(Attribute att, int numThresholds) throws Exception {
        if (!att.isNumeric()) {
            throw new IllegalArgumentException("Attribute not numeric");
        }
        int numInstances = this.inst.numInstances();
        if (numInstances == 0) {
            return;
        }
        if (numThresholds < 1) {
            numThresholds = 1;
        }
        try {
            int position = att.getIndex();
            Attribute newAttribute = new Attribute(att.getAttributeName(), 1, true, numThresholds, position);
            float[] values = new float[numInstances];
            Enumeration enumInst = this.inst.enumerateInstances();
            int i = 0;
            while (enumInst.hasMoreElements()) {
                Instance instance = (Instance)enumInst.nextElement();
                values[i] = instance.getValue(att);
                ++i;
            }
            int maxIndex = Utils.maxIndex(values);
            double min = Utils.min(values);
            double ranges = ((double)values[maxIndex] - min) / (double)numThresholds;
            i = 0;
            while (i < numThresholds) {
                DecimalFormat df = new DecimalFormat("0.0#");
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setDecimalSeparator('.');
                df.setDecimalFormatSymbols(dfs);
                newAttribute.addValue(String.valueOf(df.format((double)i * ranges + min)) + "to" + df.format((double)(i + 1) * ranges + min));
                ++i;
            }
            this.inst.setAttributeAt(newAttribute, position);
            i = 0;
            while (i < numInstances) {
                byte newValue = (byte)Math.abs(((double)values[i] - min) / ranges);
                if (newValue == numThresholds) {
                    newValue = (byte)(newValue - 1);
                }
                this.inst.getInstance(i).setValue(position, (float)newValue);
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Attribute not found in InstanceSet " + e.getMessage());
        }
    }

    public void autoDiscretize() throws Exception {
        this.autoDiscretize(10);
    }

    public void autoDiscretize(int numThresholds) throws Exception {
        int numAttributes = this.inst.numAttributes();
        int i = 0;
        while (i < numAttributes) {
            Attribute att = this.inst.getAttribute(i);
            if (att.isNumeric()) {
                this.discretizeAttribute(att, numThresholds);
            }
            ++i;
        }
    }

    public InstanceSet getInstances() {
        return this.inst;
    }
}

