/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.utils.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    protected static final float DEFAULT_NUM_PRECISION = 0.01f;
    public static double SMALL = 1.0E-6;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");
    private static Random rnd;

    public static boolean eq(double a, double b) {
        return a - b < SMALL && b - a < SMALL;
    }

    public static boolean eq(byte a, byte b) {
        return a == b;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = doubles[0];
        int maxIndex = 0;
        int i = 0;
        while (i < doubles.length) {
            if (doubles[i] > maximum) {
                maxIndex = i;
                maximum = doubles[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maxIndex(float[] floats) {
        float maximum = floats[0];
        int maxIndex = 0;
        int i = 0;
        while (i < floats.length) {
            if (floats[i] > maximum) {
                maxIndex = i;
                maximum = floats[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maxIndex(int[] ints) {
        int maximum = ints[0];
        int maxIndex = 0;
        int i = 0;
        while (i < ints.length) {
            if (ints[i] > maximum) {
                maxIndex = i;
                maximum = ints[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public static double min(double[] doubles) {
        double minimum = doubles[0];
        int i = 0;
        while (i < doubles.length) {
            if (doubles[i] < minimum) {
                minimum = doubles[i];
            }
            ++i;
        }
        return minimum;
    }

    public static float min(float[] floats) {
        float minimum = floats[0];
        int i = 0;
        while (i < floats.length) {
            if (floats[i] < minimum) {
                minimum = floats[i];
            }
            ++i;
        }
        return minimum;
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        int i = 0;
        while (i < doubles.length) {
            sum += doubles[i];
            ++i;
        }
        Utils.normalize(doubles, sum);
    }

    public static void normalize(float[] floats) {
        float sum = 0.0f;
        int i = 0;
        while (i < floats.length) {
            sum += floats[i];
            ++i;
        }
        Utils.normalize(floats, sum);
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException(resource.getString("normalizeException1"));
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException(resource.getString("normalizeException2"));
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static void normalize(float[] floats, float sum) {
        if (Float.isNaN(sum)) {
            throw new IllegalArgumentException(resource.getString("normalizeException1"));
        }
        if (sum == 0.0f) {
            throw new IllegalArgumentException(resource.getString("normalizeException2"));
        }
        int i = 0;
        while (i < floats.length) {
            int n = i++;
            floats[n] = floats[n] / sum;
        }
    }

    public static void normalize(float[] data, float upperLimit, float lowerLimit) {
        float hi = Float.MIN_VALUE;
        float lo = Float.MAX_VALUE;
        if (upperLimit <= lowerLimit) {
            throw new IllegalArgumentException(resource.getString("normalizeException3"));
        }
        int i = 0;
        while (i < data.length) {
            hi = Math.max(hi, data[i]);
            lo = Math.min(lo, data[i]);
            ++i;
        }
        float fact = (upperLimit - lowerLimit) / (hi - lo);
        int i2 = 0;
        while (i2 < data.length) {
            data[i2] = (data[i2] - lo) * fact + lowerLimit;
            ++i2;
        }
    }

    public static float normalize(float data, float highestValue, float smallestValue, float upperLimit, float lowerLimit) {
        if (upperLimit <= lowerLimit) {
            throw new IllegalArgumentException(resource.getString("normalizeException3"));
        }
        data = (data - smallestValue) * (upperLimit - lowerLimit) / (highestValue - smallestValue) + lowerLimit;
        return data;
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        int i = 0;
        while (i < doubles.length) {
            sum += doubles[i];
            ++i;
        }
        return sum;
    }

    public static float sum(float[] floats) {
        float sum = 0.0f;
        int i = 0;
        while (i < floats.length) {
            sum += floats[i];
            ++i;
        }
        return sum;
    }

    public static int sum(int[] ints) {
        int sum = 0;
        int i = 0;
        while (i < ints.length) {
            sum += ints[i];
            ++i;
        }
        return sum;
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            int dotPosition = stringBuffer.length() - afterDecimalPoint;
            while (precisionValue < 0L && dotPosition < 1 || dotPosition < 0) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, 0);
                } else {
                    stringBuffer.insert(0, 0);
                }
                ++dotPosition;
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, 0);
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, 0);
            }
            int currentPos = stringBuffer.length() - 1;
            while (currentPos > dotPosition && stringBuffer.charAt(currentPos) == '0') {
                stringBuffer.setCharAt(currentPos--, ' ');
            }
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int dotPosition;
        String tempString = Utils.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        int i = 0;
        while (i < result.length) {
            result[i] = 32;
            ++i;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        int i2 = 0;
        while (i2 < dotPosition) {
            result[offset + i2] = tempString.charAt(i2);
            ++i2;
        }
        i2 = dotPosition + 1;
        while (i2 < tempString.length()) {
            result[offset + i2] = tempString.charAt(i2);
            ++i2;
        }
        return new String(result);
    }

    public static int[] sortAscending(float[] array) {
        return Utils.sort(array, false);
    }

    public static int[] sortDescending(float[] array) {
        return Utils.sort(array, true);
    }

    private static int[] sort(float[] array, boolean descending) {
        int numInstances = array.length;
        float[][] arrayAux = new float[numInstances][2];
        int i = 0;
        while (i < numInstances) {
            arrayAux[i][0] = array[i];
            arrayAux[i][1] = i;
            ++i;
        }
        Utils.sort(arrayAux);
        int[] index = new int[numInstances];
        if (descending) {
            int inst = 0;
            while (inst < numInstances) {
                index[inst] = (int)arrayAux[numInstances - inst - 1][1];
                ++inst;
            }
        } else {
            int inst = 0;
            while (inst < numInstances) {
                index[inst] = (int)arrayAux[inst][1];
                ++inst;
            }
        }
        return index;
    }

    public static void sort(float[][] array) {
        Comparator<float[]> comparator = new Comparator<float[]>(){

            @Override
            public int compare(float[] arg0, float[] arg1) {
                float[] p1 = arg0;
                float[] p2 = arg1;
                int i = 0;
                while (i < p1.length) {
                    float x = p1[i] - p2[i];
                    if (x < 0.0f) {
                        return -1;
                    }
                    if (x > 0.0f) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
        };
        Utils.sort(array, comparator);
    }

    public static void sortDescending(float[][] array) {
        Comparator<float[]> comparator = new Comparator<float[]>(){

            @Override
            public int compare(float[] arg0, float[] arg1) {
                float[] p1 = arg0;
                float[] p2 = arg1;
                int i = 0;
                while (i < p1.length) {
                    float x = p1[i] - p2[i];
                    if (x < 0.0f) {
                        return 1;
                    }
                    if (x > 0.0f) {
                        return -1;
                    }
                    ++i;
                }
                return 0;
            }
        };
        Utils.sort(array, comparator);
    }

    public static void sort(float[][] array, Comparator comparator) {
        Arrays.sort(array, comparator);
    }

    public static double[] getDistribution(double[] values) {
        int size = values.length;
        int j = 0;
        double currentValue = values[0];
        double[] resultArray = new double[size + 1];
        Arrays.sort(values);
        int i = 0;
        while (i < size) {
            if (values[i] == currentValue) {
                int n = j;
                resultArray[n] = resultArray[n] + values[i];
            } else {
                resultArray[++j] = values[i];
                currentValue = values[i];
            }
            ++i;
        }
        double[] resultArray2 = new double[j];
        System.arraycopy(resultArray, 1, resultArray2, 0, resultArray2.length);
        return resultArray2;
    }

    public static float[] getDistribution(float[] values) {
        int size = values.length;
        int j = 0;
        float currentValue = values[0];
        float[] resultArray = new float[size + 1];
        Arrays.sort(values);
        int i = 0;
        while (i < size) {
            if (values[i] == currentValue) {
                int n = j;
                resultArray[n] = resultArray[n] + values[i];
            } else {
                resultArray[++j] = values[i];
                currentValue = values[i];
            }
            ++i;
        }
        float[] resultArray2 = new float[j];
        System.arraycopy(resultArray, 1, resultArray2, 0, resultArray2.length);
        return resultArray2;
    }

    public static double[] getFrequency(double[] values) {
        int size = values.length;
        int j = 0;
        double currentValue = values[0];
        double[] resultArray = new double[size];
        Arrays.sort(values);
        int i = 0;
        while (i < size) {
            if (values[i] == currentValue) {
                int n = j;
                resultArray[n] = resultArray[n] + 1.0;
            } else {
                int n = ++j;
                resultArray[n] = resultArray[n] + 1.0;
                currentValue = values[i];
            }
            ++i;
        }
        double[] resultArray2 = new double[j + 1];
        System.arraycopy(resultArray, 0, resultArray2, 0, resultArray2.length);
        return resultArray2;
    }

    public static float[] getFrequency(float[] values) {
        int size = values.length;
        int j = 0;
        float currentValue = values[0];
        float[] resultArray = new float[size];
        Arrays.sort(values);
        int i = 0;
        while (i < size) {
            if (values[i] == currentValue) {
                int n = j;
                resultArray[n] = resultArray[n] + 1.0f;
            } else {
                int n = ++j;
                resultArray[n] = resultArray[n] + 1.0f;
                currentValue = values[i];
            }
            ++i;
        }
        float[] resultArray2 = new float[j + 1];
        System.arraycopy(resultArray, 0, resultArray2, 0, resultArray2.length);
        return resultArray2;
    }

    public static int[] arraysSum(int[] array1, int[] array2) {
        if (array1.length != array2.length) {
            return null;
        }
        int[] newArray = new int[array1.length];
        int i = 0;
        while (i < array1.length) {
            newArray[i] = array1[i] + array2[i];
            ++i;
        }
        return newArray;
    }

    public static double[] arraysSum(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            return null;
        }
        double[] newArray = new double[array1.length];
        int i = 0;
        while (i < array1.length) {
            newArray[i] = array1[i] + array2[i];
            ++i;
        }
        return newArray;
    }

    public static float[] arraysSum(float[] array1, float[] array2) {
        if (array1.length != array2.length) {
            return null;
        }
        float[] newArray = new float[array1.length];
        int i = 0;
        while (i < array1.length) {
            newArray[i] = array1[i] + array2[i];
            ++i;
        }
        return newArray;
    }

    public static ArrayList<double[]> stdDevMeanPerClass(InstanceSet instanceSet, int att) throws Exception {
        double temp;
        int count = instanceSet.numInstances;
        if (count < 2) {
            throw new Exception(resource.getString("emptyInstanceSet"));
        }
        if (instanceSet.attributeType[att] == 1) {
            throw new Exception(resource.getString("nominalAttribute"));
        }
        double MISSING_VALUE = Double.NaN;
        int counterIndex = instanceSet.counterIndex;
        int classIndex = instanceSet.classIndex;
        int numClasses = instanceSet.numClasses();
        double[] sumPerClass = new double[numClasses];
        double[] avgPerClass = new double[numClasses];
        double[] newavgPerClass = new double[numClasses];
        double[] instPerClass = new double[numClasses];
        double[] meanPerClass = new double[numClasses];
        double[] stdDevPerClass = new double[numClasses];
        int k = 0;
        while (k < numClasses) {
            sumPerClass[k] = 0.0;
            instPerClass[k] = 0.0;
            meanPerClass[k] = 0.0;
            ++k;
        }
        int i = 0;
        while (i < count) {
            double value = instanceSet.instances[i].data[att];
            int classValue = (int)instanceSet.instances[i].data[classIndex];
            double weight = instanceSet.instances[i].data[counterIndex];
            int n = classValue;
            meanPerClass[n] = meanPerClass[n] + value * weight;
            if ((double)classValue != MISSING_VALUE && value != MISSING_VALUE) {
                int w;
                if (i == 0) {
                    avgPerClass[classValue] = value;
                    int n2 = classValue;
                    instPerClass[n2] = instPerClass[n2] + 1.0;
                    w = 1;
                } else {
                    w = 0;
                }
                while ((double)w < weight) {
                    newavgPerClass[classValue] = value - avgPerClass[classValue];
                    int n3 = classValue;
                    newavgPerClass[n3] = newavgPerClass[n3] / (instPerClass[classValue] + 1.0);
                    int n4 = classValue;
                    newavgPerClass[n4] = newavgPerClass[n4] + avgPerClass[classValue];
                    temp = value - avgPerClass[classValue];
                    int n5 = classValue;
                    sumPerClass[n5] = sumPerClass[n5] + (temp *= value - newavgPerClass[classValue]);
                    avgPerClass[classValue] = newavgPerClass[classValue];
                    int n6 = classValue;
                    instPerClass[n6] = instPerClass[n6] + 1.0;
                    ++w;
                }
            }
            ++i;
        }
        k = 0;
        while (k < numClasses) {
            if (instPerClass[k] == 0.0) {
                meanPerClass[k] = 0.0;
                stdDevPerClass[k] = 0.0;
            } else {
                meanPerClass[k] = meanPerClass[k] / instPerClass[k];
                temp = instPerClass[k] > 1.0 ? sumPerClass[k] / (instPerClass[k] - 1.0) : (sumPerClass[k] + 1.0) / (instPerClass[k] + (double)numClasses - 1.0);
                stdDevPerClass[k] = Math.sqrt(temp);
            }
            ++k;
        }
        ArrayList<double[]> list = new ArrayList<double[]>(2);
        if (Double.isNaN(stdDevPerClass[0]) || Double.isNaN(stdDevPerClass[1])) {
            boolean bl = true;
        }
        list.add(0, stdDevPerClass);
        list.add(1, meanPerClass);
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public static double standardDeviation(InstanceSet instanceSet, int attribute, double mean) throws Exception {
        instancesEnum = instanceSet.enumerateInstances();
        att = instanceSet.getAttribute(attribute);
        sigma = 0.0;
        sqrSum = 0.0;
        numOfInstances = instanceSet.numInstances();
        if (numOfInstances == 0) {
            throw new Exception(Utils.resource.getString("emptyInstanceSet"));
        }
        if (!att.isNominal()) ** GOTO lbl13
        throw new Exception(Utils.resource.getString("nominalAttribute"));
lbl-1000:
        // 1 sources

        {
            instance = (Instance)instancesEnum.nextElement();
            temp = instance.data[attribute];
            sqrSum += (temp -= mean) * temp;
lbl13:
            // 2 sources

            ** while (instancesEnum.hasMoreElements())
        }
lbl14:
        // 1 sources

        sigma = Math.sqrt(sqrSum / (double)(numOfInstances - 1));
        return sigma;
    }

    /*
     * Unable to fully structure code
     */
    public static double mean(InstanceSet instanceSet, int attribute) throws Exception {
        instancesEnum = instanceSet.enumerateInstances();
        att = instanceSet.getAttribute(attribute);
        sum = 0.0;
        numOfInstances = instanceSet.numInstances();
        if (numOfInstances == 0) {
            throw new Exception(Utils.resource.getString("emptyInstanceSet"));
        }
        if (!att.isNominal()) ** GOTO lbl12
        throw new Exception(Utils.resource.getString("nominalAttribute"));
lbl-1000:
        // 1 sources

        {
            instance = (Instance)instancesEnum.nextElement();
            weight = instance.getWeight();
            sum += (double)(instance.data[attribute] * weight);
lbl12:
            // 2 sources

            ** while (instancesEnum.hasMoreElements())
        }
lbl13:
        // 1 sources

        return sum / (double)numOfInstances;
    }

    public static String keep2DigitsAfterDot(float floatValue) {
        String stringValue = String.valueOf(floatValue);
        int index = stringValue.indexOf(46);
        if (stringValue.length() > index + 3) {
            stringValue = stringValue.substring(0, index + 3);
        }
        return stringValue;
    }

    public static float[][] computeNominalDistribution(InstanceSet instanceSet, int att) {
        int numInstances = instanceSet.numInstances;
        int counterIndex = instanceSet.counterIndex;
        int classIndex = instanceSet.classIndex;
        int numClasses = instanceSet.numClasses();
        int numValues = instanceSet.attributes[att].numValues();
        float[][] distribution = new float[numValues][numClasses];
        int i = 0;
        while (i < numValues) {
            int j = 0;
            while (j < numClasses) {
                distribution[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        int inst = 0;
        while (inst < numInstances) {
            int instValue = (int)instanceSet.instances[inst].data[att];
            int classValue = (int)instanceSet.instances[inst].data[classIndex];
            float weight = instanceSet.instances[inst].data[counterIndex];
            float[] fArray = distribution[instValue];
            int n = classValue;
            fArray[n] = fArray[n] + weight;
            ++inst;
        }
        return distribution;
    }

    public static float[][][] computeNominalDistributions(InstanceSet instanceSet) throws Exception {
        int attIndex = 0;
        int numInstances = instanceSet.numInstances;
        int counterIndex = instanceSet.counterIndex;
        int classIndex = instanceSet.classIndex;
        int numAttributes = instanceSet.numAttributes;
        byte[] attributeType = instanceSet.attributeType;
        int numNominalAttributes = instanceSet.numNominalAttributes;
        int numClasses = 0;
        numClasses = instanceSet.numClasses();
        if (--numNominalAttributes < 1) {
            return null;
        }
        float[][][] distribution = new float[numClasses][numNominalAttributes][];
        int att = 0;
        while (att < numAttributes) {
            if (att != classIndex && attributeType[att] == 1) {
                int numValues = instanceSet.attributes[att].numValues();
                int k = 0;
                while (k < numClasses) {
                    distribution[k][attIndex] = new float[numValues];
                    ++k;
                }
                k = 0;
                while (k < numClasses) {
                    int v = 0;
                    while (v < numValues) {
                        distribution[k][attIndex][v] = 0.0f;
                        ++v;
                    }
                    ++k;
                }
                int inst = 0;
                while (inst < numInstances) {
                    int instValue = (int)instanceSet.instances[inst].data[att];
                    int classValue = (int)instanceSet.instances[inst].data[classIndex];
                    float weight = instanceSet.instances[inst].data[counterIndex];
                    float[] fArray = distribution[classValue][attIndex];
                    int n = instValue;
                    fArray[n] = fArray[n] + weight;
                    ++inst;
                }
                ++attIndex;
            }
            ++att;
        }
        return distribution;
    }

    public static double normalDensityFunction(double value, double stdDev, double mean) {
        double prob = 1.0f / (float)Math.sqrt(6.2831854820251465 * stdDev);
        double e = (value - mean) * (value - mean) / (2.0 * mean * mean);
        e = (float)Math.exp(-e);
        return prob *= e;
    }

    public static double getProbability(double data, double avg, double stdDev, float precision) {
        double zLower = (data - avg - (double)(precision / 2.0f)) / stdDev;
        double zUpper = (data - avg + (double)(precision / 2.0f)) / stdDev;
        double pLower = Statistics.normalProbability(zLower);
        double pUpper = Statistics.normalProbability(zUpper);
        return pUpper - pLower;
    }

    public static double getProbabilityBetween(double lower, double upper, double avg, double stdDev) {
        double m_Precision = 0.01;
        double zLower = (lower - avg - m_Precision / 2.0) / stdDev;
        double zUpper = (upper - avg + m_Precision / 2.0) / stdDev;
        double pLower = Statistics.normalProbability(zLower);
        double pUpper = Statistics.normalProbability(zUpper);
        return pUpper - pLower;
    }

    public static double getProbabilityFromMinusInf(double value, double avg, double stdDev) {
        double zValue = (value - avg) / stdDev;
        return Statistics.normalProbability(zValue);
    }

    public static double getProbabilityToPlusInf(double value, double avg, double stdDev) {
        double zValue = (value - avg) / stdDev;
        return 1.0 - Statistics.normalProbability(zValue);
    }

    public static void randomize(int[] index, Random random) {
        int size = index.length;
        int i = size - 1;
        while (i > 0) {
            int inst = (int)(random.nextDouble() * (double)i);
            int temp = index[i];
            index[i] = index[inst];
            index[inst] = temp;
            --i;
        }
    }

    public static void randomize(int[] index) {
        int size = index.length;
        int i = size - 1;
        while (i > 0) {
            int inst = (int)(Math.random() * (double)i);
            int temp = index[i];
            index[i] = index[inst];
            index[inst] = temp;
            --i;
        }
    }

    public static double[] computeMeanStdDev(double[] values) {
        int numValues = values.length;
        if (numValues < 2) {
            return null;
        }
        double avg = values[0];
        int count = 1;
        double sum = 0.0;
        int i = 1;
        while (i < numValues) {
            double newavg = avg + (values[i] - avg) / (double)count;
            sum += (values[i] - avg) * (values[i] - newavg);
            avg = newavg;
            ++count;
            ++i;
        }
        double[] result = new double[]{avg, Math.sqrt(sum / (double)(numValues - 1))};
        return result;
    }

    public static float[] removeRepeatedValues(float[] values) {
        int numValues = values.length;
        float[] valuesAux = new float[numValues];
        int counter = 0;
        valuesAux[counter] = values[0];
        float last = valuesAux[counter];
        ++counter;
        int i = 1;
        while (i < numValues) {
            float current = values[i];
            if (last != current) {
                valuesAux[counter] = current;
                last = current;
                ++counter;
            }
            ++i;
        }
        values = new float[counter];
        i = 0;
        while (i < counter) {
            values[i] = valuesAux[i];
            ++i;
        }
        return values;
    }

    public static double maxValue(double[] values) {
        return values[Utils.maxIndex(values)];
    }

    public static void invertOrder(float[] values) {
        int numValues = values.length;
        int i = 0;
        while (i < numValues / 2) {
            int auxIndex = numValues - 1 - i;
            float aux = values[auxIndex];
            values[auxIndex] = values[i];
            values[i] = aux;
            ++i;
        }
    }

    public static float computePrecision(float[] values) {
        int numValues = values.length;
        float precision = 0.01f;
        values = (float[])values.clone();
        Arrays.sort(values);
        int distinct = 0;
        float deltaSum = 0.0f;
        float lastValue = values[0];
        int i = 1;
        while (i < numValues) {
            float value = values[i];
            if (value != lastValue) {
                deltaSum += value - lastValue;
                lastValue = value;
                ++distinct;
            }
            if (distinct > 0) {
                precision = deltaSum / (float)distinct;
            }
            ++i;
        }
        return precision;
    }
}

