/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;

public class Stats {
    private float count;
    private double sum;
    private float sumSq;
    private double stdDev;
    private double mean;
    private float min;
    private float max;
    private InstanceSet instanceSet;
    private int attributeIndex;

    public Stats(InstanceSet instanceSet, int attributeIndex) {
        this.instanceSet = instanceSet;
        this.attributeIndex = attributeIndex;
        this.compute();
    }

    private void compute() {
        float MISSING_VALUE = Float.NaN;
        int counterIndex = this.instanceSet.counterIndex;
        this.count = this.instanceSet.numInstances;
        if (this.count < 2.0f) {
            this.stdDev = Double.NaN;
            return;
        }
        this.sum = 0.0;
        this.sumSq = 0.0f;
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        double avg = 0.0;
        double aux = 0.0;
        int inst = 0;
        int i = 0;
        while ((float)i < this.count) {
            double value = this.instanceSet.instances[i].data[this.attributeIndex];
            if (value != (double)MISSING_VALUE) {
                int w;
                if (i == 0) {
                    avg = this.instanceSet.instances[0].data[this.attributeIndex];
                    w = 1;
                } else {
                    w = 0;
                }
                double weight = this.instanceSet.instances[i].data[counterIndex];
                while ((double)w < weight) {
                    double newavg = avg + (value - avg) / (double)(inst + 1);
                    aux += (value - avg) * (value - newavg);
                    avg = newavg;
                    ++inst;
                    if (value < (double)this.min) {
                        this.min = (float)value;
                    }
                    if (value > (double)this.max) {
                        this.max = (float)value;
                    }
                    this.sum += value;
                    this.sumSq = (float)((double)this.sumSq + value * value);
                    ++w;
                }
            }
            ++i;
        }
        this.mean = this.sum / (double)inst;
        this.stdDev = Math.sqrt(aux / (double)(inst - 1));
        this.count = inst;
    }

    private void compute2() {
        int w;
        float weight;
        float value;
        float MISSING_VALUE = Float.NaN;
        int counterIndex = this.instanceSet.counterIndex;
        this.count = this.instanceSet.numInstances;
        if (this.count < 2.0f) {
            this.stdDev = Double.NaN;
            return;
        }
        this.sum = 0.0;
        this.sumSq = 0.0f;
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        int inst = 0;
        int i = 0;
        while ((float)i < this.count) {
            value = this.instanceSet.instances[i].data[this.attributeIndex];
            if (value != MISSING_VALUE) {
                weight = this.instanceSet.instances[i].data[counterIndex];
                w = 0;
                while ((float)w < weight) {
                    this.sum += (double)value;
                    this.sumSq += value * value;
                    ++inst;
                    ++w;
                }
            }
            ++i;
        }
        this.mean = this.sum / (double)inst;
        i = 0;
        while ((float)i < this.count) {
            value = this.instanceSet.instances[i].data[this.attributeIndex];
            if (value != MISSING_VALUE) {
                weight = this.instanceSet.instances[i].data[counterIndex];
                w = 0;
                while ((float)w < weight) {
                    this.stdDev += ((double)value - this.mean) * ((double)value - this.mean);
                    if (value < this.min) {
                        this.min = value;
                    }
                    if (value > this.max) {
                        this.max = value;
                    }
                    ++w;
                }
            }
            ++i;
        }
        this.stdDev = (float)Math.sqrt(this.stdDev / (double)(inst - 1));
        this.count = inst;
    }

    public float getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public float getSumSq() {
        return this.sumSq;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getMean() {
        return this.mean;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public String toString() {
        return "Count\t " + Utils.doubleToString(this.count, 8) + '\n' + "Min\t\t " + Utils.doubleToString(this.min, 8) + '\n' + "Max\t\t " + Utils.doubleToString(this.max, 8) + '\n' + "Sum\t\t " + Utils.doubleToString(this.sum, 8) + '\n' + "SumSq\t " + Utils.doubleToString(this.sumSq, 8) + '\n' + "Mean\t\t" + Utils.doubleToString(this.mean, 8) + '\n' + "StdDev\t" + Utils.doubleToString(this.stdDev, 8) + '\n';
    }
}

