/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.ArrayListEnumeration;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final byte NUMERIC = 0;
    public static final byte NOMINAL = 1;
    public static final byte CYCLIC = 2;
    private byte attributeType;
    private String attributeName;
    private boolean isString;
    private String[] stringValues;
    private ArrayList<String> stringValuesTemp;
    private float[] numberValues;
    private ArrayList<Float> numberValuesTemp;
    private int numValues;
    private Hashtable<String, Integer> hashtableString;
    private Hashtable<Float, Integer> hashtableNumber;
    private int attIndex;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");
    private InstanceSet instanceSet;

    public Attribute(String attributeName, String[] stringValues, int attIndex) {
        this.stringValues = stringValues;
        this.attIndex = attIndex;
        this.numValues = stringValues.length;
        this.hashtableString = new Hashtable(this.numValues);
        int i = 0;
        while (i < this.numValues) {
            this.hashtableString.put(stringValues[i], new Integer(i));
            ++i;
        }
        this.attributeName = attributeName;
        this.stringValues = stringValues;
        this.attributeType = 1;
        attIndex = -1;
        this.isString = true;
    }

    public Attribute(String attributeName, float[] numberValues, int attIndex) {
        this.attIndex = attIndex;
        this.numberValues = numberValues;
        this.numValues = numberValues.length;
        this.hashtableNumber = new Hashtable(this.numValues);
        int i = 0;
        while (i < this.numValues) {
            this.hashtableNumber.put(Float.valueOf(numberValues[i]), new Integer(i));
            ++i;
        }
        this.attributeName = attributeName;
        this.numberValues = numberValues;
        this.attributeType = 1;
        attIndex = -1;
        this.isString = false;
    }

    public Attribute(String attributeName, byte attributeType, boolean isString, int numValues) {
        this.attributeName = attributeName;
        this.attributeType = attributeType;
        this.isString = isString;
        this.attIndex = -1;
        if (attributeType == 1) {
            if (isString) {
                this.hashtableString = new Hashtable(numValues);
                this.stringValuesTemp = new ArrayList();
            } else {
                this.hashtableNumber = new Hashtable(numValues);
                this.numberValuesTemp = new ArrayList();
            }
        }
    }

    public Attribute(String attributeName, byte attributeType, boolean isString, int numValues, int attIndex) {
        this(attributeName, attributeType, isString, numValues);
        this.attIndex = attIndex;
    }

    public Attribute(Attribute source) {
        int i;
        this.attributeType = source.attributeType;
        this.attributeName = new String(source.attributeName);
        this.isString = source.isString;
        if (source.stringValuesTemp != null) {
            this.stringValuesTemp = (ArrayList)source.stringValuesTemp.clone();
        }
        if (source.numberValuesTemp != null) {
            this.numberValuesTemp = (ArrayList)source.numberValuesTemp.clone();
        }
        if (source.hashtableString != null) {
            this.hashtableString = (Hashtable)source.hashtableString.clone();
        }
        if (source.hashtableNumber != null) {
            this.hashtableNumber = (Hashtable)source.hashtableNumber.clone();
        }
        this.numValues = source.numValues;
        this.attIndex = source.attIndex;
        if (source.stringValues != null) {
            this.stringValues = new String[this.numValues];
            i = 0;
            while (i < this.numValues) {
                this.stringValues[i] = new String(source.stringValues[i]);
                ++i;
            }
        }
        if (source.numberValues != null) {
            this.numberValues = new float[this.numValues];
            i = 0;
            while (i < this.numValues) {
                this.numberValues[i] = source.numberValues[i];
                ++i;
            }
        }
    }

    public final Enumeration enumerateValues() {
        if (this.attributeType == 1 && (this.stringValues != null || this.numberValues != null)) {
            Object[] enumValues;
            if (this.stringValues != null) {
                enumValues = this.stringValues;
            } else {
                enumValues = new String[this.numValues];
                int i = 0;
                while (i < this.numValues) {
                    int auxValue = (int)this.numberValues[i];
                    enumValues[i] = this.numberValues[i] == (float)auxValue ? String.valueOf(auxValue) : String.valueOf(this.numberValues[i]);
                    ++i;
                }
            }
            final ArrayListEnumeration ale = new ArrayListEnumeration(enumValues);
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return ale.hasMoreElements();
                }

                public Object nextElement() {
                    Object oo = ale.nextElement();
                    return oo;
                }
            };
        }
        return null;
    }

    public final int getIndex() {
        return this.attIndex;
    }

    public final int indexOfValue(String key) {
        Integer attIndex;
        if (this.hashtableString != null && (attIndex = this.hashtableString.get(key)) != null) {
            return attIndex;
        }
        return -1;
    }

    public final int indexOfValue(Float key) {
        Integer attIndex;
        if (this.hashtableNumber != null && (attIndex = this.hashtableNumber.get(key)) != null) {
            return attIndex;
        }
        return -1;
    }

    public final boolean isNominal() {
        return this.attributeType == 1;
    }

    public final boolean isNumeric() {
        return this.attributeType == 0;
    }

    public boolean isCyclic() {
        return this.attributeType == 2;
    }

    public boolean isString() {
        return this.isString;
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final int numValues() {
        if (this.attributeType == 1) {
            return this.numValues;
        }
        return 0;
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@attribute " + this.attributeName + " ");
        if (this.isNominal()) {
            text.append('{');
            Enumeration enumeration = this.enumerateValues();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    text.append(enumeration.nextElement());
                    if (!enumeration.hasMoreElements()) continue;
                    text.append(',');
                }
            }
            text.append('}');
        } else if (this.isNumeric()) {
            text.append("numeric");
        } else if (this.isCyclic()) {
            text.append("cyclic");
        }
        return text.toString();
    }

    public final String value(int valIndex) {
        if (this.attributeType == 1 && valIndex >= 0 && valIndex <= this.numValues) {
            if (this.stringValues != null) {
                return this.stringValues[valIndex];
            }
            if (this.numberValues != null) {
                int auxValue = (int)this.numberValues[valIndex];
                if (this.numberValues[valIndex] == (float)auxValue) {
                    return String.valueOf(auxValue);
                }
                return String.valueOf(this.numberValues[valIndex]);
            }
        }
        return "";
    }

    public final int addValue(String value) {
        int key = this.indexOfValue(value);
        if (key == -1) {
            key = this.numValues;
            if (this.stringValuesTemp == null) {
                String[] newStringValues = new String[this.numValues + 1];
                int i = 0;
                while (i < this.numValues) {
                    newStringValues[i] = this.stringValues[i];
                    ++i;
                }
                newStringValues[this.numValues] = value;
                this.stringValues = newStringValues;
                this.instanceSet.setAttributeHasChanged(this.attIndex);
            } else {
                this.stringValuesTemp.add(value);
            }
            this.hashtableString.put(value, new Integer(key));
            ++this.numValues;
        }
        return key;
    }

    public final int addValue(float value) {
        int key = this.indexOfValue(Float.valueOf(value));
        if (key == -1) {
            key = this.numValues;
            if (this.numberValuesTemp == null) {
                float[] newNumberValues = new float[this.numValues + 1];
                int i = 0;
                while (i < this.numValues) {
                    newNumberValues[i] = this.numberValues[i];
                    ++i;
                }
                newNumberValues[this.numValues] = value;
                this.numberValues = newNumberValues;
                this.instanceSet.setAttributeHasChanged(this.attIndex);
            } else {
                this.numberValuesTemp.add(Float.valueOf(value));
            }
            this.hashtableNumber.put(Float.valueOf(value), new Integer(key));
            ++this.numValues;
        }
        return key;
    }

    public final void setIndex(int attIndex) {
        this.attIndex = attIndex;
    }

    public String[] getDistinticNominalValues() {
        if (this.attributeType == 1) {
            if (!this.isString) {
                String[] values = new String[this.numberValues.length];
                int i = 0;
                while (i < this.numValues) {
                    values[i] = String.valueOf(this.numberValues[i]);
                    ++i;
                }
                return values;
            }
            return (String[])this.stringValues.clone();
        }
        return null;
    }

    public float[] getDistinticNumericValues() {
        if (this.attributeType == 0) {
            if (this.numberValues != null) {
                return (float[])this.numberValues.clone();
            }
            int numInstances = this.instanceSet.numInstances;
            ArrayList<Float> numberValuesAux = new ArrayList<Float>();
            this.hashtableNumber = new Hashtable(numInstances);
            int i = 0;
            while (i < numInstances) {
                float value = this.instanceSet.instances[i].data[this.attIndex];
                if (!this.hashtableNumber.contains(Float.valueOf(value))) {
                    this.hashtableNumber.put(Float.valueOf(value), new Integer(i));
                    numberValuesAux.add(Float.valueOf(value));
                }
                ++i;
            }
            this.numValues = numberValuesAux.size();
            this.numberValues = new float[this.numValues];
            i = 0;
            while (i < this.numValues) {
                this.numberValues[i] = ((Float)numberValuesAux.get(i)).floatValue();
                ++i;
            }
            Arrays.sort(this.numberValues);
        }
        return null;
    }

    public byte getAttributeType() {
        return this.attributeType;
    }

    public void setFinal() {
        if (this.isString) {
            if (this.stringValuesTemp == null) {
                return;
            }
            this.stringValues = new String[this.numValues];
            int i = 0;
            while (i < this.numValues) {
                this.stringValues[i] = this.stringValuesTemp.get(i);
                ++i;
            }
            this.hashtableString.clear();
            this.hashtableString = null;
            this.stringValuesTemp.clear();
            this.stringValuesTemp = null;
        } else {
            if (this.numberValuesTemp == null) {
                return;
            }
            this.numberValues = new float[this.numValues];
            int i = 0;
            while (i < this.numValues) {
                this.numberValues[i] = this.numberValuesTemp.get(i).floatValue();
                ++i;
            }
            this.hashtableNumber.clear();
            this.hashtableNumber = null;
            this.numberValuesTemp.clear();
            this.numberValuesTemp = null;
        }
    }

    public InstanceSet getInstanceSet() {
        return this.instanceSet;
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }
}

