/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArffLoader
extends Loader {
    public static String FILE_EXTENSION = ".arff";
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");

    public ArffLoader(File file, int numLines) throws IOException {
        this.file = file;
        this.countInstancesFromFile(file, numLines, false);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        this.tokenizer = new StreamTokenizer(reader);
        this.initTokenizer();
    }

    @Override
    protected void initTokenizer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(33, 255);
        this.tokenizer.whitespaceChars(44, 44);
        this.tokenizer.commentChar(37);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.ordinaryChar(123);
        this.tokenizer.ordinaryChar(125);
        this.tokenizer.eolIsSignificant(true);
    }

    @Override
    public void buildHeader() throws IOException {
        this.readHeader();
    }

    @Override
    public ArrayList<Object> getHeaderInfo() throws IOException {
        ArrayList<String> attributesName = new ArrayList<String>();
        String likelycounterIndexName = null;
        String relationName = null;
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            this.errms(resource.getString("readHeaderException1"));
        }
        if (this.tokenizer.sval.equalsIgnoreCase("@relation")) {
            this.getNextToken();
            relationName = this.tokenizer.sval;
            if (relationName.equalsIgnoreCase("null")) {
                relationName = null;
            }
            this.getLastToken(false);
        } else {
            this.errms(resource.getString("readHeaderException2"));
        }
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            this.errms(resource.getString("readHeaderException1"));
        }
        while (this.tokenizer.sval.equalsIgnoreCase("@attribute")) {
            this.getNextToken();
            String attributesNameAux = this.tokenizer.sval;
            attributesName.add(attributesNameAux);
            this.getNextToken();
            if (attributesNameAux != null && attributesNameAux.equalsIgnoreCase(this.counterAttributeName)) {
                likelycounterIndexName = new String(attributesNameAux);
            }
            this.readTillEOL();
            this.getFirstToken();
            if (this.tokenizer.ttype != -1) continue;
            this.errms(resource.getString("readHeaderException1"));
        }
        this.numAttributes = attributesName.size();
        if (!this.tokenizer.sval.equalsIgnoreCase("@data")) {
            this.errms(resource.getString("readHeaderException7"));
        }
        if (this.numAttributes == 0) {
            this.errms(resource.getString("readHeaderException8"));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(attributesName);
        result.add(likelycounterIndexName);
        result.add(relationName);
        return result;
    }

    @Override
    public void readHeader() throws IOException {
        String relationName = "";
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            this.errms(resource.getString("readHeaderException1"));
        }
        if (this.tokenizer.sval.equalsIgnoreCase("@relation")) {
            this.getNextToken();
            relationName = this.tokenizer.sval;
            this.getLastToken(false);
        } else {
            this.errms(resource.getString("readHeaderException2"));
        }
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            this.errms(resource.getString("readHeaderException1"));
        }
        int counter = 0;
        this.compacted = false;
        while (this.tokenizer.sval.equalsIgnoreCase("@attribute")) {
            this.getNextToken();
            String attributeName = this.tokenizer.sval;
            this.getNextToken();
            if (attributeName.equalsIgnoreCase(this.counterAttributeName)) {
                this.likelyCounterIndex = counter;
            }
            if (counter == this.counterIndex) {
                this.compacted = true;
                this.counterAttributeName = attributeName;
                this.readTillEOL();
                this.getLastToken(false);
                this.getFirstToken();
                if (this.tokenizer.ttype == -1) {
                    this.errms(resource.getString("readHeaderException1"));
                }
                ++counter;
                continue;
            }
            if (this.tokenizer.ttype == -3) {
                if (this.tokenizer.sval.equalsIgnoreCase("real") || this.tokenizer.sval.equalsIgnoreCase("integer") || this.tokenizer.sval.equalsIgnoreCase("numeric")) {
                    attributes.add(new Attribute(attributeName, 0, false, this.initialInstances, attributes.size()));
                    this.readTillEOL();
                } else if (this.tokenizer.sval.equalsIgnoreCase("cyclic")) {
                    attributes.add(new Attribute(attributeName, 2, false, this.initialInstances, attributes.size()));
                    this.readTillEOL();
                } else {
                    this.errms(resource.getString("readHeaderException3"));
                }
            } else {
                ArrayList<String> stringValuesAux = new ArrayList<String>();
                ArrayList<Float> numberValuesAux = new ArrayList<Float>();
                this.tokenizer.pushBack();
                if (this.tokenizer.nextToken() != 123) {
                    this.errms(resource.getString("readHeaderException4"));
                }
                boolean isString = false;
                while (this.tokenizer.nextToken() != 125) {
                    if (this.tokenizer.ttype == 10) {
                        this.errms(resource.getString("readHeaderException5"));
                    }
                    try {
                        float numValue = (float)Double.parseDouble(this.tokenizer.sval);
                        numberValuesAux.add(Float.valueOf(numValue));
                    }
                    catch (NumberFormatException nfe) {
                        stringValuesAux.add(this.tokenizer.sval);
                        isString = true;
                    }
                }
                if (stringValuesAux.size() == 0 && numberValuesAux.size() == 0) {
                    this.errms(resource.getString("readHeaderException6"));
                }
                if (isString) {
                    int numStringValues = stringValuesAux.size();
                    int numNumericValues = numberValuesAux.size();
                    int totalSize = numStringValues + numNumericValues;
                    String[] stringValues = new String[totalSize];
                    int i = 0;
                    while (i < numStringValues) {
                        stringValues[i] = (String)stringValuesAux.remove(0);
                        ++i;
                    }
                    i = numStringValues;
                    while (i < totalSize) {
                        stringValues[i] = ((Float)numberValuesAux.remove(0)).toString();
                        ++i;
                    }
                    attributes.add(new Attribute(attributeName, stringValues, attributes.size()));
                } else {
                    int sizeValues = numberValuesAux.size();
                    float[] numberValues = new float[sizeValues];
                    int i = 0;
                    while (i < sizeValues) {
                        numberValues[i] = ((Float)numberValuesAux.remove(0)).floatValue();
                        ++i;
                    }
                    attributes.add(new Attribute(attributeName, numberValues, attributes.size()));
                }
            }
            this.getLastToken(false);
            this.getFirstToken();
            if (this.tokenizer.ttype == -1) {
                this.errms(resource.getString("readHeaderException1"));
            }
            ++counter;
        }
        this.numAttributes = attributes.size();
        this.attributeIsString = new boolean[this.numAttributes];
        Attribute[] attributesArray = new Attribute[this.numAttributes];
        int att = 0;
        while (att < this.numAttributes) {
            Attribute attribute;
            attributesArray[att] = attribute = (Attribute)attributes.get(att);
            this.attributeIsString[att] = attribute.isString();
            ++att;
        }
        this.instanceSet = new InstanceSet(this.initialInstances, attributesArray);
        this.instanceSet.setRelationName(relationName);
        this.instanceSet.setCounterAttributeName(this.counterAttributeName);
        this.attributeType = this.instanceSet.attributeType;
        if (!this.tokenizer.sval.equalsIgnoreCase("@data")) {
            this.errms(resource.getString("readHeaderException7"));
        }
        if (this.instanceSet.numAttributes() == 0) {
            this.errms(resource.getString("readHeaderException8"));
        }
    }

    @Override
    protected void getFirstToken() throws IOException {
        while (this.tokenizer.nextToken() == 10) {
        }
        if (this.tokenizer.ttype == 39 || this.tokenizer.ttype == 34) {
            this.tokenizer.ttype = -3;
        } else if (this.tokenizer.ttype == -3 && this.tokenizer.sval.equals("?")) {
            this.tokenizer.ttype = 63;
        }
    }

    protected void getLastToken(boolean endOfFileOk) throws IOException {
        if (!(this.tokenizer.nextToken() == 10 || this.tokenizer.nextToken() == -1 && endOfFileOk)) {
            this.errms(resource.getString("getLastTokenException1"));
        }
    }

    @Override
    protected void getNextToken() throws IOException {
        if (this.tokenizer.nextToken() == 10) {
            this.errms(resource.getString("getNextTokenException1"));
        }
        if (this.tokenizer.ttype == -1) {
            this.errms(resource.getString("getNextTokenException2"));
        } else if (this.tokenizer.ttype == 39 || this.tokenizer.ttype == 34) {
            this.tokenizer.ttype = -3;
        } else if (this.tokenizer.ttype == -3 && this.tokenizer.sval.equals("?")) {
            this.tokenizer.ttype = 63;
        }
    }

    private void readTillEOL() throws IOException {
        while (this.tokenizer.nextToken() != 10) {
        }
        this.tokenizer.pushBack();
    }

    @Override
    public boolean getInstance() throws IOException {
        if (this.instanceSet == null) {
            this.readHeader();
        }
        if (this.instanceSet.numAttributes() == 0) {
            this.errms(resource.getString("getInstanceException1"));
        }
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            return false;
        }
        return this.getInstanceAux();
    }

    @Override
    protected boolean getInstanceAux() throws IOException {
        float[] instance = new float[this.numAttributes + 1];
        float instanceWeight = 1.0f;
        int attIndex = 0;
        int columns = this.numAttributes;
        if (this.compacted) {
            ++columns;
        }
        int i = 0;
        while (i < columns) {
            block12: {
                if (i == this.counterIndex) {
                    try {
                        float numValue;
                        instanceWeight = numValue = (float)Double.parseDouble(this.tokenizer.sval);
                        break block12;
                    }
                    catch (NumberFormatException nfe) {
                        this.errms("Atributo de contagem inv\ufffdlido");
                    }
                }
                if (this.attributeType[attIndex] == 1) {
                    String stringValue = this.tokenizer.sval;
                    Attribute attribute = this.instanceSet.getAttribute(attIndex);
                    if (this.attributeIsString[attIndex]) {
                        stringValue = this.tokenizer.sval;
                        if (stringValue.equals("?")) {
                            instance[attIndex] = Float.NaN;
                        }
                        instance[attIndex] = attribute.addValue(stringValue);
                    } else {
                        float numValue = (float)Double.parseDouble(this.tokenizer.sval);
                        instance[attIndex] = attribute.addValue(numValue);
                    }
                } else {
                    try {
                        double numValue = Double.parseDouble(this.tokenizer.sval);
                        instance[attIndex] = (float)numValue;
                    }
                    catch (Exception e) {
                        boolean bl = true;
                    }
                }
                ++attIndex;
                this.tokenizer.nextToken();
            }
            ++i;
        }
        instance[attIndex] = instanceWeight;
        this.instanceSet.insertInstance(instance);
        return true;
    }

    public void buildAttributes(boolean[] buildNominalFromHeader, Attribute[] attributesAux) throws IOException {
        Attribute[] attributes = new Attribute[this.numAttributes];
        int numColumns = this.numAttributes;
        int attIndex = 0;
        if (this.compacted) {
            ++numColumns;
        }
        int att = 0;
        while (att < numColumns) {
            if (att != this.counterIndex) {
                attributes[attIndex] = buildNominalFromHeader[attIndex] ? attributesAux[att] : new Attribute(this.attributeName[attIndex], this.attributeType[attIndex], this.attributeIsString[attIndex], this.initialInstances, attIndex);
                ++attIndex;
            }
            ++att;
        }
        this.instanceSet = new InstanceSet(this.initialInstances, attributes);
        this.instanceSet.setCounterAttributeName(this.counterAttributeName);
        this.getFirstToken();
        while (!this.tokenizer.sval.equalsIgnoreCase("@data")) {
            this.readTillEOL();
            this.getLastToken(false);
            this.getFirstToken();
        }
        attIndex = 0;
    }
}

