/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.decisiontree;

import java.io.Serializable;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.Utils;

public class Leaf
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Attribute classAttribute;
    private float classValue;
    private int notClassValue;
    private float[] distribution;

    public Leaf(Attribute classAttribute, float[] distribution, float threshold, int positiveClass) {
        this.classAttribute = classAttribute;
        this.distribution = distribution;
        this.computeClass(threshold, positiveClass);
    }

    private void computeClass(float threshold, int positiveClass) {
        int negativeClass = Math.abs(1 - positiveClass);
        if (threshold > 0.0f) {
            double positiveRate = this.distribution[positiveClass] + 1.0f;
            this.classValue = (positiveRate /= (double)(this.distribution[positiveClass] + this.distribution[negativeClass] + 2.0f)) > (double)threshold ? (float)positiveClass : (float)negativeClass;
        } else {
            this.classValue = Utils.maxIndex(this.distribution);
        }
        this.notClassValue = (int)Math.abs(1.0f - this.classValue);
    }

    public int getClassValue() {
        return (int)this.classValue;
    }

    public float[] getDistribution() {
        if (this.distribution == null) {
            return null;
        }
        float[] arrayCopy = new float[this.distribution.length];
        System.arraycopy(this.distribution, 0, arrayCopy, 0, this.distribution.length);
        return arrayCopy;
    }

    public String toString() {
        if (Instance.isMissingValue(this.classValue)) {
            return "NULL";
        }
        float numberInst = 0.0f;
        float numberInstNonClass = 0.0f;
        int weightDistributionSize = this.distribution.length;
        int i = 0;
        while (i < weightDistributionSize) {
            numberInst += this.distribution[i];
            if ((float)i != this.classValue) {
                numberInstNonClass += this.distribution[i];
            }
            ++i;
        }
        String text = String.valueOf(this.classAttribute.getAttributeName()) + " = " + this.classAttribute.value((int)this.classValue) + " (" + Utils.keep2DigitsAfterDot(numberInst);
        text = numberInstNonClass != 0.0f ? String.valueOf(text) + "|" + Utils.keep2DigitsAfterDot(numberInstNonClass) + ")" : String.valueOf(text) + ")";
        return text;
    }

    public int getMatched() {
        return (int)this.distribution[(int)this.classValue];
    }

    public int getErrors() {
        return (int)this.distribution[this.notClassValue];
    }
}

