/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.decisiontree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import unbbayes.datamining.classifiers.decisiontree.DecisionTreeLearning;
import unbbayes.datamining.classifiers.decisiontree.Leaf;
import unbbayes.datamining.classifiers.decisiontree.Node;
import unbbayes.datamining.classifiers.decisiontree.NominalNode;
import unbbayes.datamining.classifiers.decisiontree.SplitObject;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.ClassifierUtils;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;

public class Id3
extends DecisionTreeLearning
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient ResourceBundle resource;
    private Node xRootNode;

    public void buildClassifier(InstanceSet data) throws Exception {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.classifiers.resources.ClassifiersResource");
        if (!data.getClassAttribute().isNominal()) {
            throw new Exception(this.resource.getString("exception1"));
        }
        Enumeration enumAtt = data.enumerateAttributes();
        while (enumAtt.hasMoreElements()) {
            if (!data.getAttribute(((Attribute)enumAtt.nextElement()).getIndex()).isNumeric()) continue;
            throw new Exception(this.resource.getString("exception1"));
        }
        Enumeration enumeration = data.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            enumAtt = data.enumerateAttributes();
            while (enumAtt.hasMoreElements()) {
                if (!instance.isMissing((Attribute)enumAtt.nextElement())) continue;
                throw new Exception(this.resource.getString("exception3"));
            }
        }
        this.makeTree(data);
    }

    protected void makeTree(InstanceSet data) throws Exception {
        int numInstances = data.numInstances();
        int numAttributes = data.numAttributes();
        int numClasses = data.numClasses();
        Attribute classAttribute = data.getClassAttribute();
        int classIndex = classAttribute.getIndex();
        ClassifierUtils utils = new ClassifierUtils(data);
        ArrayList<QueueComponent> queue = new ArrayList<QueueComponent>();
        ArrayList actualInst = new ArrayList(numInstances);
        Integer[] actualAtt = new Integer[numAttributes];
        int i = 0;
        while (i < numInstances) {
            actualInst.add(i);
            ++i;
        }
        i = 0;
        while (i < numAttributes) {
            actualAtt[i] = new Integer(i);
            ++i;
        }
        SplitObject split = new SplitObject(actualInst, actualAtt);
        Node xNode = this.xRootNode = new Node(null);
        queue.add(new QueueComponent(xNode, split));
        ArrayList numericDataList = new ArrayList();
        while (!queue.isEmpty()) {
            Leaf leaf;
            QueueComponent queueComponent = (QueueComponent)queue.remove(0);
            xNode = queueComponent.getNodeParent();
            split = queueComponent.splitObject;
            actualInst = split.getInstances();
            numInstances = actualInst.size();
            actualAtt = split.getAttributes();
            numAttributes = actualAtt.length;
            if (numInstances == 0) {
                leaf = new Leaf(classAttribute, xNode.distribution, this.threshold, this.positiveClass);
                xNode.add(leaf);
                continue;
            }
            double[] splitValues = new double[actualAtt.length];
            double[] infoGains = utils.computeInfoGain(split, splitValues, numericDataList);
            int attributeIndex = Utils.maxIndex(infoGains);
            int realAttribute = -1;
            int realIndex = 0;
            while (realIndex < numAttributes) {
                if (actualAtt[realIndex] != classIndex && ++realAttribute == attributeIndex) break;
                ++realIndex;
            }
            float[] distribution = new float[numClasses];
            int i2 = 0;
            while (i2 < numInstances) {
                Instance inst = data.getInstance((Integer)actualInst.get(i2));
                int n = inst.getClassValue();
                distribution[n] = distribution[n] + inst.getWeight();
                ++i2;
            }
            if (Utils.eq(infoGains[attributeIndex], 0.0)) {
                leaf = new Leaf(classAttribute, distribution, this.threshold, this.positiveClass);
                xNode.add(leaf);
                continue;
            }
            Attribute splitAttribute = data.getAttribute(actualAtt[realIndex]);
            SplitObject[] splitData = utils.splitData(split, realIndex);
            int j = 0;
            while (j < splitData.length) {
                NominalNode nominalNode = new NominalNode(splitAttribute, j, distribution);
                xNode.add(nominalNode);
                queue.add(new QueueComponent(nominalNode, splitData[j]));
                ++j;
            }
        }
    }

    public JTree getTree() {
        DefaultMutableTreeNode text2;
        Stack<Object> stackObj = new Stack<Object>();
        Stack<DefaultMutableTreeNode> stackTree = new Stack<DefaultMutableTreeNode>();
        DefaultMutableTreeNode treeNode = text2 = new DefaultMutableTreeNode("root");
        ArrayList<Object> root = this.xRootNode.children;
        int size = root.size();
        int i = 0;
        while (i < size) {
            stackObj.push(root.get(i));
            stackTree.push(treeNode);
            ++i;
        }
        while (!stackObj.empty()) {
            Object obj = stackObj.pop();
            treeNode = (DefaultMutableTreeNode)stackTree.pop();
            if (obj instanceof Leaf) {
                Leaf leaf = (Leaf)obj;
                treeNode.add(new DefaultMutableTreeNode(leaf.toString()));
                continue;
            }
            Node node = (Node)obj;
            DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(node.toString());
            treeNode.add(treeNodeChild);
            treeNode = treeNodeChild;
            ArrayList<Object> children = node.children;
            size = children.size();
            int i2 = 0;
            while (i2 < size) {
                stackObj.push(children.get(i2));
                stackTree.push(treeNode);
                ++i2;
            }
        }
        return new JTree(text2);
    }

    public String toString() {
        Stack<Object> stackObj = new Stack<Object>();
        Stack<Integer> stackLevel = new Stack<Integer>();
        StringBuffer text = new StringBuffer();
        ArrayList<Object> root = this.xRootNode.children;
        int size = root.size();
        int i = 0;
        while (i < size) {
            stackObj.push(root.get(i));
            stackLevel.push(1);
            ++i;
        }
        while (!stackObj.empty()) {
            Object obj = stackObj.pop();
            Integer level = (Integer)stackLevel.pop();
            if (obj instanceof Leaf) {
                Leaf leaf = (Leaf)obj;
                text.append(": " + leaf.toString());
                continue;
            }
            Node node = (Node)obj;
            if (level != 0) {
                text.append("\n");
                i = 0;
                while (i < level - 1) {
                    text.append("| ");
                    ++i;
                }
                text.append(node.toString());
            }
            ArrayList<Object> children = node.children;
            size = children.size();
            int i2 = 0;
            while (i2 < size) {
                stackObj.push(children.get(i2));
                stackLevel.push(level + 1);
                ++i2;
            }
        }
        return text.toString();
    }

    protected Leaf classifyInstanceAux(Instance instance) {
        Node treeNode = this.xRootNode;
        while (!(treeNode.children.get(0) instanceof Leaf)) {
            NominalNode node = (NominalNode)treeNode.children.get(0);
            int index = (int)instance.getValue(node.getAttribute());
            treeNode = (NominalNode)treeNode.children.get(index);
        }
        return (Leaf)treeNode.children.get(0);
    }

    private class QueueComponent {
        private SplitObject splitObject;
        private Node nodeParent;

        public QueueComponent(Node newParent, SplitObject splitObject) {
            this.nodeParent = newParent;
            this.splitObject = splitObject;
        }

        public Node getNodeParent() {
            return this.nodeParent;
        }

        public SplitObject getSplitObject() {
            return this.splitObject;
        }
    }
}

