/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers;

import java.util.Enumeration;
import java.util.HashMap;
import unbbayes.datamining.classifiers.DistributionClassifier;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.TreeVariable;

public class BayesianNetwork
extends DistributionClassifier {
    private Attribute classAttribute;
    private ProbabilisticNode classNode;
    private int classNodeIndex = -1;
    private int classAttributeIndex = -1;
    private ProbabilisticNetwork net;
    private InstanceSet instanceSet;
    private int numNodes;
    private int[] indexAttributes;
    private HashMap<Integer, float[]> hashMap;
    private int[] multipliers;
    private int numClasses = 0;

    public BayesianNetwork(ProbabilisticNetwork net, InstanceSet instanceSet) throws Exception {
        this.net = net;
        this.instanceSet = instanceSet;
        this.net.compile();
        this.numNodes = net.getNodeCount();
        this.multipliers = new int[this.numNodes - 1];
        this.indexAttributes = new int[instanceSet.numAttributes()];
        Enumeration enumeration = instanceSet.enumerateAttributes();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String attributeName = ((Attribute)enumeration.nextElement()).getAttributeName();
            this.indexAttributes[i] = net.getNodeIndex(attributeName);
            if (this.indexAttributes[i] == -1) {
                throw new Exception("Atributo n\ufffdo encontrado na rede: " + attributeName);
            }
            ++i;
        }
    }

    private boolean compareClasses(Attribute classAttribute, ProbabilisticNode node) {
        boolean equals = false;
        if (classAttribute.getAttributeName().compareToIgnoreCase(node.getName()) == 0 && classAttribute.numValues() <= node.getStatesSize()) {
            this.classNode = node;
            equals = true;
        }
        return equals;
    }

    public void buildClassifier(InstanceSet instances) throws Exception {
    }

    public float[] distributionForInstance(Instance instance) throws Exception {
        float instanceValue;
        float[] probs = new float[this.numClasses];
        if (this.classNodeIndex < 0) {
            throw new Exception("Classe n\ufffdo definida.");
        }
        boolean i = true;
        int hashCode = 0;
        int k = 0;
        int j = 0;
        while (j < this.numNodes) {
            if (j != this.classAttributeIndex) {
                instanceValue = instance.getValue(j);
                if (instanceValue != Float.NaN) {
                    hashCode = (int)((float)hashCode + instanceValue * (float)this.multipliers[k]);
                    ++k;
                } else {
                    int numValues = instance.getInstanceSet().getAttribute(j).numValues();
                    hashCode += numValues * this.multipliers[k];
                    ++k;
                }
            }
            ++j;
        }
        Integer hashInt = new Integer(hashCode);
        if (this.hashMap.containsKey(hashInt)) {
            probs = this.hashMap.get(hashInt);
        } else {
            this.net.initialize();
            j = 0;
            while (j < this.numNodes) {
                int actualNode = this.indexAttributes[j];
                if (actualNode != this.classNodeIndex && (instanceValue = instance.getValue(j)) != Float.NaN) {
                    ((TreeVariable)this.net.getNodeAt(actualNode)).addFinding((int)instanceValue);
                }
                ++j;
            }
            this.net.updateEvidences();
            j = 0;
            while (j < this.numClasses) {
                probs[j] = this.classNode.getMarginalAt(j);
                ++j;
            }
            this.hashMap.put(hashInt, probs);
        }
        return probs;
    }

    public String toString() {
        try {
            StringBuffer text = new StringBuffer("Bayesian SingleEntityNetwork\n");
            int i = 0;
            while (i < this.numNodes) {
                ProbabilisticNode node = (ProbabilisticNode)this.net.getNodeAt(i);
                text.append(node + "\n");
                ++i;
            }
            return text.toString();
        }
        catch (Exception e) {
            return resource.getString("exception5");
        }
    }

    public Attribute getClassAttribute() {
        return this.classAttribute;
    }

    public ProbabilisticNode getClassNode() {
        return this.classNode;
    }

    public void setClassAttribute(Attribute classAttribute) throws Exception {
        int j;
        boolean result = false;
        int i = 0;
        while (i < this.numNodes) {
            result = this.compareClasses(classAttribute, (ProbabilisticNode)this.net.getNodeAt(i));
            if (result) {
                this.classAttribute = classAttribute;
                this.classNodeIndex = this.net.getNodeIndex(classAttribute.getAttributeName());
                this.classAttributeIndex = classAttribute.getIndex();
                this.numClasses = this.classNode.getStatesSize();
                this.originalDistribution = new float[this.numClasses];
                j = 0;
                while (j < this.numClasses) {
                    this.originalDistribution[j] = this.classNode.getMarginalAt(j);
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (!result) {
            throw new Exception("Attributo classe n\ufffdo encontrado na rede");
        }
        this.hashMap = new HashMap(1500);
        int k = 0;
        i = 1;
        j = 0;
        while (j < this.numNodes) {
            if (j != this.classAttributeIndex) {
                this.multipliers[k] = i;
                i *= this.instanceSet.getAttribute(j).numValues() + 1;
                ++k;
            }
            ++j;
        }
    }

    public void resetNet() {
        try {
            this.net.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

