/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller.oobn;

import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import unbbayes.controller.NetworkController;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.oobn.node.OOBNNodeGraphicalWrapper;
import unbbayes.prs.Node;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.impl.DefaultOOBNNode;
import unbbayes.util.Debug;

public class OOBNClassController
extends NetworkController {
    private IOOBNClass controlledClass = null;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.controller.oobn.resources.OOBNControllerResources");

    protected OOBNClassController(SingleEntityNetwork singleEntityNetwork, NetworkWindow screen) {
        super(singleEntityNetwork, screen);
    }

    public static OOBNClassController newInstance(IOOBNClass oobnClass, NetworkWindow screen) {
        OOBNClassController ret = new OOBNClassController((SingleEntityNetwork)oobnClass.getNetwork(), screen);
        ret.setControlledClass(oobnClass);
        return ret;
    }

    public void insertProbabilisticNode(double x, double y) {
        OOBNNodeGraphicalWrapper node = OOBNNodeGraphicalWrapper.newInstance(DefaultOOBNNode.newInstance());
        ((Node)node).setPosition(x, y);
        ((ProbabilisticNode)node).appendState(resource.getString("firstStateProbabilisticName"));
        ((Node)node).setName(String.valueOf(resource.getString("probabilisticNodeName")) + this.getNetwork().getNodeCount());
        node.setDescription(((Node)node).getName());
        PotentialTable auxTabProb = node.getPotentialTable();
        auxTabProb.addVariable(node);
        auxTabProb.setValue(0, 1.0f);
        this.getNetwork().addNode(node);
    }

    public OOBNNodeGraphicalWrapper insertInstanceNode(IOOBNClass oobnClass, double x, double y) {
        if (this.getControlledClass().equals(oobnClass)) {
            throw new RuntimeException(resource.getString("OOBNClassCycle"));
        }
        DefaultOOBNNode wrappedNode = DefaultOOBNNode.newInstance();
        wrappedNode.setName(String.valueOf(oobnClass.getClassName()) + this.getNetwork().getNodeCount());
        wrappedNode.setParentClass(oobnClass);
        wrappedNode.setType(8);
        OOBNNodeGraphicalWrapper node = OOBNNodeGraphicalWrapper.newInstance(wrappedNode);
        node.setPosition(x, y);
        node.appendState(resource.getString("firstStateProbabilisticName"));
        node.setName(wrappedNode.getName());
        node.setDescription(node.getName());
        PotentialTable auxTabProb = node.getPotentialTable();
        auxTabProb.addVariable(node);
        auxTabProb.setValue(0, 1.0f);
        this.getNetwork().addNode(node);
        return node;
    }

    public IOOBNClass getControlledClass() {
        return this.controlledClass;
    }

    protected void setControlledClass(IOOBNClass controlledClass) {
        this.controlledClass = controlledClass;
    }

    public void keyPressed(KeyEvent e) {
        Debug.println(this.getClass(), "A key was pressed!!");
        if (e.getKeyCode() == 127) {
            Object selected = this.getScreen().getGraphPane().getSelected();
            this.getSENController().deleteSelected(selected);
            int i = 0;
            while (i < this.getScreen().getGraphPane().getSelectedGroup().size()) {
                selected = this.getScreen().getGraphPane().getSelectedGroup().get(i);
                this.getSENController().deleteSelected(selected);
                ++i;
            }
        }
        super.keyPressed(e);
    }
}

