/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JTable;

public class PrintTable
implements Printable,
Pageable {
    private static final int SIZE = 15;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.controller.resources.ControllerResources");
    protected List tables;
    protected List owners;
    protected PageFormat pageFormat;
    protected String title;

    public PrintTable(List tbs, List owners, PageFormat pf) {
        this.tables = tbs;
        this.owners = owners;
        this.pageFormat = pf;
    }

    public PrintTable(List tables, String title, PageFormat pageFormat) {
        this.tables = tables;
        this.pageFormat = pageFormat;
        this.owners = null;
        this.title = title;
    }

    public int print(Graphics g, PageFormat pf, int index) {
        Dimension size = null;
        int pageIndex = 0;
        int i = 0;
        while (i < this.tables.size()) {
            JTable table = (JTable)this.tables.get(i);
            if (table.getWidth() == 0 || table.getHeight() == 0) {
                table.setSize(table.getPreferredSize());
            }
            int tableWidth = table.getWidth();
            int tableHeight = table.getHeight();
            int positionX = 0;
            int positionY = 0;
            while (positionY < tableHeight) {
                positionX = 0;
                while (positionX < tableWidth) {
                    size = this.getPrintSize(table, positionX, positionY);
                    if (pageIndex == index) {
                        if (this.owners != null) {
                            this.paintTable(String.valueOf(resource.getString("nodeName")) + this.owners.get(i), table, g, positionX, positionY, size);
                        } else {
                            this.paintTable(this.title, table, g, positionX, positionY, size);
                        }
                        return 0;
                    }
                    ++pageIndex;
                    positionX += size.width;
                }
                positionY += size.height;
            }
            ++i;
        }
        return 1;
    }

    protected Dimension getPrintSize(JTable table, int positionX, int positionY) {
        int printHeight;
        Rectangle rect;
        int printWidth;
        int maxWidth = (int)this.pageFormat.getImageableWidth();
        int maxHeight = (int)(this.pageFormat.getImageableHeight() - 25.0);
        int lastCol = table.columnAtPoint(new Point(positionX + maxWidth, positionY));
        if (lastCol == -1) {
            printWidth = table.getWidth() - positionX;
        } else {
            rect = table.getCellRect(0, lastCol - 1, true);
            printWidth = rect.x + rect.width - positionX;
        }
        int lastRow = table.rowAtPoint(new Point(positionX, positionY + maxHeight));
        if (lastRow == -1) {
            printHeight = table.getHeight() - positionY;
        } else {
            rect = table.getCellRect(lastRow - 1, 0, true);
            printHeight = rect.y + rect.height - positionY;
        }
        return new Dimension(printWidth, printHeight);
    }

    protected void paintTable(String title, JTable table, Graphics g, int positionX, int positionY, Dimension size) {
        int offsetX = (int)this.pageFormat.getImageableX();
        int offsetY = (int)this.pageFormat.getImageableY();
        Shape lastClip = g.getClip();
        g.drawString(title, offsetX, offsetY + 15);
        g.translate(offsetX - positionX, offsetY - positionY + 25);
        g.clipRect(positionX, positionY, size.width, size.height);
        table.paint(g);
        g.setClip(lastClip);
        g.translate(-(offsetX - positionX), -(offsetY - positionY + 25));
    }

    public int getNumberOfPages() {
        Dimension size = null;
        int pageIndex = 0;
        int i = 0;
        while (i < this.tables.size()) {
            JTable table = (JTable)this.tables.get(i);
            if (table.getWidth() == 0 || table.getHeight() == 0) {
                table.setSize(table.getPreferredSize());
            }
            int tableWidth = table.getWidth();
            int tableHeight = table.getHeight();
            int positionX = 0;
            int positionY = 0;
            while (positionY < tableHeight) {
                positionX = 0;
                while (positionX < tableWidth) {
                    size = this.getPrintSize(table, positionX, positionY);
                    positionX += size.width;
                    ++pageIndex;
                }
                positionY += size.height;
            }
            ++i;
        }
        return pageIndex;
    }

    public Printable getPrintable(int index) {
        return this;
    }

    public PageFormat getPageFormat(int index) {
        return this.pageFormat;
    }
}

