/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import edu.isi.powerloom.PLI;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import java.awt.Cursor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JInternalFrame;
import javax.xml.bind.JAXBException;
import unbbayes.controller.ConfigurationsController;
import unbbayes.controller.MSBNController;
import unbbayes.controller.exception.InvalidFileNameException;
import unbbayes.controller.exception.ObjectToBeSavedDontExistsException;
import unbbayes.controller.oobn.OOBNController;
import unbbayes.gui.Configurations;
import unbbayes.gui.MSBNWindow;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.SplashScreen;
import unbbayes.gui.UnBBayesFrame;
import unbbayes.gui.oobn.OOBNWindow;
import unbbayes.io.BaseIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.configurations.ConfigurationsIOInputStream;
import unbbayes.io.exception.LoadException;
import unbbayes.io.mebn.PrOwlIO;
import unbbayes.io.mebn.UbfIO;
import unbbayes.io.mebn.exceptions.IOMebnException;
import unbbayes.io.oobn.impl.DefaultOOBNIO;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.oobn.IObjectOrientedBayesianNetwork;
import unbbayes.prs.oobn.impl.ObjectOrientedBayesianNetwork;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainController {
    private UnBBayesFrame screen;
    private static boolean PRE_LOAD_PROTEGE;
    private static boolean PRE_LOAD_POWERLOOM;
    private static ResourceBundle resource;

    static {
        resource = ResourceBundle.getBundle("unbbayes.controller.resources.ControllerResources");
    }

    public MainController() {
        try {
            this.loadConfigurations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.screen = new UnBBayesFrame(this);
    }

    public void loadConfigurations() throws IOException {
        ConfigurationsController configController = ConfigurationsController.getInstance();
        ConfigurationsIOInputStream configurationsIO = new ConfigurationsIOInputStream();
        try {
            Configurations configurations = configurationsIO.load(new File(configController.getFileConfigurationsPath()));
            configController.setConfigurations(configurations);
            configController.setFileOpenedSucessfull(true);
        }
        catch (IOException e) {
            configController.setFileOpenedSucessfull(false);
            throw e;
        }
    }

    public void saveConfigurations() throws IOException {
        ConfigurationsController configController = ConfigurationsController.getInstance();
        ConfigurationsIOInputStream configurationsIO = new ConfigurationsIOInputStream();
        configurationsIO.save(new File(configController.getFileConfigurationsPath()), configController.getConfigurations());
    }

    private void eagleLoader() {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.pack();
        splashScreen.setVisible(true);
        this.initializeLoadConfigurations();
        Debug.println("Init loader Protege");
        if (PRE_LOAD_PROTEGE) {
            ProtegeOWL.createJenaOWLModel();
        }
        Debug.println("Init loader Powerloom");
        if (PRE_LOAD_POWERLOOM) {
            PLI.initialize();
        }
        Debug.println("Finish loader");
        splashScreen.dispose();
    }

    private void initializeLoadConfigurations() {
        PRE_LOAD_POWERLOOM = true;
        PRE_LOAD_PROTEGE = true;
    }

    public void newPN() {
        ProbabilisticNetwork net = new ProbabilisticNetwork(resource.getString("NewPNName"));
        NetworkWindow netWindow = new NetworkWindow(net);
        this.screen.addWindow(netWindow);
    }

    public void newMSBN() {
        SingleAgentMSBN msbn = new SingleAgentMSBN(resource.getString("NewMSBNName"));
        MSBNController controller = new MSBNController(msbn);
        this.screen.addWindow(controller.getPanel());
    }

    public void newMEBN() {
        MultiEntityBayesianNetwork mebn = new MultiEntityBayesianNetwork(resource.getString("NewMEBNName"));
        NetworkWindow netWindow = new NetworkWindow(mebn);
        this.screen.addWindow(netWindow);
    }

    public void newOOBN() {
        ObjectOrientedBayesianNetwork oobn = ObjectOrientedBayesianNetwork.newInstance(resource.getString("NewOOBNName"));
        OOBNController controller = OOBNController.newInstance(oobn, this.screen);
        this.screen.addWindow(controller.getPanel());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveNet(File file) throws ObjectToBeSavedDontExistsException, IOMebnException, InvalidFileNameException, FileNotFoundException, IOException, Exception {
        this.screen.setCursor(new Cursor(3));
        UbfIO ubfIo = null;
        DefaultOOBNIO oobnIO = null;
        try {
            BaseIO io = null;
            JInternalFrame window = this.screen.getSelectedWindow();
            if (window == null) {
                throw new ObjectToBeSavedDontExistsException(resource.getString("windowDontExists"));
            }
            if (file.isDirectory()) {
                io = new NetIO();
                if (!(window instanceof MSBNWindow)) {
                    throw new ObjectToBeSavedDontExistsException(resource.getString("msbnDontExists"));
                }
                io.saveMSBN(file, ((MSBNWindow)window).getMSNet());
                return true;
            }
            String name = file.getName().toLowerCase();
            if (name.endsWith("net")) {
                io = new NetIO();
            } else if (name.endsWith("xml")) {
                io = new XMLBIFIO();
            } else if (name.endsWith("ubf")) {
                ubfIo = UbfIO.getInstance();
            } else if (name.endsWith("oobn") && window instanceof OOBNWindow) {
                oobnIO = DefaultOOBNIO.newInstance(((OOBNWindow)window).getController().getOobn());
            }
            if (io != null) {
                if (!(window instanceof NetworkWindow)) {
                    throw new ObjectToBeSavedDontExistsException(resource.getString("bnDontExists"));
                }
                io.save(file, ((NetworkWindow)window).getSingleEntityNetwork());
                return true;
            }
            if (ubfIo != null) {
                if (!(window instanceof NetworkWindow)) {
                    throw new ObjectToBeSavedDontExistsException(resource.getString("mebnDontExists"));
                }
                if (((NetworkWindow)window).getMultiEntityBayesianNetwork() == null) {
                    throw new ObjectToBeSavedDontExistsException(resource.getString("mebnDontExists"));
                }
                ubfIo.saveMebn(file, ((NetworkWindow)window).getMultiEntityBayesianNetwork());
                return true;
            }
            if (oobnIO == null) throw new InvalidFileNameException(resource.getString("withoutPosfixe"));
            if (!(window instanceof OOBNWindow)) return false;
            oobnIO.saveOOBNClass(file, ((OOBNWindow)window).getController().getActive().getController().getControlledClass());
            return true;
        }
        finally {
            this.screen.setCursor(new Cursor(0));
        }
    }

    public void loadNet(File file) throws LoadException, IOException, JAXBException, IOMebnException {
        this.screen.setCursor(new Cursor(3));
        try {
            JInternalFrame window = null;
            BaseIO io = null;
            if (file.isDirectory()) {
                io = new NetIO();
                SingleAgentMSBN msbn = io.loadMSBN(file);
                MSBNController controller = new MSBNController(msbn);
                window = controller.getPanel();
            } else {
                String name = file.getName().toLowerCase();
                if (name.endsWith("net")) {
                    io = new NetIO();
                    ProbabilisticNetwork net = io.load(file);
                    ConfigurationsController.getInstance().addFileToListRecentFiles(file);
                    window = new NetworkWindow(net);
                    ((NetworkWindow)window).setFileName(name);
                } else if (name.endsWith("xml")) {
                    io = new XMLBIFIO();
                    ProbabilisticNetwork net = io.load(file);
                    ConfigurationsController.getInstance().addFileToListRecentFiles(file);
                    window = new NetworkWindow(net);
                    ((NetworkWindow)window).setFileName(name);
                } else if (name.endsWith("owl")) {
                    PrOwlIO prOwlIo = new PrOwlIO();
                    MultiEntityBayesianNetwork mebn = prOwlIo.loadMebn(file);
                    ConfigurationsController.getInstance().addFileToListRecentFiles(file);
                    window = new NetworkWindow(mebn);
                    ((NetworkWindow)window).setFileName(name);
                } else if (name.endsWith("ubf")) {
                    UbfIO ubfIo = UbfIO.getInstance();
                    MultiEntityBayesianNetwork mebn = ubfIo.loadMebn(file);
                    ConfigurationsController.getInstance().addFileToListRecentFiles(file);
                    window = new NetworkWindow(mebn);
                    ((NetworkWindow)window).setFileName(name);
                } else if (name.endsWith("oobn")) {
                    DefaultOOBNIO oobnIO = DefaultOOBNIO.newInstance();
                    IObjectOrientedBayesianNetwork oobn = oobnIO.loadOOBN(file);
                    ConfigurationsController.getInstance().addFileToListRecentFiles(file);
                    OOBNController controller = OOBNController.newInstance(oobn, this.screen);
                    window = controller.getPanel();
                }
            }
            this.screen.addWindow(window);
        }
        finally {
            this.screen.setCursor(new Cursor(0));
        }
    }

    public ProbabilisticNetwork makeProbabilisticNetwork(ArrayList<Node> nodeList) {
        this.screen.setCursor(new Cursor(3));
        ProbabilisticNetwork net = new ProbabilisticNetwork("learned net");
        Node noFilho = null;
        Node noPai = null;
        Edge arcoAux = null;
        boolean direction = true;
        int i = 0;
        while (i < nodeList.size()) {
            noFilho = nodeList.get(i);
            net.addNode(noFilho);
            int j = 0;
            while (j < noFilho.getParents().size()) {
                noPai = noFilho.getParents().get(j);
                noPai.getChildren().add(noFilho);
                arcoAux = new Edge(noPai, noFilho);
                int k = 0;
                while (k < noPai.getParents().size() && direction) {
                    Node aux = noPai.getParents().get(k);
                    if (aux == noFilho) {
                        noPai.getParents().remove(k);
                        direction = false;
                    }
                    ++k;
                }
                arcoAux = new Edge(noPai, noFilho);
                arcoAux.setDirection(direction);
                direction = true;
                net.getEdges().add(arcoAux);
                ++j;
            }
            ++i;
        }
        return net;
    }

    public void showProbabilisticNetwork(ProbabilisticNetwork net) {
        NetworkWindow netWindow = new NetworkWindow(net);
        if (!netWindow.getNetworkController().compileNetwork()) {
            netWindow.changeToPNEditionPane();
        } else {
            netWindow.changeToPNCompilationPane();
        }
        this.screen.addWindow(netWindow);
        this.screen.setCursor(new Cursor(0));
    }
}

