/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.FormulaEditionPane;
import unbbayes.gui.mebn.formula.FormulaViewTree;
import unbbayes.gui.mebn.formula.exception.FormulaTreeConstructionException;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.StateLink;

public class FormulaTreeController {
    private FormulaViewTree formulaViewTree;
    private MEBNController mebnController;
    private ContextNode contextNode;
    private FormulaEditionPane formulaEditionPane;

    public FormulaTreeController(MEBNController _controller, ContextNode context, FormulaEditionPane _formulaEditionPane) {
        this.mebnController = _controller;
        this.contextNode = context;
        this.formulaEditionPane = _formulaEditionPane;
        this.formulaViewTree = new FormulaViewTree(this, context);
    }

    public void setContextNodeFormula(NodeFormulaTree formula) {
        this.contextNode.setFormulaTree(formula);
    }

    public FormulaViewTree getFormulaTree() {
        return this.formulaViewTree;
    }

    public void addOperatorAnd() throws Exception {
        this.formulaViewTree.addOperatorAnd();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorOr() throws Exception {
        this.formulaViewTree.addOperatorOr();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorNot() throws Exception {
        this.formulaViewTree.addOperatorNot();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorEqualTo() throws Exception {
        this.formulaViewTree.addOperatorEqualTo();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorIf() throws Exception {
        this.formulaViewTree.addOperatorIf();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorImplies() throws Exception {
        this.formulaViewTree.addOperatorImplies();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorForAll() throws Exception {
        this.formulaViewTree.addOperatorForAll();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void addOperatorExists() throws Exception {
        this.formulaViewTree.addOperatorExists();
        this.mebnController.updateFormulaActiveContextNode();
    }

    public void setNodeChoiceActive() {
        this.formulaEditionPane.setNodeTabActive();
    }

    public void setOVariableChoiveActive() {
        this.formulaEditionPane.setOVariableTabActive();
    }

    public void setVariableChoiceActive() {
        this.formulaEditionPane.setVariableTabActive();
    }

    public void addOVariable(OrdinaryVariable ov) throws FormulaTreeConstructionException {
        NodeFormulaTree nodePlace = this.formulaViewTree.getNodeFormulaActive();
        if (nodePlace != null) {
            if (nodePlace.getTypeNode() == EnumType.VARIABLE_SEQUENCE) {
                NodeFormulaTree nodeExemplar = new NodeFormulaTree(ov.getName(), EnumType.VARIABLE, EnumSubType.VARIABLE, ov);
                nodePlace.addChild(nodeExemplar);
                this.formulaViewTree.addNewNodeInTree(nodeExemplar);
            } else {
                nodePlace.setName(ov.getName());
                nodePlace.setNodeVariable(ov);
                nodePlace.setTypeNode(EnumType.OPERAND);
                nodePlace.setSubTypeNode(EnumSubType.OVARIABLE);
            }
            this.formulaViewTree.updateTree();
        }
    }

    public void addNode(ResidentNode node) {
        NodeFormulaTree nodePlace = this.formulaViewTree.getNodeFormulaActive();
        if (nodePlace != null) {
            nodePlace.setName(node.getName());
            ResidentNodePointer residentNodePointer = new ResidentNodePointer(node, this.contextNode);
            nodePlace.setNodeVariable(residentNodePointer);
            nodePlace.setTypeNode(EnumType.OPERAND);
            nodePlace.setSubTypeNode(EnumSubType.NODE);
            this.formulaViewTree.updateTree();
        }
    }

    public void addExemplar(OrdinaryVariable ov) {
        NodeFormulaTree nodePlace = this.formulaViewTree.getNodeFormulaActive();
    }

    public void addEntity(Entity entity) {
        NodeFormulaTree nodePlace = this.formulaViewTree.getNodeFormulaActive();
        if (nodePlace != null) {
            nodePlace.setName(entity.getName());
            nodePlace.setNodeVariable(entity);
            nodePlace.setTypeNode(EnumType.OPERAND);
            nodePlace.setSubTypeNode(EnumSubType.ENTITY);
            this.formulaViewTree.updateTree();
        }
    }

    public void addStateLink(StateLink link) {
        NodeFormulaTree nodePlace = this.formulaViewTree.getNodeFormulaActive();
        if (nodePlace != null) {
            nodePlace.setName(link.getState().getName());
            nodePlace.setNodeVariable(link);
            nodePlace.setTypeNode(EnumType.OPERAND);
            nodePlace.setSubTypeNode(EnumSubType.ENTITY);
            this.formulaViewTree.updateTree();
        }
    }

    public void showArgumentPanel(NodeFormulaTree nodeFormulaActive) {
        this.formulaEditionPane.setArgumentSelectionTab((ResidentNodePointer)nodeFormulaActive.getNodeVariable());
    }

    public ContextNode getContextNode() {
        return this.contextNode;
    }

    public void setContextNode(ContextNode contextNode) {
        this.contextNode = contextNode;
    }

    public void updateFormulaText() {
        this.contextNode.updateLabel();
        this.mebnController.updateFormulaActiveContextNode();
    }
}

