/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtil {
    private XMLUtil() {
    }

    public static Document getDocument(String poStringInput) throws Exception {
        Document retDocument = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(poStringInput.getBytes());
            DocumentBuilderFactory docBuilderfactory = DocumentBuilderFactory.newInstance();
            docBuilderfactory.setValidating(false);
            retDocument = docBuilderfactory.newDocumentBuilder().parse(in);
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return retDocument;
    }

    public static Document getDocument(InputSource poInputSource) throws Exception {
        Document retDocument = null;
        try {
            DocumentBuilderFactory docBuilderfactory = DocumentBuilderFactory.newInstance();
            docBuilderfactory.setValidating(false);
            retDocument = docBuilderfactory.newDocumentBuilder().parse(poInputSource);
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return retDocument;
    }

    public static String getXML(Document pDocument) throws Exception {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(pDocument), new StreamResult(out));
            retString = out.toString();
            out.close();
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return retString;
    }

    public static String getXML(Node pNode) {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(pNode), new StreamResult(out));
            retString = out.toString();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retString;
    }

    public static NodeList getNodeList(Document pDocument, String psTagName) {
        return pDocument.getDocumentElement().getElementsByTagName(psTagName);
    }

    public static Element getElement(Document pDocument, String psTagName, int index) {
        NodeList rows = pDocument.getDocumentElement().getElementsByTagName(psTagName);
        return (Element)rows.item(index);
    }

    public static int getSize(Document pDocument, String psTagName) {
        NodeList rows = pDocument.getDocumentElement().getElementsByTagName(psTagName);
        return rows.getLength();
    }

    public static String getValue(Document pDocument, String psTagName) throws Exception {
        String s = null;
        try {
            NodeList elements = pDocument.getDocumentElement().getElementsByTagName(psTagName);
            Node node = elements.item(0);
            NodeList nodes = node.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                s = nodes.item(i).getNodeValue().trim();
                if (s.equals("") || s.equals("\r")) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return s;
    }

    public static String getValue(Element pElement) throws Exception {
        String s = null;
        try {
            NodeList nodes = pElement.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                s = nodes.item(i).getNodeValue().trim();
                if (s.equals("") || s.equals("\r")) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return s;
    }

    public static String getValue(Node pNode) throws Exception {
        String s = null;
        try {
            NodeList nodes = pNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                s = nodes.item(i).getNodeValue().trim();
                if (s.equals("") || s.equals("\r")) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return s;
    }

    public static Document createDocument() {
        Document retDocument = null;
        try {
            DocumentBuilderFactory docBuilderfactory = DocumentBuilderFactory.newInstance();
            retDocument = docBuilderfactory.newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retDocument;
    }

    public static Node getNodeTree(Document poDocument, String xPath) {
        Node elementNode = null;
        Node node = null;
        try {
            elementNode = XPathAPI.selectSingleNode((Node)poDocument, (String)xPath);
            node = elementNode.cloneNode(true);
            elementNode = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return node;
    }

    public static void insertNode(Document poDocument, Node poNode, Node poNodeToInsert, boolean pbFlag) {
        Node elementNode = null;
        try {
            if (!pbFlag) {
                elementNode = poDocument.importNode(poNodeToInsert, true);
                poNode.appendChild(elementNode);
            } else {
                poNode.appendChild(poNodeToInsert);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void insertNode(Document poDocument, Node poNode, Node poNodeToInsert) {
        XMLUtil.insertNode(poDocument, poNode, poNodeToInsert, true);
    }
}

